/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import com.macrofocus.common.helper.WeakActionListeners
import com.macrofocus.docking.Dockable
import com.macrofocus.docking.DockingBar
import com.macrofocus.docking.swing.plaf.DockingAddon
import de.javasoft.docking.ui.addons.JYDockingAddon
import org.jdesktop.swingx.plaf.LookAndFeelAddons
import java.awt.*
import java.awt.event.ActionEvent
import java.awt.event.ActionListener
import javax.swing.*
import javax.swing.plaf.metal.MetalButtonUI

/**
 * User: luc
 * Date: Jun 7, 2006
 * Time: 11:31:00 AM
 */
class SwingDockable(insideComponent: JComponent?, shortTitle: String?, title: String?, description: String?, icon: Icon?) :
    Dockable<JComponent>, IconDockable<JComponent> {
    override var component: JPanel?
    private val view: DockingView
    var insideComponent: JComponent?
    override val description: String?
    override val shortTitle: String?
    override val title: String?
    override val iconURL: String?
    override val icon: Icon?
    private val detachButton: JButton
    private val hideButton: JButton
    override var dockingBar: DockingBar<JComponent>? = null
        get() = field
        set(value) {
            field = value
            detachButton.setVisible(value != null)
            hideButton.setVisible(value != null)
        }
    private val actionListeners: WeakActionListeners = WeakActionListeners()

    companion object {
        init {
            try {
                LookAndFeelAddons.contribute(JYDockingAddon())
                LookAndFeelAddons.contribute(DockingAddon())
            } catch (e: Throwable) {
                e.printStackTrace()
            }
        }
    }

    constructor(component: JComponent?, title: String?, icon: Icon?) : this(component, title, title, null, icon) {}

    override val container: JComponent
        get() = insideComponent!!

    override fun detachContainer(): JComponent? {
        view.setContentPane(Container())
        return insideComponent
    }

    override fun attachContainer() {
        view.setContentPane(insideComponent)
    }

    private val self: Dockable<JComponent>
        private get() = this

    val titledBar: DockingViewTitleBar?
        get() = view.getTitlebar()

    class TitleButton : JButton {
        override fun updateUI() {
            setUI(TitleButtonUI())
            setOpaque(false)
            setRolloverEnabled(true)
            setContentAreaFilled(false)
            setMargin(Insets(0, 0, 0, 0))
            setDefaultCapable(false)
            setFocusable(false)
        }

        constructor(icon: Icon?) : super(icon) {
            setBorder(BorderFactory.createEmptyBorder())
        }

        constructor() {
            setBorder(BorderFactory.createEmptyBorder())
        }
    }

    private class TitleButtonUI : MetalButtonUI() {
        protected override fun paintIcon(g1: Graphics, jcomponent: JComponent, rectangle: Rectangle) {
            var rectangle = rectangle
            val mytitlebutton = jcomponent as TitleButton
            if (mytitlebutton.getModel().isArmed() && mytitlebutton.getModel().isPressed()) rectangle =
                Rectangle(rectangle.x - 1, rectangle.y, rectangle.width, rectangle.height)
            super.paintIcon(g1, jcomponent, rectangle)
        }
    }

    override fun dispose() {
        dockingBar = null
        component = null
        insideComponent = null
    }

    init {
        this.insideComponent = insideComponent
        this.shortTitle = shortTitle
        this.title = title
        this.description = description
        this.icon = icon
        iconURL = null
        component = JPanel()
        component!!.setLayout(BorderLayout())
        view = DockingView("DecoratedDockable", "DecoratedDockable", "DecoratedDockable")
        view.title = title
        view.icon = icon
        view.setContentPane(insideComponent)
        component!!.add(view)
        val floatingIcon = ImageIcon(javaClass.getResource("floating.png"))
        detachButton = TitleButton(floatingIcon)
        detachButton.setToolTipText("Float")
        detachButton.setVisible(false)
        detachButton.addActionListener(actionListeners.create(object : ActionListener {
            override fun actionPerformed(e: ActionEvent) {
                dockingBar!!.setFloating(self, true)
            }
        }, detachButton))
        view.getTitlebar()!!.add(detachButton)
        hideButton = TitleButton(ImageIcon(javaClass.getResource("hideToolWindow.png")))
        hideButton.setToolTipText("Hide")
        hideButton.setVisible(false)
        hideButton.addActionListener(actionListeners.create(object : ActionListener {
            override fun actionPerformed(e: ActionEvent) {
                dockingBar!!.setActive(self, false)
            }
        }, hideButton))
        view.getTitlebar()!!.add(hideButton)
    }
}