/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import com.intellij.uiDesigner.core.GridConstraints
import com.intellij.uiDesigner.core.GridLayoutManager
import com.intellij.uiDesigner.core.Spacer
import com.macrofocus.docking.*
import com.macrofocus.docking.splitter.ThreeComponentsSplitter
import com.macrofocus.docking.swing.splitter.SwingThreeComponentsSplitter
import java.awt.Component
import java.awt.Dimension
import java.awt.Insets
import java.awt.event.ComponentEvent
import javax.swing.*

/**
 * User: luc
 * Date: Jun 1, 2006
 * Time: 9:27:26 AM
 */
class SwingDockingPanel @JvmOverloads constructor(private var vertical: Boolean = true) : JPanel(),
    DockingPanel<JComponent> {
    //    private final HashMap c = new HashMap();
    //    private final HashMap d = new HashMap();
    //    private final HashMap e = new HashMap();
    //    private final HashMap f = new HashMap();
    private var g: JLayeredPane? = null
    private var primarySplitter: ThreeComponentsSplitter<JComponent>? = null
    private var secondarySplitter: ThreeComponentsSplitter<JComponent>? = null
    override var westDockingBar: DockingBar<JComponent>? = null
    override var eastDockingBar: DockingBar<JComponent>? = null
    override var southDockingBar: DockingBar<JComponent>? = null
    override var northDockingBar: DockingBar<JComponent>? = null
    private var mainPanel: JPanel? = null
    var westContainerPanel: DockingContainer? = null
    var eastContainerPanel: DockingContainer? = null
    var southContainerPanel: DockingContainer? = null
    var northContainerPanel: DockingContainer? = null
    override fun updateUI() {
        if (innerComponent != null) {
            SwingUtilities.updateComponentTreeUI(innerComponent)
        }
        super.updateUI()
        val dockingBars: Array<DockingBar<JComponent>?> =
            arrayOf(westDockingBar, eastDockingBar, southDockingBar, northDockingBar)
        for (dockingBar in dockingBars) {
            if (dockingBar != null && dockingBar.dockables != null) {
                for (dockable in dockingBar.dockables!!) {
                    val component: JComponent? = dockable?.component
                    if (component != null) {
                        SwingUtilities.updateComponentTreeUI(component)
                    }
                    val container: JComponent? = dockable?.container
                    if (container != null) {
                        SwingUtilities.updateComponentTreeUI(container)
                    }
                }
            }
        }
    }

    private fun createUIComponents() {
        mainPanel = JPanel()
        westContainerPanel = DockingContainer()
        eastContainerPanel = DockingContainer()
        southContainerPanel = DockingContainer()
        northContainerPanel = DockingContainer()
        westDockingBar = SwingDockingBar(westContainerPanel!!, DockingAnchor.LEFT)
        eastDockingBar = SwingDockingBar(eastContainerPanel!!, DockingAnchor.RIGHT)
        southDockingBar = SwingDockingBar(southContainerPanel!!, DockingAnchor.BOTTOM)
        northDockingBar = SwingDockingBar(northContainerPanel!!, DockingAnchor.TOP)
        g = MyLayeredPane()
        setLayout(OverlayLayout(this))
        add(mainPanel)
        validate()
    }

    override fun setOrientation(vertical: Boolean) {
        if (!this.vertical != vertical) {
            this.vertical = vertical
            primarySplitter = null
            secondarySplitter = null
            updateLayout()
        }
    }

    fun updateLayout() {
        var innerComponent: JComponent? = null
        var secondaryRelativeSize: Boolean? = null
        var primaryRelativeSize: Boolean? = null
        var secondaryFirstSize: Double? = null
        var secondaryLastSize: Double? = null
        var primaryFirstSize: Double? = null
        var primaryLastSize: Double? = null
        if (secondarySplitter != null) {
            secondaryFirstSize = secondarySplitter!!.firstSize
            secondaryLastSize = secondarySplitter!!.lastSize
            innerComponent = secondarySplitter!!.innerComponent
            secondaryRelativeSize = secondarySplitter!!.isRelativeResize
        } else {
            secondarySplitter = SwingThreeComponentsSplitter(!vertical)
        }
        if (primarySplitter != null) {
            primaryFirstSize = primarySplitter!!.firstSize
            primaryLastSize = primarySplitter!!.lastSize
            primaryRelativeSize = primarySplitter!!.isRelativeResize
        } else {
            primarySplitter = SwingThreeComponentsSplitter(vertical)
            (g as MyLayeredPane?)!!.setComponent(primarySplitter!!.nativeComponent)
        }
        if (primaryRelativeSize != null) {
            primarySplitter!!.isRelativeResize = primaryRelativeSize
        }
        if (secondaryRelativeSize != null) {
            secondarySplitter!!.isRelativeResize = secondaryRelativeSize
        }
        if (primaryFirstSize != null) {
            primarySplitter!!.firstSize = primaryFirstSize
        }
        if (primaryLastSize != null) {
            primarySplitter!!.lastSize = primaryLastSize
        }
        if (secondaryFirstSize != null) {
            secondarySplitter!!.firstSize = secondaryFirstSize
        }
        if (secondaryLastSize != null) {
            secondarySplitter!!.lastSize = secondaryLastSize
        }
        if (vertical) {
            secondarySplitter!!.firstComponent = westContainerPanel
            secondarySplitter!!.innerComponent = innerComponent
            secondarySplitter!!.lastComponent = eastContainerPanel!!
            primarySplitter!!.firstComponent = northContainerPanel
            primarySplitter!!.innerComponent = secondarySplitter!!.nativeComponent
            primarySplitter!!.lastComponent = southContainerPanel
        } else {
            secondarySplitter!!.firstComponent = northContainerPanel
            secondarySplitter!!.innerComponent = innerComponent
            secondarySplitter!!.lastComponent = southContainerPanel
            primarySplitter!!.firstComponent = westContainerPanel
            primarySplitter!!.innerComponent = secondarySplitter!!.nativeComponent
            primarySplitter!!.lastComponent = eastContainerPanel
        }
        secondarySplitter!!.setShowDividerControls(true)
        primarySplitter!!.setShowDividerControls(true)
    }

    override var horizontalFirstDividerSize: Double
        get() = horizontalSplitter!!.firstSizeIfVisible
        set(size) {
            horizontalSplitter!!.firstSize = size.toInt().toDouble()
        }
    override var horizontalLastDividerSize: Double
        get() = horizontalSplitter!!.lastSizeIfVisible
        set(size) {
            horizontalSplitter!!.lastSize = size.toInt().toDouble()
        }
    override var verticalFirstDividerSize: Double
        get() = verticalSplitter!!.firstSizeIfVisible
        set(size) {
            verticalSplitter!!.firstSize = size.toInt().toDouble()
        }
    override var verticalLastDividerSize: Double
        get() = verticalSplitter!!.lastSizeIfVisible
        set(size) {
            verticalSplitter!!.lastSize = size.toInt().toDouble()
        }

    override fun setHorizontalRelativeSize(relativeResize: Boolean) {
        horizontalSplitter!!.isRelativeResize = relativeResize
    }

    override fun setVerticalRelativeResize(relativeResize: Boolean) {
        verticalSplitter!!.isRelativeResize = relativeResize
    }

    private val horizontalSplitter: ThreeComponentsSplitter<JComponent>?
        private get() = if (!vertical) {
            primarySplitter
        } else {
            secondarySplitter
        }
    private val verticalSplitter: ThreeComponentsSplitter<JComponent>?
        private get() = if (vertical) {
            primarySplitter
        } else {
            secondarySplitter
        }

//    fun getWestDockingBar(): DockingBar<JComponent>? {
//        return westDockingBar
//    }
//
//    fun getNorthDockingBar(): DockingBar<JComponent>? {
//        return northDockingBar
//    }
//
//    fun getSouthDockingBar(): DockingBar<JComponent>? {
//        return southDockingBar
//    }
//
//     fun getEastDockingBar(): DockingBar<JComponent>? {
//        return eastDockingBar
//    }

    override var innerComponent: JComponent?
        get() = if (secondarySplitter != null) secondarySplitter!!.innerComponent else null
        set(component) {
            secondarySplitter!!.innerComponent = component
        }
    override val nativeComponent: JComponent
        get() = this

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private fun `$$$setupUI$$$`() {
        createUIComponents()
        mainPanel!!.setLayout(GridLayoutManager(3, 3, Insets(0, 0, 0, 0), 0, 0))
        mainPanel!!.setMaximumSize(Dimension(10000, 10000))
        mainPanel!!.setMinimumSize(Dimension(-1, -1))
        mainPanel!!.setOpaque(false)
        mainPanel!!.setPreferredSize(Dimension(-1, -1))
        val panel1 = JPanel()
        panel1.setLayout(GridLayoutManager(2, 1, Insets(0, 0, 0, 0), 0, 0))
        panel1.setOpaque(false)
        mainPanel!!.add(
            panel1,
            GridConstraints(
                1,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        westDockingBar!!.nativeComponent.setOpaque(false)
        panel1.add(
            westDockingBar!!.nativeComponent,
            GridConstraints(
                0,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_NONE,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                Dimension(-1, 0),
                null,
                null,
                0,
                false
            )
        )
        val spacer1 = Spacer()
        panel1.add(
            spacer1,
            GridConstraints(
                1,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_VERTICAL,
                1,
                GridConstraints.SIZEPOLICY_WANT_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        val panel2 = JPanel()
        panel2.setLayout(GridLayoutManager(1, 1, Insets(0, 0, 0, 0), -1, -1))
        panel2.setOpaque(false)
        mainPanel!!.add(
            panel2,
            GridConstraints(
                2,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                Dimension(0, 0),
                Dimension(0, 0),
                null,
                0,
                false
            )
        )
        val panel3 = JPanel()
        panel3.setLayout(GridLayoutManager(1, 1, Insets(0, 0, 0, 0), -1, -1))
        panel3.setOpaque(false)
        mainPanel!!.add(
            panel3,
            GridConstraints(
                0,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        val panel4 = JPanel()
        panel4.setLayout(GridLayoutManager(2, 1, Insets(0, 0, 0, 0), 0, 0))
        panel4.setOpaque(false)
        mainPanel!!.add(
            panel4,
            GridConstraints(
                1,
                2,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        panel4.add(
            eastDockingBar!!.nativeComponent,
            GridConstraints(
                0,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_NONE,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                Dimension(-1, 0),
                null,
                null,
                0,
                false
            )
        )
        val spacer2 = Spacer()
        panel4.add(
            spacer2,
            GridConstraints(
                1,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_VERTICAL,
                1,
                GridConstraints.SIZEPOLICY_WANT_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        val panel5 = JPanel()
        panel5.setLayout(GridLayoutManager(1, 1, Insets(0, 0, 0, 0), -1, -1))
        panel5.setOpaque(false)
        mainPanel!!.add(
            panel5,
            GridConstraints(
                0,
                2,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        val panel6 = JPanel()
        panel6.setLayout(GridLayoutManager(1, 1, Insets(0, 0, 0, 0), -1, -1))
        panel6.setOpaque(false)
        mainPanel!!.add(
            panel6,
            GridConstraints(
                2,
                2,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                Dimension(0, 0),
                Dimension(0, 0),
                null,
                0,
                false
            )
        )
        val panel7 = JPanel()
        panel7.setLayout(GridLayoutManager(1, 2, Insets(0, 0, 0, 0), 0, 0))
        panel7.setOpaque(false)
        mainPanel!!.add(
            panel7,
            GridConstraints(
                2,
                1,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        panel7.add(
            southDockingBar!!.nativeComponent,
            GridConstraints(
                0,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_NONE,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                Dimension(0, -1),
                null,
                null,
                0,
                false
            )
        )
        val spacer3 = Spacer()
        panel7.add(
            spacer3,
            GridConstraints(
                0,
                1,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_HORIZONTAL,
                GridConstraints.SIZEPOLICY_WANT_GROW,
                1,
                null,
                null,
                null,
                0,
                false
            )
        )
        g!!.setAlignmentX(0.5f)
        mainPanel!!.add(
            g,
            GridConstraints(
                1,
                1,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_WANT_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_WANT_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        val panel8 = JPanel()
        panel8.setLayout(GridLayoutManager(1, 2, Insets(0, 0, 0, 0), -1, -1))
        panel8.setOpaque(true)
        mainPanel!!.add(
            panel8,
            GridConstraints(
                0,
                1,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_BOTH,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                null,
                null,
                null,
                0,
                false
            )
        )
        panel8.add(
            northDockingBar!!.nativeComponent,
            GridConstraints(
                0,
                0,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_NONE,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                GridConstraints.SIZEPOLICY_CAN_SHRINK or GridConstraints.SIZEPOLICY_CAN_GROW,
                Dimension(0, -1),
                null,
                null,
                0,
                false
            )
        )
        val spacer4 = Spacer()
        panel8.add(
            spacer4,
            GridConstraints(
                0,
                1,
                1,
                1,
                GridConstraints.ANCHOR_CENTER,
                GridConstraints.FILL_HORIZONTAL,
                GridConstraints.SIZEPOLICY_WANT_GROW,
                1,
                null,
                null,
                null,
                0,
                false
            )
        )
    }

    /** @noinspection ALL
     */
    fun `$$$getRootComponent$$$`(): JComponent? {
        return mainPanel
    }

    private inner class MyLayeredPane : JLayeredPane() {
        var jComponent: JComponent? = null

        //        public final Image getBottomImage()
        //        {
        //            BufferedImage bufferedimage = (BufferedImage)a.get();
        //            if(bufferedimage == null || bufferedimage.getWidth(null) < getWidth() || bufferedimage.getHeight(null) < getHeight())
        //            {
        //                int i1 = Math.max(Math.max(1, getWidth()), ToolWindowsPane.this.b.getWidth());
        //                int j1 = Math.max(Math.max(1, getHeight()), ToolWindowsPane.this.b.getHeight());
        //                if(SystemInfo.isWindows || SystemInfo.isMac)
        //                    bufferedimage = ToolWindowsPane.this.b.getGraphicsConfiguration().createCompatibleImage(i1, j1);
        //                else
        //                    bufferedimage = new BufferedImage(i1, j1, 1);
        //                a = new SoftReference(bufferedimage);
        //            }
        //            return bufferedimage;
        //        }
        //
        //        public final Image getTopImage()
        //        {
        //            BufferedImage bufferedimage = (BufferedImage)b.get();
        //            if(bufferedimage == null || bufferedimage.getWidth(null) < getWidth() || bufferedimage.getHeight(null) < getHeight())
        //            {
        //                int i1 = Math.max(Math.max(1, getWidth()), ToolWindowsPane.this.b.getWidth());
        //                int j1 = Math.max(Math.max(1, getHeight()), ToolWindowsPane.this.b.getHeight());
        //                if(SystemInfo.isWindows || SystemInfo.isMac)
        //                    bufferedimage = ToolWindowsPane.this.b.getGraphicsConfiguration().createCompatibleImage(i1, j1);
        //                else
        //                    bufferedimage = new BufferedImage(i1, j1, 1);
        //                b = new SoftReference(bufferedimage);
        //            }
        //            return bufferedimage;
        //        }
        protected override fun processComponentEvent(componentevent: ComponentEvent) {
            if (101 == componentevent.getID()) {
                val i1: Int = getWidth()
                val j1: Int = getHeight()
                if (i1 < 0 || j1 < 0) return
                val acomponent: Array<Component> = getComponentsInLayer(JLayeredPane.DEFAULT_LAYER.toInt())
                for (k1 in acomponent.indices) {
                    val component = acomponent[k1]
                    component.setBounds(0, 0, getWidth(), getHeight())
                }

//                acomponent = getComponentsInLayer(JLayeredPane.PALETTE_LAYER.intValue());
//                for(int l1 = 0; l1 < acomponent.length; l1++)
//                {
//                    Component component1 = acomponent[l1];
//                    if(!(component1 instanceof InternalDecorator))
//                        continue;
//                    WindowInfo windowinfo = (WindowInfo)f.get(component1);
//                    if(windowinfo == null)
//                        continue;
//                    float f1;
//                    if(ToolWindowAnchor.TOP == windowinfo.getAnchor() || ToolWindowAnchor.BOTTOM == windowinfo.getAnchor())
//                        f1 = (float)component1.getHeight() / (float)getHeight();
//                    else
//                        f1 = (float)component1.getWidth() / (float)getWidth();
//                    setBoundsInPaletteLayer(component1, windowinfo.getAnchor(), f1);
//                }
                validate()
                repaint()
            } else {
                super.processComponentEvent(componentevent)
            }
        }

        fun setComponent(jComponent: JComponent) {
            if (this.jComponent != null) {
                remove(this.jComponent)
            }
            add(jComponent, JLayeredPane.DEFAULT_LAYER)
            jComponent.setBounds(0, 0, getWidth(), getHeight())
            this.jComponent = jComponent
            validate()
        }

        //        public final void setBoundsInPaletteLayer(Component component, ToolWindowAnchor toolwindowanchor, float f1)
        //        {
        //            if(f1 < 0.0F)
        //                f1 = 0.33F;
        //            else
        //            if(f1 > 1.0F)
        //                f1 = 1.0F;
        //            if(ToolWindowAnchor.TOP == toolwindowanchor)
        //                component.setBounds(0, 0, getWidth(), (int)((float)getHeight() * f1 + 0.5F));
        //            else
        //            if(ToolWindowAnchor.LEFT == toolwindowanchor)
        //                component.setBounds(0, 0, (int)((float)getWidth() * f1 + 0.5F), getHeight());
        //            else
        //            if(ToolWindowAnchor.BOTTOM == toolwindowanchor)
        //            {
        //                int i1 = (int)((float)getHeight() * f1 + 0.5F);
        //                component.setBounds(0, getHeight() - i1, getWidth(), i1);
        //            } else
        //            if(ToolWindowAnchor.RIGHT == toolwindowanchor)
        //            {
        //                int j1 = (int)((float)getWidth() * f1 + 0.5F);
        //                component.setBounds(getWidth() - j1, 0, j1, getHeight());
        //            } else
        //            {
        //                ToolWindowsPane.a.error("unknown anchor " + toolwindowanchor);
        //            }
        //        }
        //        private SoftReference a;
        //        private SoftReference b;
        init {
            //            a = new SoftReference(null);
//            b = new SoftReference(null);
            setOpaque(false)
            //            setBackground(Color.gray);
            enableEvents(1L)
        }
    }

    //    private final class MyUISettingsListenerImpl
    //        implements UISettingsListener
    //    {
    //
    //        public final void uiSettingsChanged(UISettings uisettings)
    //        {
    //            a();
    //        }
    //
    //        private MyUISettingsListenerImpl()
    //        {
    //            super();
    //        }
    //
    //    }
    //
    //    private final class SetEditorComponentCmd extends FinalizableCommand
    //    {
    //
    //        public void run()
    //        {
    //            a(b);
    //            g.validate();
    //            g.repaint();
    //            finish();
    //            break MISSING_BLOCK_LABEL_45;
    //            Exception exception;
    //            exception;
    //            finish();
    //            throw exception;
    //        }
    //
    //        private final JComponent b;
    //
    //        public SetEditorComponentCmd(JComponent jcomponent, Runnable runnable)
    //        {
    //            super(runnable);
    //            b = jcomponent;
    //        }
    //    }
    //
    //    private final class RemoveSlidingComponentCmd extends FinalizableCommand
    //    {
    //
    //        public final void run()
    //        {
    //            UISettings uisettings;
    //            Rectangle rectangle;
    //            Image image;
    //            Graphics g1;
    //            uisettings = UISettings.getInstance();
    //            if(d || !uisettings.ANIMATE_WINDOWS)
    //                break MISSING_BLOCK_LABEL_251;
    //            rectangle = b.getBounds();
    //            image = g.getTopImage();
    //            g1 = image.getGraphics();
    //            b.paint(g1);
    //            g1.dispose();
    //            break MISSING_BLOCK_LABEL_70;
    //            Exception exception;
    //            exception;
    //            g1.dispose();
    //            throw exception;
    //            Image image1;
    //            Graphics g2;
    //            image1 = g.getBottomImage();
    //            g2 = image1.getGraphics();
    //            g.remove(b);
    //            g2.clipRect(0, 0, rectangle.width, rectangle.height);
    //            g2.translate(-rectangle.x, -rectangle.y);
    //            g.paint(g2);
    //            g2.dispose();
    //            break MISSING_BLOCK_LABEL_163;
    //            Exception exception1;
    //            exception1;
    //            g2.dispose();
    //            throw exception1;
    //            Surface surface = new Surface(image, image1, -1, c.getAnchor(), uisettings.ANIMATION_SPEED * 2);
    //            g.add(surface, JLayeredPane.PALETTE_LAYER);
    //            surface.setBounds(rectangle);
    //            g.validate();
    //            g.repaint();
    //            surface.runMovement();
    //            g.remove(surface);
    //            break MISSING_BLOCK_LABEL_265;
    //            g.remove(b);
    //            if(!d)
    //            {
    //                g.validate();
    //                g.repaint();
    //            }
    //            finish();
    //            break MISSING_BLOCK_LABEL_308;
    //            Exception exception2;
    //            exception2;
    //            finish();
    //            throw exception2;
    //        }
    //
    //        private final Component b;
    //        private final WindowInfo c;
    //        private final boolean d;
    //
    //        public RemoveSlidingComponentCmd(Component component, WindowInfo windowinfo, boolean flag, Runnable runnable)
    //        {
    //            super(runnable);
    //            b = component;
    //            c = windowinfo;
    //            d = flag;
    //        }
    //    }
    //
    //    private final class RemoveDockedComponentCmd extends FinalizableCommand
    //    {
    //
    //        public final void run()
    //        {
    //            a(null, b.getAnchor(), 0.0F);
    //            if(!c)
    //            {
    //                g.validate();
    //                g.repaint();
    //            }
    //            finish();
    //            break MISSING_BLOCK_LABEL_57;
    //            Exception exception;
    //            exception;
    //            finish();
    //            throw exception;
    //        }
    //
    //        private final WindowInfo b;
    //        private final boolean c;
    //
    //        public RemoveDockedComponentCmd(WindowInfo windowinfo, boolean flag, Runnable runnable)
    //        {
    //            super(runnable);
    //            b = windowinfo;
    //            c = flag;
    //        }
    //    }
    //
    //    private final class RemoveToolStripeButtonCmd extends FinalizableCommand
    //    {
    //
    //        public final void run()
    //        {
    //            ToolWindowAnchor toolwindowanchor = c.getAnchor();
    //            if(ToolWindowAnchor.TOP == toolwindowanchor)
    //                northStrip.removeButton(b);
    //            else
    //            if(ToolWindowAnchor.LEFT == toolwindowanchor)
    //                westStripe.removeButton(b);
    //            else
    //            if(ToolWindowAnchor.BOTTOM == toolwindowanchor)
    //                southStripe.removeButton(b);
    //            else
    //            if(ToolWindowAnchor.RIGHT == toolwindowanchor)
    //                eastStripe.removeButton(b);
    //            else
    //                ToolWindowsPane.a.error("unknown anchor: " + toolwindowanchor);
    //            validate();
    //            repaint();
    //            finish();
    //            break MISSING_BLOCK_LABEL_157;
    //            Exception exception;
    //            exception;
    //            finish();
    //            throw exception;
    //        }
    //
    //        private final StripeButton b;
    //        private final WindowInfo c;
    //
    //        public RemoveToolStripeButtonCmd(StripeButton stripebutton, WindowInfo windowinfo, Runnable runnable)
    //        {
    //            super(runnable);
    //            b = stripebutton;
    //            c = windowinfo;
    //        }
    //    }
    //    private final class AddToolStripeButtonCmd extends FinalizableCommand
    //    {
    //
    //        public final void run()
    //        {
    //            ToolWindowAnchor toolwindowanchor = c.getAnchor();
    //            if(ToolWindowAnchor.TOP == toolwindowanchor)
    //                northStrip.addButton(b, d);
    //            else
    //            if(ToolWindowAnchor.LEFT == toolwindowanchor)
    //                westStripe.addButton(b, d);
    //            else
    //            if(ToolWindowAnchor.BOTTOM == toolwindowanchor)
    //                southStripe.addButton(b, d);
    //            else
    //            if(ToolWindowAnchor.RIGHT == toolwindowanchor)
    //                eastStripe.addButton(b, d);
    //            else
    //                ToolWindowsPane.a.error("unknown anchor: " + toolwindowanchor);
    //            validate();
    //            repaint();
    //            finish();
    //            break MISSING_BLOCK_LABEL_173;
    //            Exception exception;
    //            exception;
    //            finish();
    //            throw exception;
    //        }
    //
    //        private final StripeButton b;
    //        private final WindowInfo c;
    //        private final Comparator d;
    //
    //        public AddToolStripeButtonCmd(StripeButton stripebutton, WindowInfo windowinfo, Comparator comparator, Runnable runnable)
    //        {
    //            super(runnable);
    //            b = stripebutton;
    //            c = windowinfo;
    //            d = comparator;
    //        }
    //    }
    //    private final class AddSlidingComponentCmd extends FinalizableCommand
    //    {
    //
    //        public final void run()
    //        {
    //            UISettings uisettings;
    //            Image image;
    //            Graphics g1;
    //            uisettings = UISettings.getInstance();
    //            if(d || !uisettings.ANIMATE_WINDOWS)
    //                break MISSING_BLOCK_LABEL_327;
    //            image = g.getTopImage();
    //            g1 = image.getGraphics();
    //            Rectangle rectangle;
    //            g.add(b, JLayeredPane.PALETTE_LAYER);
    //            g.moveToFront(b);
    //            g.setBoundsInPaletteLayer(b, c.getAnchor(), c.getWeight());
    //            rectangle = b.getBounds();
    //            b.paint(g1);
    //            g.remove(b);
    //            g1.dispose();
    //            break MISSING_BLOCK_LABEL_140;
    //            Exception exception;
    //            exception;
    //            g1.dispose();
    //            throw exception;
    //            Image image1;
    //            Graphics g2;
    //            image1 = g.getBottomImage();
    //            g2 = image1.getGraphics();
    //            g2.setClip(0, 0, rectangle.width, rectangle.height);
    //            g2.translate(-rectangle.x, -rectangle.y);
    //            g.paint(g2);
    //            g2.dispose();
    //            break MISSING_BLOCK_LABEL_223;
    //            Exception exception1;
    //            exception1;
    //            g2.dispose();
    //            throw exception1;
    //            Surface surface = new Surface(image, image1, 1, c.getAnchor(), uisettings.ANIMATION_SPEED);
    //            g.add(surface, JLayeredPane.PALETTE_LAYER);
    //            surface.setBounds(rectangle);
    //            g.validate();
    //            g.repaint();
    //            surface.runMovement();
    //            g.remove(surface);
    //            g.add(b, JLayeredPane.PALETTE_LAYER);
    //            break MISSING_BLOCK_LABEL_372;
    //            g.add(b, JLayeredPane.PALETTE_LAYER);
    //            g.setBoundsInPaletteLayer(b, c.getAnchor(), c.getWeight());
    //            if(!d)
    //            {
    //                g.validate();
    //                g.repaint();
    //            }
    //            finish();
    //            break MISSING_BLOCK_LABEL_415;
    //            Exception exception2;
    //            exception2;
    //            finish();
    //            throw exception2;
    //        }
    //
    //        private final Component b;
    //        private final WindowInfo c;
    //        private final boolean d;
    //
    //        public AddSlidingComponentCmd(Component component, WindowInfo windowinfo, boolean flag, Runnable runnable)
    //        {
    //            super(runnable);
    //            b = component;
    //            c = windowinfo;
    //            d = flag;
    //        }
    //    }
    //
    //    private final class AddDockedComponentCmd extends FinalizableCommand
    //    {
    //
    //        public final void run()
    //        {
    //            float f1 = c.getWeight() > 0.0F ? c.getWeight() : 0.33F;
    //            float f2 = f1;
    //            if(f2 >= 1.0F)
    //                f2 = 0.67F;
    //            ToolWindowAnchor toolwindowanchor = c.getAnchor();
    //            a(b, toolwindowanchor, f2);
    //            if(!d)
    //            {
    //                g.validate();
    //                g.repaint();
    //            }
    //            finish();
    //            break MISSING_BLOCK_LABEL_100;
    //            Exception exception;
    //            exception;
    //            finish();
    //            throw exception;
    //        }
    //
    //        private final JComponent b;
    //        private final WindowInfo c;
    //        private final boolean d;
    //
    //        public AddDockedComponentCmd(JComponent jcomponent, WindowInfo windowinfo, boolean flag, Runnable runnable)
    //        {
    //            super(runnable);
    //            b = jcomponent;
    //            c = windowinfo;
    //            d = flag;
    //        }
    //    }
    //    public final void addNotify() {
    //        super.addNotify();
    //        UISettings.getInstance().addUISettingsListener(n);
    //    }
    //    public final void removeNotify() {
    //        UISettings.getInstance().removeUISettingsListener(n);
    //        super.removeNotify();
    //    }
    //    final FinalizableCommand createAddButtonCmd(StripeButton stripebutton, WindowInfo windowinfo, Comparator comparator, Runnable runnable)
    //    {
    //        WindowInfo windowinfo1 = windowinfo.copy();
    //        c.put(windowinfo1.getId(), stripebutton);
    //        e.put(stripebutton, windowinfo1);
    //        return new AddToolStripeButtonCmd(stripebutton, windowinfo1, comparator, runnable);
    //    }
    //    final FinalizableCommand createAddDecoratorCmd(InternalDecorator internaldecorator, WindowInfo windowinfo, boolean flag, Runnable runnable)
    //    {
    //        WindowInfo windowinfo1 = windowinfo.copy();
    //        String s = windowinfo1.getId();
    //        f.put(internaldecorator, windowinfo1);
    //        d.put(s, internaldecorator);
    //        if(windowinfo.isDocked())
    //            return new AddDockedComponentCmd(internaldecorator, windowinfo, flag, runnable);
    //        if(windowinfo.isSliding())
    //            return new AddSlidingComponentCmd(internaldecorator, windowinfo, flag, runnable);
    //        else
    //            throw new IllegalArgumentException("Unknown window type: " + windowinfo.getType());
    //    }
    //    final FinalizableCommand createRemoveButtonCmd(String s, Runnable runnable)
    //    {
    //        StripeButton stripebutton = a(s);
    //        WindowInfo windowinfo = c(s);
    //        e.remove(stripebutton);
    //        c.remove(s);
    //        return new RemoveToolStripeButtonCmd(stripebutton, windowinfo, runnable);
    //    }
    //
    //    final FinalizableCommand createRemoveDecoratorCmd(String s, boolean flag, Runnable runnable)
    //    {
    //        Component component = b(s);
    //        WindowInfo windowinfo = d(s);
    //        f.remove(component);
    //        d.remove(s);
    //        if(windowinfo.isDocked())
    //            return new RemoveDockedComponentCmd(windowinfo, flag, runnable);
    //        if(windowinfo.isSliding())
    //            return new RemoveSlidingComponentCmd(component, windowinfo, flag, runnable);
    //        else
    //            throw new IllegalArgumentException("Unknown window type");
    //    }
    //
    //    final FinalizableCommand createSetEditorComponentCmd(JComponent jcomponent, Runnable runnable)
    //    {
    //        return new SetEditorComponentCmd(jcomponent, runnable);
    //    }
    val myLayeredPane: JComponent?
        get() = g

    //    private DockingButton a(String s) {
    //        return (DockingButton) c.get(s);
    //    }
    //
    //    private Component b(String s) {
    //        return (Component) d.get(s);
    //    }
    //
    //    private WindowInfo c(String s)
    //    {
    //        return (WindowInfo)e.get(c.get(s));
    //    }
    //
    //    private WindowInfo d(String s)
    //    {
    //        return (WindowInfo)f.get(d.get(s));
    //    }
    //    private void a(JComponent jcomponent, ToolWindowAnchor toolwindowanchor, float f1)
    //    {
    //        if(ToolWindowAnchor.TOP == toolwindowanchor)
    //        {
    //            verticalSplitter.setFirstComponent(jcomponent);
    //            verticalSplitter.setFirstSize((int)((float)g.getHeight() * f1));
    //        } else
    //        if(ToolWindowAnchor.LEFT == toolwindowanchor)
    //        {
    //            horizontalSplitter.setFirstComponent(jcomponent);
    //            horizontalSplitter.setFirstSize((int)((float)g.getWidth() * f1));
    //        } else
    //        if(ToolWindowAnchor.BOTTOM == toolwindowanchor)
    //        {
    //            verticalSplitter.setLastComponent(jcomponent);
    //            verticalSplitter.setLastSize((int)((float)g.getHeight() * f1));
    //        } else
    //        if(ToolWindowAnchor.RIGHT == toolwindowanchor)
    //        {
    //            horizontalSplitter.setLastComponent(jcomponent);
    //            horizontalSplitter.setLastSize((int)((float)g.getWidth() * f1));
    //        } else
    //        {
    //            a.error("unknown anchor: " + toolwindowanchor);
    //        }
    //    }
    //    private void a(JComponent jcomponent) {
    //        horizontalSplitter.setInnerComponent(jcomponent);
    //    }
    //    private void a()
    //    {
    //        boolean flag = !UISettings.getInstance().HIDE_TOOL_STRIPES;
    //        westStripe.setVisible(flag);
    //        eastStripe.setVisible(flag);
    //        northStrip.setVisible(flag);
    //        southStripe.setVisible(flag);
    //    }
    override fun dispose() {
        if (westDockingBar != null) {
            for (dockable in westDockingBar!!.dockables!!) {
//                ComponentCleaner.cleanComponent(dockable.component)
                dockable!!.dispose()
            }
            westDockingBar!!.dispose()
            westDockingBar = null
        }
        if (eastDockingBar != null) {
            for (dockable in eastDockingBar!!.dockables!!) {
//                ComponentCleaner.cleanComponent(dockable.component)
                dockable!!.dispose()
            }
            eastDockingBar!!.dispose()
            eastDockingBar = null
        }
        if (southDockingBar != null) {
            for (dockable in southDockingBar!!.dockables!!) {
//                ComponentCleaner.cleanComponent(dockable.component)
                dockable!!.dispose()
            }
            southDockingBar!!.dispose()
            southDockingBar = null
        }
        if (northDockingBar != null) {
            for (dockable in northDockingBar!!.dockables!!) {
//                ComponentCleaner.cleanComponent(dockable.component)
                dockable!!.dispose()
            }
            northDockingBar!!.dispose()
            northDockingBar = null
        }
        g = null
        primarySplitter = null
        secondarySplitter = null
        mainPanel = null
    }

    override fun createNakedDockable(component: JComponent, title: String?): Dockable<JComponent> {
        return createNakedDockable(component, title, null as ImageIcon?)
    }

    override fun createNakedDockable(component: JComponent, title: String?, iconUrl: String?): Dockable<JComponent> {
        return SwingNakedDockable(component, title, iconUrl)
    }

    override fun createDecoratedDockable(component: JComponent, title: String?): Dockable<JComponent> {
        return createDecoratedDockable(component, title, null)
    }

    override fun createDecoratedDockable(
        component: JComponent,
        shortTitle: String?,
        title: String?,
        description: String?
    ): Dockable<JComponent> {
        return createDecoratedDockable(component, shortTitle, title, description, null)
    }

    fun createNakedDockable(component: JComponent, title: String?, icon: ImageIcon?): Dockable<JComponent> {
        return SwingNakedDockable(component, title, icon)
    }

    fun createDecoratedDockable(component: JComponent?, title: String?, icon: ImageIcon?): Dockable<JComponent> {
        return SwingDockable(component, title, icon)
    }

    fun createDecoratedDockable(
        component: JComponent?,
        shortTitle: String?,
        title: String?,
        description: String?,
        icon: ImageIcon?
    ): Dockable<JComponent> {
        return SwingDockable(component, shortTitle, title, description, icon)
    }

    override fun attach(dockable: Dockable<JComponent>?, anchor: AttachAnchor?) {
        when (anchor!!) {
            AttachAnchor.TOP -> northDockingBar!!.attach(dockable!!)
            AttachAnchor.BOTTOM -> southDockingBar!!.attach(dockable!!)
            AttachAnchor.LEFT -> westDockingBar!!.attach(dockable!!)
            AttachAnchor.RIGHT -> eastDockingBar!!.attach(dockable!!)
            AttachAnchor.CENTER -> innerComponent = dockable!!.component
        }
    }

    //    private final MyUISettingsListenerImpl n = new MyUISettingsListenerImpl();
    init {
        `$$$setupUI$$$`()
        updateLayout()
    }
}