/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing.plaf.basic

import com.macrofocus.docking.swing.DockingViewTitleBar
import com.macrofocus.docking.swing.plaf.DockingViewTitleBarUI
import de.javasoft.docking.ui.BasicDockingPainter
import de.javasoft.docking.ui.controls.DockingButtonFactory
import de.javasoft.docking.ui.controls.IDockingButtonFactory
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel
import de.javasoft.plaf.synthetica.SyntheticaState
import java.awt.Color
import java.awt.Font
import java.awt.Graphics
import java.awt.Insets
import javax.swing.BoxLayout
import javax.swing.JComponent
import javax.swing.UIManager
import javax.swing.border.EmptyBorder
import javax.swing.plaf.ComponentUI
import javax.swing.plaf.FontUIResource
import javax.swing.plaf.UIResource

@Suppress("ACCIDENTAL_OVERRIDE")
open class BasicDockingViewTitleBarUI : DockingViewTitleBarUI() {
    private var dockingButtonFactory: IDockingButtonFactory? = null
    override fun installUI(paramJComponent: JComponent) {
        super.installUI(paramJComponent)
        val localDockingViewTitlebar: DockingViewTitleBar = paramJComponent as DockingViewTitleBar
        val localFont: Font? = paramJComponent.getFont()
        if (localFont == null || localFont is UIResource) {
            val localObject: Font = UIManager.getFont("Panel.font")
            var i = 0
            val str1: String? = SyntheticaLookAndFeel.getString("JYDocking.titlebar.font.style", paramJComponent)
            if (str1 != null) {
                if (str1.contains("BOLD")) i = i or 1
                if (str1.contains("ITALIC")) i = i or 2
            }
            var f = 0f
            try {
                f = SyntheticaLookAndFeel.getInstance()
                    .scaleFontSize(SyntheticaLookAndFeel.getInt("JYDocking.titlebar.font.size", paramJComponent, 0).toFloat())
            } catch (e: NullPointerException) {
                e.printStackTrace()
            }
            if (f == 0.0f) f = localObject.size.toFloat()
            var str2: String? = SyntheticaLookAndFeel.getString("JYDocking.titlebar.font.name", paramJComponent)
            if (str2 == null) str2 = localObject.family
            paramJComponent.setFont(FontUIResource(str2, i, f.toInt()))
        }
        var localObject: Color? = localDockingViewTitlebar.getTitleForeground()
        if (localObject == null || localObject is UIResource) {
            localDockingViewTitlebar.setTitleForeground(
                SyntheticaLookAndFeel.getColor(
                    "JYDocking.titlebar.foreground",
                    paramJComponent,
                    Color.BLACK
                )
            )
        }
        localObject = localDockingViewTitlebar.getActiveTitleForeground()
        if (localObject == null || localObject is UIResource) {
            localDockingViewTitlebar.setActiveTitleForeground(
                SyntheticaLookAndFeel.getColor(
                    "JYDocking.titlebar.active.foreground",
                    paramJComponent,
                    Color.BLACK
                )
            )
        }
        paramJComponent.setLayout(BoxLayout(paramJComponent, 2))
        var localInsets: Insets? = SyntheticaLookAndFeel.getInsets("JYDocking.titlebar.insets", paramJComponent)
        if (localInsets == null) localInsets = Insets(3, 4, 1, 4)
        paramJComponent.setBorder(EmptyBorder(localInsets))
        installDockingButtonFactory(localDockingViewTitlebar)
    }

    override fun uninstallUI(paramJComponent: JComponent) {
        super.uninstallUI(paramJComponent)
    }

    override fun paint(paramGraphics: Graphics, paramJComponent: JComponent) {
        val i = 0
        val j = 0
        val k: Int = paramJComponent.getWidth()
        val m: Int = paramJComponent.getHeight()
        paintBackground(paramJComponent, paramGraphics, i, j, k, m)
        paintBorder(paramJComponent, paramGraphics, i, j, k, m)
    }

    protected open fun paintBackground(
        paramJComponent: JComponent,
        paramGraphics: Graphics?,
        paramInt1: Int,
        paramInt2: Int,
        paramInt3: Int,
        paramInt4: Int
    ) {
        BasicDockingPainter.getInstance().paintDockingTitleBarBackground(
            paramJComponent,
            SyntheticaState(if ((paramJComponent as DockingViewTitleBar).isActive()) SyntheticaState.State.SELECTED.toInt() else 0),
            paramGraphics,
            paramInt1,
            paramInt2,
            paramInt3,
            paramInt4
        )
    }

    protected fun paintBorder(
        paramJComponent: JComponent?,
        paramGraphics: Graphics?,
        paramInt1: Int,
        paramInt2: Int,
        paramInt3: Int,
        paramInt4: Int
    ) {
    }

    private fun installDockingButtonFactory(paramDockingViewTitlebar: DockingViewTitleBar) {
        val str: String? =
            SyntheticaLookAndFeel.getString("JYDocking.dockingButtonFactory.className", paramDockingViewTitlebar)
        if (str == null) {
            dockingButtonFactory = DockingButtonFactory()
        } else try {
            dockingButtonFactory = Class.forName(str).newInstance() as IDockingButtonFactory
        } catch (localException: Exception) {
            throw RuntimeException(localException)
        }
    }

    fun getDockingButtonFactory(): IDockingButtonFactory? {
        return dockingButtonFactory
    }

    companion object {
        @JvmStatic fun createUI(p0: JComponent?): ComponentUI? {
            return BasicDockingViewTitleBarUI()
        }
    }
}