/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing;

import com.macrofocus.common.helper.WeakActionListeners;
import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingAnchor;
import com.macrofocus.docking.DockingBar;
import com.macrofocus.docking.DockingState;
import com.macrofocus.docking.DockingType;
import com.macrofocus.docking.swing.DockingButton;
import com.macrofocus.docking.swing.DockingContainer;
import com.macrofocus.docking.swing.IconDockable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001+B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\u0016\u0010\u001f\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\u0016\u0010!\u001a\u00020\"2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J\b\u0010#\u001a\u00020\u001dH\u0016J\u001e\u0010$\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010%\u001a\u00020\"H\u0016J\u001e\u0010&\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010'\u001a\u00020\"H\u0016J\u001e\u0010(\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010)\u001a\u00020\"H\u0016J\b\u0010*\u001a\u00020\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/macrofocus/docking/swing/SwingDockingBar;", "Ljavax/swing/JPanel;", "Lcom/macrofocus/docking/DockingBar;", "Ljavax/swing/JComponent;", "container", "Lcom/macrofocus/docking/swing/DockingContainer;", "orientation", "Lcom/macrofocus/docking/DockingAnchor;", "(Lcom/macrofocus/docking/swing/DockingContainer;Lcom/macrofocus/docking/DockingAnchor;)V", "actionListeners", "Lcom/macrofocus/common/helper/WeakActionListeners;", "dockables", "", "Lcom/macrofocus/docking/Dockable;", "getDockables", "()Ljava/util/List;", "dockingButtons", "", "Lcom/macrofocus/docking/swing/DockingButton;", "dockingStates", "Lcom/macrofocus/docking/DockingState;", "enterTimer", "Ljavax/swing/Timer;", "insideTimerAction", "Lcom/macrofocus/docking/swing/SwingDockingBar$InsideTimerAction;", "nativeComponent", "getNativeComponent", "()Ljavax/swing/JComponent;", "attach", "", "dockable", "detach", "dispose", "isActive", "", "removeAll", "setActive", "active", "setFloating", "floating", "setSliding", "sliding", "update", "InsideTimerAction", "macrofocus-docking"})
public final class SwingDockingBar
extends JPanel
implements DockingBar<JComponent> {
    @NotNull
    private final DockingContainer container;
    @NotNull
    private final List<Dockable<JComponent>> dockables;
    @NotNull
    private final Map<Dockable<?>, DockingButton> dockingButtons;
    @NotNull
    private final Map<Dockable<?>, DockingState> dockingStates;
    @NotNull
    private final DockingAnchor orientation;
    @Nullable
    private Timer enterTimer;
    @Nullable
    private InsideTimerAction insideTimerAction;
    @NotNull
    private final WeakActionListeners actionListeners;

    public SwingDockingBar(@NotNull DockingContainer container, @NotNull DockingAnchor orientation) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        this.container = container;
        this.actionListeners = new WeakActionListeners();
        this.orientation = orientation;
        this.dockables = new ArrayList();
        this.dockingButtons = new HashMap();
        this.dockingStates = new HashMap();
        this.insideTimerAction = new InsideTimerAction();
        Timer timer = this.enterTimer = new Timer(750, this.insideTimerAction);
        Intrinsics.checkNotNull((Object)timer);
        timer.setRepeats(false);
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
    }

    @Override
    @NotNull
    public List<Dockable<JComponent>> getDockables() {
        return this.dockables;
    }

    @Override
    public void attach(@NotNull Dockable<JComponent> dockable) {
        Intrinsics.checkNotNullParameter(dockable, (String)"dockable");
        dockable.setDockingBar(this);
        boolean first = this.getDockables().isEmpty();
        this.getDockables().add(dockable);
        DockingButton button = new DockingButton(this.orientation);
        button.setText(dockable.getShortTitle());
        if (dockable instanceof IconDockable) {
            button.setIcon(((IconDockable)dockable).getIcon());
        }
        button.setToolTipText(dockable.getDescription());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new AbstractAction(this, dockable){
            final /* synthetic */ SwingDockingBar this$0;
            final /* synthetic */ Dockable<JComponent> $dockable;
            {
                this.this$0 = $receiver;
                this.$dockable = $dockable;
                super("Float");
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setFloating(this.$dockable, true);
            }
        }));
        button.setComponentPopupMenu(popupMenu);
        this.dockingButtons.put(dockable, button);
        DockingState state = new DockingState();
        this.dockingStates.put(dockable, state);
        button.addActionListener(this.actionListeners.create(new ActionListener(this, dockable, button){
            final /* synthetic */ SwingDockingBar this$0;
            final /* synthetic */ Dockable<JComponent> $dockable;
            final /* synthetic */ DockingButton $button;
            {
                this.this$0 = $receiver;
                this.$dockable = $dockable;
                this.$button = $button;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setActive(this.$dockable, this.$button.isSelected());
            }
        }, (Object)button));
        button.addMouseListener(new MouseAdapter(this, dockable){
            final /* synthetic */ SwingDockingBar this$0;
            final /* synthetic */ Dockable<JComponent> $dockable;
            {
                this.this$0 = $receiver;
                this.$dockable = $dockable;
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                InsideTimerAction insideTimerAction = SwingDockingBar.access$getInsideTimerAction$p(this.this$0);
                Intrinsics.checkNotNull((Object)insideTimerAction);
                insideTimerAction.setDockable(this.$dockable);
                Timer timer = SwingDockingBar.access$getEnterTimer$p(this.this$0);
                Intrinsics.checkNotNull((Object)timer);
                timer.start();
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Timer timer = SwingDockingBar.access$getEnterTimer$p(this.this$0);
                Intrinsics.checkNotNull((Object)timer);
                timer.stop();
            }
        });
        this.container.setLayout(new OverlayLayout(this.container));
        if (first) {
            this.setActive(dockable, true);
        }
        this.update();
    }

    @Override
    public void detach(@NotNull Dockable<JComponent> dockable) {
        Intrinsics.checkNotNullParameter(dockable, (String)"dockable");
        this.setActive(dockable, false);
        this.getDockables().remove(dockable);
        this.dockingButtons.remove(dockable);
        this.dockingStates.remove(dockable);
        this.update();
    }

    @Override
    public void removeAll() {
        for (Dockable<JComponent> dockable : this.getDockables()) {
            this.setActive(dockable, false);
            this.dockingButtons.remove(dockable);
            this.dockingStates.remove(dockable);
        }
        this.getDockables().clear();
        this.update();
    }

    @Override
    public boolean isActive(@NotNull Dockable<JComponent> dockable) {
        Intrinsics.checkNotNullParameter(dockable, (String)"dockable");
        DockingState dockingState = this.dockingStates.get(dockable);
        Intrinsics.checkNotNull((Object)dockingState);
        DockingState state = dockingState;
        return state.isActive();
    }

    @Override
    public void setActive(@NotNull Dockable<JComponent> dockable, boolean active) {
        Intrinsics.checkNotNullParameter(dockable, (String)"dockable");
        DockingState dockingState = this.dockingStates.get(dockable);
        Intrinsics.checkNotNull((Object)dockingState);
        DockingState state = dockingState;
        if (!state.isFloating()) {
            for (Dockable<JComponent> d : this.getDockables()) {
                DockingButton button;
                DockingState s;
                Intrinsics.checkNotNull((Object)this.dockingStates.get(d));
                if (!s.isActive()) continue;
                s.setActive(d == dockable && active);
                Intrinsics.checkNotNull((Object)this.dockingButtons.get(d));
                button.setSelected(d == dockable && active);
                this.container.remove(d.getComponent());
            }
            if (active) {
                state.setActive(true);
                this.container.add(dockable.getComponent());
                this.container.validate();
                this.container.setVisible(true);
                DockingButton dockingButton = this.dockingButtons.get(dockable);
                Intrinsics.checkNotNull((Object)dockingButton);
                DockingButton button = dockingButton;
                button.setSelected(true);
                this.container.repaint();
            } else {
                this.container.setVisible(false);
                this.container.revalidate();
                this.container.repaint();
            }
        } else {
            SwingUtilities.windowForComponent(dockable.getContainer()).toFront();
            DockingButton dockingButton = this.dockingButtons.get(dockable);
            Intrinsics.checkNotNull((Object)dockingButton);
            DockingButton button = dockingButton;
            button.setSelected(false);
        }
    }

    @Override
    public void setFloating(@NotNull Dockable<JComponent> dockable, boolean floating) {
        Intrinsics.checkNotNullParameter(dockable, (String)"dockable");
        DockingState dockingState = this.dockingStates.get(dockable);
        Intrinsics.checkNotNull((Object)dockingState);
        DockingState state = dockingState;
        if (floating) {
            if (!state.isFloating()) {
                JComponent jComponent = dockable.getComponent();
                Intrinsics.checkNotNull((Object)jComponent);
                JComponent component = jComponent;
                Point p = null;
                p = component.isShowing() ? component.getLocationOnScreen() : null;
                Dimension size = component.getSize();
                this.setActive(dockable, false);
                JFrame frame = new JFrame();
                frame.setAlwaysOnTop(true);
                if (p != null) {
                    frame.setLocation(p);
                } else {
                    frame.setLocationRelativeTo(this);
                }
                frame.setSize(size);
                String title = dockable.getTitle();
                frame.setTitle(title);
                JComponent jComponent2 = dockable.detachContainer();
                Intrinsics.checkNotNull((Object)jComponent2);
                JComponent container = jComponent2;
                frame.getContentPane().add(container);
                frame.validate();
                frame.setVisible(true);
                frame.addWindowListener(new WindowAdapter(this, dockable){
                    final /* synthetic */ SwingDockingBar this$0;
                    final /* synthetic */ Dockable<JComponent> $dockable;
                    {
                        this.this$0 = $receiver;
                        this.$dockable = $dockable;
                    }

                    public void windowClosing(@NotNull WindowEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.this$0.setFloating(this.$dockable, false);
                    }
                });
                state.setType(DockingType.Companion.getFLOATING());
            }
        } else if (state.isFloating()) {
            JComponent jComponent = dockable.getContainer();
            Intrinsics.checkNotNull((Object)jComponent);
            JComponent component = jComponent;
            component.getParent().remove(component);
            dockable.attachContainer();
            state.setType(DockingType.Companion.getDOCKED());
            this.setActive(dockable, true);
        }
    }

    @Override
    public void setSliding(@NotNull Dockable<JComponent> dockable, boolean sliding) {
        Intrinsics.checkNotNullParameter(dockable, (String)"dockable");
        DockingState dockingState = this.dockingStates.get(dockable);
        Intrinsics.checkNotNull((Object)dockingState);
        DockingState state = dockingState;
        if (sliding) {
            if (!state.isSliding()) {
                JComponent jComponent = dockable.getComponent();
                Intrinsics.checkNotNull((Object)jComponent);
                JComponent component = jComponent;
                JFrame frame = new JFrame();
                frame.setSize(50, 50);
                frame.setUndecorated(true);
                String title = dockable.getTitle();
                frame.setTitle(title);
                JComponent jComponent2 = dockable.detachContainer();
                Intrinsics.checkNotNull((Object)jComponent2);
                JComponent container = jComponent2;
                frame.getContentPane().add(container);
                frame.validate();
                frame.setVisible(true);
                state.setType(DockingType.Companion.getSLIDING());
            }
        } else if (state.isSliding()) {
            JComponent jComponent = dockable.getContainer();
            Intrinsics.checkNotNull((Object)jComponent);
            JComponent component = jComponent;
            component.getParent().remove(component);
            dockable.attachContainer();
            state.setType(DockingType.Companion.getDOCKED());
        }
    }

    private final void update() {
        super.removeAll();
        if (Intrinsics.areEqual((Object)this.orientation, (Object)DockingAnchor.TOP) || Intrinsics.areEqual((Object)this.orientation, (Object)DockingAnchor.BOTTOM)) {
            int i = 1;
            for (Dockable<JComponent> dockable : this.getDockables()) {
                DockingButton dockingButton = this.dockingButtons.get(dockable);
                this.add((Component)dockingButton, new GridBagConstraints(i, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
                ++i;
            }
            this.add(Box.createGlue(), new GridBagConstraints(i, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else if (Intrinsics.areEqual((Object)this.orientation, (Object)DockingAnchor.LEFT) || Intrinsics.areEqual((Object)this.orientation, (Object)DockingAnchor.RIGHT)) {
            int i = 0;
            for (Dockable<JComponent> dockable : this.getDockables()) {
                DockingButton dockingButton = this.dockingButtons.get(dockable);
                this.add((Component)dockingButton, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                ++i;
            }
            GridBagConstraints gridbagconstraints = new GridBagConstraints();
            gridbagconstraints.gridy = this.getDockables().size();
            gridbagconstraints.weighty = 1.0;
            gridbagconstraints.anchor = 11;
            this.add(Box.createGlue(), gridbagconstraints);
        } else {
            throw new UnknownError();
        }
    }

    @Override
    public void dispose() {
        if (this.enterTimer != null) {
            Timer timer = this.enterTimer;
            Intrinsics.checkNotNull((Object)timer);
            timer.stop();
            this.enterTimer = null;
        }
        this.insideTimerAction = null;
        this.getDockables().clear();
        for (DockingButton dockingButton : this.dockingButtons.values()) {
        }
        this.dockingButtons.clear();
        this.dockingStates.clear();
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        return this;
    }

    public static final /* synthetic */ InsideTimerAction access$getInsideTimerAction$p(SwingDockingBar $this) {
        return $this.insideTimerAction;
    }

    public static final /* synthetic */ Timer access$getEnterTimer$p(SwingDockingBar $this) {
        return $this.enterTimer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/macrofocus/docking/swing/SwingDockingBar$InsideTimerAction;", "Ljava/awt/event/ActionListener;", "()V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "setDockable", "dockable", "Lcom/macrofocus/docking/Dockable;", "macrofocus-docking"})
    private static final class InsideTimerAction
    implements ActionListener {
        public final void setDockable(@Nullable Dockable<?> dockable) {
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    }
}

