/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing.plaf.basic;

import com.macrofocus.docking.swing.plaf.DockingButtonUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0004J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0004J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010#\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010'\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010-\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0004J:\u0010.\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001002\b\u00102\u001a\u0004\u0018\u000100H\u0004J\"\u00103\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00102\u001a\u000200H\u0004J*\u00104\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00101\u001a\u0002002\b\u00105\u001a\u0004\u0018\u00010\rH\u0004J*\u00104\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00101\u001a\u0002002\b\u00105\u001a\u0004\u0018\u00010\rH\u0004J\b\u00106\u001a\u00020\u0014H\u0004J\u0012\u00107\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\u0010\u00108\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u00109\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0010\u0010:\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006<"}, d2={"Lcom/macrofocus/docking/swing/plaf/basic/BasicDockingButtonUI;", "Lcom/macrofocus/docking/swing/plaf/DockingButtonUI;", "()V", "defaultTextIconGap", "", "getDefaultTextIconGap", "()I", "setDefaultTextIconGap", "(I)V", "defaultTextShiftOffset", "getDefaultTextShiftOffset", "setDefaultTextShiftOffset", "propertyPrefix", "", "getPropertyPrefix", "()Ljava/lang/String;", "<set-?>", "textShiftOffset", "getTextShiftOffset", "clearTextShiftOffset", "", "createButtonListener", "Ljavax/swing/plaf/basic/BasicButtonListener;", "b", "Ljavax/swing/AbstractButton;", "getBaseline", "c", "Ljavax/swing/JComponent;", "width", "height", "getButtonListener", "getMaximumSize", "Ljava/awt/Dimension;", "getMinimumSize", "getPreferredSize", "installDefaults", "installKeyboardActions", "installListeners", "installUI", "layout", "fm", "Ljava/awt/FontMetrics;", "paint", "g", "Ljava/awt/Graphics;", "paintButtonPressed", "paintFocus", "viewRect", "Ljava/awt/Rectangle;", "textRect", "iconRect", "paintIcon", "paintText", "text", "setTextShiftOffset", "uninstallDefaults", "uninstallKeyboardActions", "uninstallListeners", "uninstallUI", "Companion", "macrofocus-docking"})
public class BasicDockingButtonUI
extends DockingButtonUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int defaultTextIconGap;
    private int textShiftOffset;
    private int defaultTextShiftOffset;
    @NotNull
    private static final DockingButtonUI buttonUI = new BasicDockingButtonUI();
    @NotNull
    private static final String propertyPrefix = "Button.";
    @NotNull
    private static final Rectangle viewRect = new Rectangle();
    @NotNull
    private static final Rectangle textRect = new Rectangle();
    @NotNull
    private static final Rectangle iconRect = new Rectangle();

    protected final int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected final void setDefaultTextIconGap(int n) {
        this.defaultTextIconGap = n;
    }

    protected final int getTextShiftOffset() {
        return this.textShiftOffset;
    }

    protected final int getDefaultTextShiftOffset() {
        return this.defaultTextShiftOffset;
    }

    protected final void setDefaultTextShiftOffset(int n) {
        this.defaultTextShiftOffset = n;
    }

    @NotNull
    protected final String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.installDefaults((AbstractButton)c);
        this.installListeners((AbstractButton)c);
        this.installKeyboardActions((AbstractButton)c);
        BasicHTML.updateRenderer(c, ((AbstractButton)c).getText());
    }

    protected void installDefaults(@Nullable AbstractButton b) {
        String pp = this.getPropertyPrefix();
        this.defaultTextShiftOffset = UIManager.getInt(pp + "textShiftOffset");
        LookAndFeel.installColorsAndFont(b, pp + "background", pp + "foreground", pp + "font");
    }

    protected final void installListeners(@NotNull AbstractButton b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        BasicButtonListener listener = this.createButtonListener(b);
        if (listener != null) {
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
            b.addFocusListener(listener);
            b.addPropertyChangeListener(listener);
            b.addChangeListener(listener);
        }
    }

    protected final void installKeyboardActions(@NotNull AbstractButton b) {
        block0: {
            BasicButtonListener listener;
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            BasicButtonListener basicButtonListener = listener = this.getButtonListener(b);
            if (basicButtonListener == null) break block0;
            basicButtonListener.installKeyboardActions(b);
        }
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.uninstallKeyboardActions((AbstractButton)c);
        this.uninstallListeners((AbstractButton)c);
        this.uninstallDefaults((AbstractButton)c);
        BasicHTML.updateRenderer(c, "");
    }

    protected final void uninstallKeyboardActions(@NotNull AbstractButton b) {
        block0: {
            BasicButtonListener listener;
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            BasicButtonListener basicButtonListener = listener = this.getButtonListener(b);
            if (basicButtonListener == null) break block0;
            basicButtonListener.uninstallKeyboardActions(b);
        }
    }

    protected final void uninstallListeners(@NotNull AbstractButton b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        BasicButtonListener listener = this.getButtonListener(b);
        if (listener != null) {
            b.removeMouseListener(listener);
            b.removeMouseMotionListener(listener);
            b.removeFocusListener(listener);
            b.removeChangeListener(listener);
            b.removePropertyChangeListener(listener);
        }
    }

    protected void uninstallDefaults(@Nullable AbstractButton b) {
        LookAndFeel.uninstallBorder(b);
    }

    @NotNull
    protected final BasicButtonListener createButtonListener(@Nullable AbstractButton b) {
        return new BasicButtonListener(b);
    }

    public final int getDefaultTextIconGap(@Nullable AbstractButton b) {
        return this.defaultTextIconGap;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)b, g);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        String text = this.layout(b, fontMetrics, b.getWidth(), b.getHeight());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !Intrinsics.areEqual((Object)text, (Object)"")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected final void paintIcon(@Nullable Graphics g, @NotNull JComponent c, @NotNull Rectangle iconRect) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)iconRect, (String)"iconRect");
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        if (icon == null) {
            return;
        }
        Icon selectedIcon = null;
        if (model.isSelected() && (selectedIcon = b.getSelectedIcon()) != null) {
            icon = selectedIcon;
        }
        if (!model.isEnabled()) {
            if (model.isSelected() && (tmpIcon = b.getDisabledSelectedIcon()) == null) {
                tmpIcon = selectedIcon;
            }
            if (tmpIcon == null) {
                tmpIcon = b.getDisabledIcon();
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                this.clearTextShiftOffset();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            if (model.isSelected() && (tmpIcon = b.getRolloverSelectedIcon()) == null) {
                tmpIcon = selectedIcon;
            }
            if (tmpIcon == null) {
                tmpIcon = b.getRolloverIcon();
            }
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        if (model.isPressed() && model.isArmed()) {
            icon.paintIcon(c, g, iconRect.x + this.textShiftOffset, iconRect.y + this.textShiftOffset);
        } else {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    protected final void paintText(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle textRect, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)textRect, (String)"textRect");
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.textShiftOffset, textRect.y + fm.getAscent() + this.textShiftOffset);
        } else {
            g.setColor(b.getBackground().brighter());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    protected final void paintText(@NotNull Graphics g, @NotNull AbstractButton b, @NotNull Rectangle textRect, @Nullable String text) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)textRect, (String)"textRect");
        this.paintText(g, (JComponent)b, textRect, text);
    }

    protected final void paintFocus(@Nullable Graphics g, @Nullable AbstractButton b, @Nullable Rectangle viewRect, @Nullable Rectangle textRect, @Nullable Rectangle iconRect) {
    }

    protected final void paintButtonPressed(@Nullable Graphics g, @Nullable AbstractButton b) {
    }

    protected final void clearTextShiftOffset() {
        this.textShiftOffset = 0;
    }

    protected final void setTextShiftOffset() {
        this.textShiftOffset = this.defaultTextShiftOffset;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width -= (int)(v.getPreferredSpan(0) - v.getMinimumSpan(0));
        }
        return d;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        AbstractButton b = (AbstractButton)c;
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredButtonSize(...)");
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getMaximumSize(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width += (int)(v.getMaximumSpan(0) - v.getPreferredSpan(0));
        }
        return d;
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        super.getBaseline(c, width, height);
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        if (text == null || Intrinsics.areEqual((Object)"", (Object)text)) {
            return -1;
        }
        FontMetrics fm = b.getFontMetrics(b.getFont());
        Intrinsics.checkNotNull((Object)fm);
        this.layout(b, fm, width, height);
        return Companion.getBaseline(b, BasicDockingButtonUI.textRect.y, fm.getAscent(), BasicDockingButtonUI.textRect.width, BasicDockingButtonUI.textRect.height);
    }

    private final String layout(AbstractButton b, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        BasicDockingButtonUI.viewRect.x = i.left;
        BasicDockingButtonUI.viewRect.y = i.top;
        BasicDockingButtonUI.viewRect.width = width - (i.right + BasicDockingButtonUI.viewRect.x);
        BasicDockingButtonUI.viewRect.height = height - (i.bottom + BasicDockingButtonUI.viewRect.y);
        BasicDockingButtonUI.textRect.x = BasicDockingButtonUI.textRect.y = (BasicDockingButtonUI.textRect.width = (BasicDockingButtonUI.textRect.height = 0));
        BasicDockingButtonUI.iconRect.x = BasicDockingButtonUI.iconRect.y = (BasicDockingButtonUI.iconRect.width = (BasicDockingButtonUI.iconRect.height = 0));
        String string = SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layoutCompoundLabel(...)");
        return string;
    }

    private final BasicButtonListener getButtonListener(AbstractButton b) {
        MouseMotionListener[] listeners = b.getMouseMotionListeners();
        if (listeners != null) {
            int n = listeners.length;
            for (int counter = 0; counter < n; ++counter) {
                if (!(listeners[counter] instanceof BasicButtonListener)) continue;
                MouseMotionListener mouseMotionListener = listeners[counter];
                Intrinsics.checkNotNull((Object)mouseMotionListener, (String)"null cannot be cast to non-null type javax.swing.plaf.basic.BasicButtonListener");
                return (BasicButtonListener)mouseMotionListener;
            }
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final ComponentUI createUI(@Nullable JComponent c) {
        return Companion.createUI(c);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/docking/swing/plaf/basic/BasicDockingButtonUI$Companion;", "", "()V", "buttonUI", "Lcom/macrofocus/docking/swing/plaf/DockingButtonUI;", "iconRect", "Ljava/awt/Rectangle;", "propertyPrefix", "", "textRect", "viewRect", "createUI", "Ljavax/swing/plaf/ComponentUI;", "c", "Ljavax/swing/JComponent;", "getBaseline", "", "y", "ascent", "w", "h", "macrofocus-docking"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ComponentUI createUI(@Nullable JComponent c) {
            return buttonUI;
        }

        public final int getBaseline(@NotNull JComponent c, int y, int ascent, int w, int h) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                int baseline = BasicHTML.getHTMLBaseline(view, w, h);
                return baseline < 0 ? baseline : y + baseline;
            }
            return y + ascent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

