/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import javax.swing.JComponent
import com.macrofocus.docking.DockingPanel
import com.macrofocus.docking.DockingFactory

/**
 * Created by luc on 17.05.17.
 */
class SwingDockingFactory private constructor() : DockingFactory<JComponent> {
    override fun createDockingPanel(vertical: Boolean): DockingPanel<JComponent> {
        return SwingDockingPanel(vertical)
    }

    companion object {
        private val ourInstance = SwingDockingFactory()
        fun getInstance(): SwingDockingFactory {
            return ourInstance
        }
    }
}