/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import com.macrofocus.docking.NakedDockable
import javax.swing.*

/**
 * Created by luc on 05/05/16.
 */
class SwingNakedDockable : NakedDockable<JComponent>, IconDockable<JComponent> {
    override var icon: ImageIcon? = null

    constructor(component: JComponent?, title: String?, iconUrl: String?) : super(component!!, title!!, iconUrl) {
        if (iconUrl != null) {
            icon = ImageIcon(ClassLoader.getSystemResource(iconUrl))
        } else {
            icon = null
        }
    }

    constructor(component: JComponent?, title: String?, icon: ImageIcon?) : super(component!!, title!!) {
        this.icon = icon
    }
}