/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing

import java.awt.*
import javax.swing.*

/**
 * User: luc
 * Date: Jun 1, 2006
 * Time: 6:38:51 PM
 */
internal class TitlePanel : JPanel(BorderLayout()) {
    private inner class MyAnimator : Runnable {
        override fun run() {
            a()
            paintImmediately(0, 0, width, height)
            if (c <= 7) {
                c++
                alarm.restart()
            } else {
                alarm.stop()
            }
        }
    }

    fun setActive(flag: Boolean, flag1: Boolean) {
        if (flag == x) return
        x = flag
        alarm.stop()
        if (c > 0) c = 7 - c
        a(flag)
        if (flag1) {
            alarm.restart()
        } else {
            c = 7
            a()
        }
    }

    private fun a(flag: Boolean) {
        if (flag) {
            h = f.red.toFloat()
            i = f.green.toFloat()
            j = f.blue.toFloat()
            k = e!!.red.toFloat()
            l = e.green.toFloat()
            m = e.blue.toFloat()
            o = g.red.toFloat()
            p = g.green.toFloat()
            q = g.blue.toFloat()
            r = d!!.red.toFloat()
            s = d.green.toFloat()
            t = d.blue.toFloat()
        } else {
            h = e!!.red.toFloat()
            i = e.green.toFloat()
            j = e.blue.toFloat()
            k = f.red.toFloat()
            l = f.green.toFloat()
            m = f.blue.toFloat()
            o = d!!.red.toFloat()
            p = d.green.toFloat()
            q = d.blue.toFloat()
            r = g.red.toFloat()
            s = g.green.toFloat()
            t = g.blue.toFloat()
        }
    }

    private fun a() {
        val i1 = (h + c.toFloat() * (k - h) / 7f).toInt()
        val j1 = (i + c.toFloat() * (l - i) / 7f).toInt()
        val k1 = (j + c.toFloat() * (m - j) / 7f).toInt()
        n = Color(Math.max(0, Math.min(i1, 255)), Math.max(0, Math.min(j1, 255)), Math.max(0, Math.min(k1, 255)))
        val l1 = (o + c.toFloat() * (r - o) / 7f).toInt()
        val i2 = (p + c.toFloat() * (s - p) / 7f).toInt()
        val j2 = (q + c.toFloat() * (t - q) / 7f).toInt()
        u = Color(Math.max(0, Math.min(l1, 255)), Math.max(0, Math.min(i2, 255)), Math.max(0, Math.min(j2, 255)))
    }

    override fun paintComponent(g1: Graphics) {
        super.paintComponent(g1)
        val graphics2d = g1 as Graphics2D
        graphics2d.paint = GradientPaint(0.0f, 0.0f, n, 0.0f, height.toFloat(), u)
        graphics2d.fillRect(0, 0, width, height)
    }

    private var c: Int
    private var h = 0f
    private var i = 0f
    private var j = 0f
    private var k = 0f
    private var l = 0f
    private var m = 0f
    private var n: Color? = null
    private var o = 0f
    private var p = 0f
    private var q = 0f
    private var r = 0f
    private var s = 0f
    private var t = 0f
    private var u: Color? = null
    private val alarm: Timer
    private val animator = MyAnimator()
    private var x = true

    companion object {
        private const val a = 5
        private const val b = 7
        private val d: Color
        private val e: Color
        private val f = Color(184, 184, 184)
        private val g = Color(184, 184, 184)

        init {
            d = Color(105, 128, 180)
            e = d.brighter()
        }
    }

    init {
        layout = BorderLayout()
        a(false)
        c = 7
        alarm = Timer(5) { animator.run() }
        a()
    }
}