/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing.plaf

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel
import de.javasoft.widgets.util.WidgetUtils
import org.jdesktop.swingx.plaf.AbstractComponentAddon
import org.jdesktop.swingx.plaf.DefaultsList
import org.jdesktop.swingx.plaf.LookAndFeelAddons
import java.util.*
import javax.swing.UIManager

class DockingAddon : AbstractComponentAddon("Docking") {
    override fun uninitialize(paramLookAndFeelAddons: LookAndFeelAddons?) {
        super.uninitialize(paramLookAndFeelAddons)
    }

    override fun addBasicDefaults(paramLookAndFeelAddons: LookAndFeelAddons?, paramDefaultsList: DefaultsList) {
        super.addBasicDefaults(paramLookAndFeelAddons, paramDefaultsList)
        if (UIManager.getLookAndFeel() is SyntheticaLookAndFeel) {
            paramDefaultsList.add("DockingViewUI", "de.javasoft.docking.ui.SyntheticaDockingViewUI")
            paramDefaultsList.add(
                "DockingViewTitleBarUI",
                "com.macrofocus.docking.swing.plaf.synth.SyntheticaDockingViewTitleBarUI"
            )
            paramDefaultsList.add(
                "DockingViewContentPaneUI",
                "com.macrofocus.docking.swing.plaf.synth.SyntheticaDockingViewContentPaneUI"
            )
        } else {
            paramDefaultsList.add("DockingViewUI", "de.javasoft.docking.ui.BasicDockingViewUI")
            paramDefaultsList.add(
                "DockingViewTitleBarUI",
                "com.macrofocus.docking.swing.plaf.basic.BasicDockingViewTitleBarUI"
            )
            paramDefaultsList.add(
                "DockingViewContentPaneUI",
                "com.macrofocus.docking.swing.plaf.basic.BasicDockingViewContentPaneUI"
            )
        }
        try {
            WidgetUtils.addResourceBundleToDefaults("de.javasoft.swing.plaf.resources.docking", paramDefaultsList)
        } catch (e: MissingResourceException) {
            e.printStackTrace()
        }
    }
}