/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing.plaf.basic

import com.macrofocus.docking.swing.DockingView
import com.macrofocus.docking.swing.plaf.DockingViewContentPaneUI
import de.javasoft.docking.ui.BasicDockingPainter
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel
import de.javasoft.plaf.synthetica.SyntheticaState
import java.awt.Graphics
import java.awt.Insets
import javax.swing.JComponent
import javax.swing.border.Border
import javax.swing.border.EmptyBorder
import javax.swing.plaf.BorderUIResource
import javax.swing.plaf.ComponentUI
import javax.swing.plaf.UIResource

@Suppress("ACCIDENTAL_OVERRIDE")
open class BasicDockingViewContentPaneUI : DockingViewContentPaneUI() {
    override fun installUI(paramJComponent: JComponent) {
        super.installUI(paramJComponent)
        installDefaults(paramJComponent)
    }

    override fun uninstallUI(paramJComponent: JComponent) {
        super.uninstallUI(paramJComponent)
    }

    protected fun installDefaults(paramJComponent: JComponent) {
        paramJComponent.setOpaque(
            SyntheticaLookAndFeel.getBoolean(
                "JYDocking.contentPane.opaque",
                paramJComponent,
                false
            )
        )
        val localBorder: Border? = paramJComponent.getBorder()
        if (localBorder == null || localBorder is UIResource) {
            var localInsets: Insets? = SyntheticaLookAndFeel.getInsets("JYDocking.contentPane.insets", paramJComponent)
            if (localInsets == null) localInsets = Insets(1, 1, 1, 1)
            paramJComponent.setBorder(BorderUIResource(EmptyBorder(localInsets)))
        }
    }

    override fun paint(paramGraphics: Graphics, paramJComponent: JComponent) {
        super.paint(paramGraphics, paramJComponent)
        if (paramJComponent.getParent() is DockingView && (paramJComponent.getParent() as DockingView).paintContentPaneBackground) paintBackground(
            paramJComponent,
            paramGraphics,
            0,
            0,
            paramJComponent.getWidth(),
            paramJComponent.getHeight()
        )
    }

    protected open fun paintBackground(
        paramJComponent: JComponent?,
        paramGraphics: Graphics?,
        paramInt1: Int,
        paramInt2: Int,
        paramInt3: Int,
        paramInt4: Int
    ) {
        BasicDockingPainter.getInstance().paintDockingContentPaneBackground(
            paramJComponent,
            SyntheticaState(0),
            paramGraphics,
            paramInt1,
            paramInt2,
            paramInt3,
            paramInt4
        )
    }

    companion object {
        private val instance = BasicDockingViewContentPaneUI()
        @JvmStatic fun createUI(paramJComponent: JComponent?): ComponentUI {
            return instance
        }
    }
}