/*
 * Copyright (c) 2007, Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing.plaf.metal

import com.macrofocus.docking.swing.plaf.basic.BasicDockingButtonUI
import javax.swing.plaf.basic.BasicGraphicsUtils
import javax.swing.plaf.ComponentUI
import com.macrofocus.docking.swing.DockingButton
import com.macrofocus.docking.DockingAnchor
import java.lang.NoSuchMethodError
import java.awt.*
import java.awt.geom.AffineTransform
import javax.swing.*

/**
 * User: luc
 * Date: May 31, 2006
 * Time: 10:57:22 PM
 */
class MetalDockingButtonUI : BasicDockingButtonUI() {
    protected var focusColor: Color? = null
    protected var selectColor: Color? = null
    protected var disabledTextColor: Color? = null
    private var defaults_initialized = false

    // ********************************
    //        Install Defaults
    // ********************************
    public override fun installDefaults(b: AbstractButton?) {
        super.installDefaults(b)
        if (!defaults_initialized) {
            focusColor = UIManager.getColor(propertyPrefix + "focus")
            selectColor = UIManager.getColor(propertyPrefix + "select")
            disabledTextColor = UIManager.getColor(propertyPrefix + "disabledText")
            defaults_initialized = true
        }
    }

    override fun uninstallDefaults(b: AbstractButton?) {
        super.uninstallDefaults(b)
        defaults_initialized = false
    }

    override fun getPreferredSize(jcomponent: JComponent): Dimension {
        val stripebutton = jcomponent as DockingButton
        val dimension = super.getPreferredSize(stripebutton)
        dimension!!.width = (4f + dimension.width.toFloat() * 1.1f).toInt()
        dimension.height += 4
        val toolwindowanchor = stripebutton.getOrientation()
        return if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) Dimension(
            dimension.height, dimension.width
        ) else dimension
    }

    override fun paint(g: Graphics, jcomponent: JComponent) {
        val stripebutton = jcomponent as DockingButton
        val s = stripebutton.text
        val icon = if (stripebutton.isEnabled) stripebutton.icon else stripebutton.disabledIcon
        if (icon == null && s == null) return
        val fontmetrics = stripebutton.getFontMetrics(stripebutton.font)
        e = jcomponent.getInsets(e)
        d.x = e.left
        d.y = e.top
        val toolwindowanchor = stripebutton.getOrientation()
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            d.height = jcomponent.getWidth() - (e.left + e.right)
            d.width = jcomponent.getHeight() - (e.top + e.bottom)
        } else {
            d.height = jcomponent.getHeight() - (e.left + e.right)
            d.width = jcomponent.getWidth() - (e.top + e.bottom)
        }
        b.height = 0
        b.width = b.height
        b.y = b.width
        b.x = b.y
        c.height = 0
        c.width = c.height
        c.y = c.width
        c.x = c.y
        val s1 = SwingUtilities.layoutCompoundLabel(
            jcomponent,
            fontmetrics,
            s,
            icon,
            stripebutton.verticalAlignment,
            stripebutton.horizontalAlignment,
            stripebutton.verticalTextPosition,
            stripebutton.horizontalTextPosition,
            d,
            b,
            c,
            if (stripebutton.text != null) stripebutton.iconTextGap else 0
        )
        val graphics2d = g as Graphics2D
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON)
        graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY)
        val buttonmodel = stripebutton.model
        val color = stripebutton.background
        var forPrint = false
        try {
            forPrint = jcomponent.isPaintingForPrint()
        } catch (e1: NoSuchMethodError) {
        }
        if (buttonmodel.isArmed && buttonmodel.isPressed || buttonmodel.isSelected) {
            val graphics2d1 = g
            val gradientpaint: Paint
            val w = stripebutton.width - 6
            val h = stripebutton.height - 6
            gradientpaint = if (!forPrint) {
                if (DockingAnchor.TOP == toolwindowanchor || DockingAnchor.BOTTOM == toolwindowanchor) GradientPaint(
                    0.0f,
                    0.0f,
                    color.darker(),
                    0.0f,
                    stripebutton.height.toFloat(),
                    color.brighter()
                ) else GradientPaint(0.0f, 0.0f, color.darker(), stripebutton.width.toFloat(), 0.0f, color.brighter())
            } else {
                color.darker()
            }
            graphics2d1.paint = gradientpaint

            //This list is comprised of floats and Colors, which together
            //constitute the gradient.
//            java.util.List gradient = (java.util.List)UIManager.get("Button.gradient");
//
//            if (gradient != null && w > 0 && 0 < h) {
//                float ratio1 = ((Number)gradient.get(0)).floatValue();
//                float ratio2 = ((Number)gradient.get(1)).floatValue();
//                Color c1 = (Color)gradient.get(2);
//                Color c2 = (Color)gradient.get(3);
//                Color c3 = (Color)gradient.get(4);
//                int mid = (int)(ratio1 * h);
//                int mid2 = (int)(ratio2 * h);
//                if (mid > 0) {
//                    graphics2d1.setPaint(new GradientPaint((float)0, (float)0, c1, (float)0,
//                                           (float)mid, c2));
//                    g.fillRect(0, 0, w, mid);
//                }
//                if (mid2 > 0) {
//                    graphics2d1.setColor(c2);
//                    g.fillRect(0, mid, w, mid2);
//                }
//                if (mid > 0) {
//                    graphics2d1.setPaint(new GradientPaint((float)0, (float)mid + mid2, c2,
//                                           (float)0, (float)mid * 2 + mid2, c1));
//                    g.fillRect(0, mid + mid2, w, mid);
//                }
//                if (h - mid * 2 - mid2 > 0) {
//                    graphics2d1.setPaint(new GradientPaint((float)0, (float)mid * 2 + mid2, c1,
//                                           (float)0, (float)h, c3));
//                    g.fillRect(0, mid * 2 + mid2, w, h - mid * 2 - mid2);
//                }
//            }
            graphics2d1.fillRoundRect(3, 3, w, h, 5, 5)
            g.setColor(Color.black)
            g.drawRoundRect(3, 3, stripebutton.width - 6, stripebutton.height - 6, 5, 5)
        } else {
            g.setColor(color)
            g.fillRoundRect(3, 3, stripebutton.width - 6, stripebutton.height - 6, 5, 5)
            g.setColor(Color.GRAY)
            g.drawRoundRect(3, 3, stripebutton.width - 6, stripebutton.height - 6, 5, 5)
        }
        if (buttonmodel.isRollover) {
            if (!buttonmodel.isArmed && !buttonmodel.isPressed && !buttonmodel.isSelected) {
                val graphics2d2 = g
                val gradientpaint1: Paint
                gradientpaint1 = if (!forPrint) {
                    if (DockingAnchor.TOP == toolwindowanchor || DockingAnchor.BOTTOM == toolwindowanchor) GradientPaint(
                        0.0f,
                        0.0f,
                        color,
                        0.0f,
                        stripebutton.height.toFloat(),
                        Color.white
                    ) else GradientPaint(0.0f, 0.0f, color, stripebutton.width.toFloat(), 0.0f, Color.white)
                } else {
                    color.darker()
                }
                graphics2d2.paint = gradientpaint1
                graphics2d2.fillRoundRect(3, 3, stripebutton.width - 6, stripebutton.height - 6, 5, 5)
            }
            g.setColor(Color.darkGray)
            g.drawRoundRect(3, 3, stripebutton.width - 6, stripebutton.height - 6, 5, 5)
        }
        var affinetransform: AffineTransform? = null
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            affinetransform = graphics2d.transform
            if (DockingAnchor.RIGHT == toolwindowanchor) {
                icon?.paintIcon(jcomponent, graphics2d, b.y, b.x)
                graphics2d.rotate(1.5707963267948966)
                graphics2d.translate(0, -jcomponent.getWidth())
            } else {
                icon?.paintIcon(jcomponent, graphics2d, b.y, jcomponent.getHeight() - b.x - icon.iconHeight)
                graphics2d.rotate(-1.5707963267948966)
                graphics2d.translate(-jcomponent.getHeight(), 0)
            }
        } else icon?.paintIcon(jcomponent, graphics2d, b.x, b.y)
        if (s != null) {
            if (buttonmodel.isEnabled) {
                if (buttonmodel.isArmed && buttonmodel.isPressed || buttonmodel.isSelected) g.setColor(color) else g.setColor(
                    stripebutton.foreground
                )
            } else {
                g.setColor(color.darker())
            }
            if (buttonmodel.isEnabled) {
                g.setColor(stripebutton.foreground)
                BasicGraphicsUtils.drawString(g, s1, stripebutton.mnemonic2, c.x, c.y + fontmetrics.ascent)
            } else {
                if (buttonmodel.isSelected) g.setColor(jcomponent.getBackground()) else g.setColor(disabledTextColor)
                BasicGraphicsUtils.drawString(g, s1, stripebutton.mnemonic2, c.x, c.y + fontmetrics.ascent)
            }
        }
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) graphics2d.transform =
            affinetransform
    }

    companion object {
        private val metalDockingButtonUI = MetalDockingButtonUI()

        // ********************************
        //        Create PLAF
        // ********************************
        fun createUI(b: JComponent?): ComponentUI {
            return metalDockingButtonUI
        }

        private val b = Rectangle()
        private val c = Rectangle()
        private val d = Rectangle()
        private var e = Insets(0, 0, 0, 0)
    }
}