/*
 * Copyright (c) 2007, Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing.plaf.synth

import com.macrofocus.docking.DockingAnchor
import com.macrofocus.docking.swing.DockingButton
import com.macrofocus.docking.swing.plaf.basic.BasicDockingButtonUI
import de.javasoft.plaf.synthetica.SyntheticaState
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter
import java.awt.*
import java.awt.geom.AffineTransform
import javax.swing.ButtonModel
import javax.swing.Icon
import javax.swing.JComponent
import javax.swing.SwingUtilities
import javax.swing.plaf.ComponentUI
import javax.swing.plaf.basic.BasicGraphicsUtils

class SynthDockingButtonUI : BasicDockingButtonUI() {
    override fun getPreferredSize(jcomponent: JComponent): Dimension {
        val stripebutton: DockingButton = jcomponent as DockingButton
        val dimension: Dimension = super.getPreferredSize(stripebutton)
        val toolwindowanchor: DockingAnchor = stripebutton.getOrientation()
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            dimension.width = (4f + dimension.width.toFloat() * 1f).toInt()
        } else {
            dimension.width = (4f + dimension.width.toFloat() * 1f).toInt()
        }
        dimension.height += 4
        return if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) Dimension(
            dimension.height,
            dimension.width
        ) else dimension
    }

    override fun paint(g: Graphics, view: JComponent) {
        val d: Dimension = view.getSize()
        val button: DockingButton = view as DockingButton
        val toolwindowanchor: DockingAnchor = button.getOrientation()
        val buttonmodel: ButtonModel = button.getModel()

        // Background
        val localSyntheticaState = SyntheticaState()
        if (buttonmodel.isPressed()) {
            localSyntheticaState.setState(SyntheticaState.State.PRESSED)
        }
        if (buttonmodel.isSelected()) {
            localSyntheticaState.setState(SyntheticaState.State.SELECTED)
        }
        if (buttonmodel.isArmed()) {
            localSyntheticaState.setState(SyntheticaState.State.ACTIVE)
        }
        if (!buttonmodel.isEnabled()) {
            localSyntheticaState.setState(SyntheticaState.State.DISABLED)
        }
        if (buttonmodel.isRollover()) {
            localSyntheticaState.setState(SyntheticaState.State.HOVER)
        }
        val side: Int
        val angle: Int
        val width: Int
        val height: Int
        if (toolwindowanchor == DockingAnchor.LEFT) {
            side = 2
            angle = -90
            width = d.height
            height = d.width
        } else if (toolwindowanchor == DockingAnchor.RIGHT) {
            side = 4
            angle = 90
            width = d.height
            height = d.width
        } else if (toolwindowanchor == DockingAnchor.TOP) {
            side = 1
            angle = 0
            width = d.width
            height = d.height
        } else if (toolwindowanchor == DockingAnchor.BOTTOM) {
            side = 3
            angle = 0
            width = d.width
            height = d.height
        } else {
            side = 0
            angle = 0
            width = d.width
            height = d.height
        }
        paintTabbedPaneTab(view, localSyntheticaState, 0, side, 0, angle, g, 0, 0, width, height)

        // Text
        val s: String? = button.getText()
        val icon: Icon? = if (button.isEnabled()) button.getIcon() else button.getDisabledIcon()
        if (icon == null && s == null) return
        var font: Font = button.getFont()
        if (buttonmodel.isSelected()) {
            font = font.deriveFont(Font.BOLD)
        }
        g.font = font
        val fontmetrics: FontMetrics = button.getFontMetrics(font)
        inset = view.getInsets(inset)
        r3.x = inset.left
        r3.y = inset.top
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            r3.height = view.getWidth() - (inset.left + inset.right)
            r3.width = view.getHeight() - (inset.top + inset.bottom)
        } else {
            r3.height = view.getHeight() - (inset.left + inset.right)
            r3.width = view.getWidth() - (inset.top + inset.bottom)
        }
        r1.height = 0
        r1.width = r1.height
        r1.y = r1.width
        r1.x = r1.y
        r2.height = 0
        r2.width = r2.height
        r2.y = r2.width
        r2.x = r2.y
        val s1: String = SwingUtilities.layoutCompoundLabel(
            view,
            fontmetrics,
            s,
            icon,
            button.getVerticalAlignment(),
            button.getHorizontalAlignment(),
            button.getVerticalTextPosition(),
            button.getHorizontalTextPosition(),
            r3,
            r1,
            r2,
            if (button.getText() != null) button.getIconTextGap() else 0
        )
        val graphics2d: Graphics2D = g as Graphics2D
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON)
        graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY)
        val color: Color = button.getBackground()
        var affinetransform: AffineTransform? = null
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) {
            affinetransform = graphics2d.getTransform()
            if (DockingAnchor.RIGHT == toolwindowanchor) {
                if (icon != null) icon.paintIcon(view, graphics2d, r1.y, r1.x)
                graphics2d.rotate(1.5707963267948966)
                graphics2d.translate(-2, -view.getWidth())
            } else {
                if (icon != null) icon.paintIcon(view, graphics2d, r1.y, view.getHeight() - r1.x - icon.iconHeight)
                graphics2d.rotate(-1.5707963267948966)
                graphics2d.translate(-view.getHeight() - 2, 0)
            }
        } else if (icon != null) icon.paintIcon(view, graphics2d, r1.x, r1.y)
        if (s != null) {
            if (buttonmodel.isEnabled()) {
                if (buttonmodel.isArmed() && buttonmodel.isPressed() || buttonmodel.isSelected()) g.color =
                    color else g.color = button.getForeground()
            } else {
                g.color = color.darker()
            }
            if (buttonmodel.isEnabled()) {
                g.color = button.getForeground()
                BasicGraphicsUtils.drawString(g, s1, button.mnemonic2, r2.x, r2.y + fontmetrics.ascent)
            } else {
                if (buttonmodel.isSelected()) g.color =
                    view.getBackground() else  //                    g.setColor(getDisabledTextColor());
                    BasicGraphicsUtils.drawString(g, s1, button.mnemonic2, r2.x, r2.y + fontmetrics.ascent)
            }
        }
        if (DockingAnchor.LEFT == toolwindowanchor || DockingAnchor.RIGHT == toolwindowanchor) graphics2d.setTransform(
            affinetransform
        )
    }

    /**
     * @param c
     * @param state
     * @param tabIndex
     * @param side      1 for top, 2 for left, 3 for bottom, and 4 for right
     * @param paramInt3
     * @param angle
     * @param g
     * @param x
     * @param y
     * @param width
     * @param height
     */
    fun paintTabbedPaneTab(
        c: JComponent?,
        state: SyntheticaState?,
        tabIndex: Int,
        side: Int,
        paramInt3: Int,
        angle: Int,
        g: Graphics?,
        x: Int,
        y: Int,
        width: Int,
        height: Int
    ) {
        TabbedPanePainter.getInstance()
            .paintTabbedPaneTab(c, state, tabIndex, side, paramInt3, angle, g, x, y, width, height)
    }

    companion object {
        private val synthDockingButtonUI = SynthDockingButtonUI()
        fun createUI(b: JComponent?): ComponentUI {
            return synthDockingButtonUI
        }

        private val r1 = Rectangle()
        private val r2 = Rectangle()
        private val r3 = Rectangle()
        private var inset = Insets(0, 0, 0, 0)
    }
}