/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.docking.swing.plaf.synth

import com.macrofocus.docking.swing.DockingViewTitleBar
import com.macrofocus.docking.swing.plaf.basic.BasicDockingViewTitleBarUI
import de.javasoft.docking.ui.painter.DockingPainter
import de.javasoft.plaf.synthetica.SyntheticaState
import java.awt.Graphics
import javax.swing.JComponent
import javax.swing.plaf.ComponentUI

class SyntheticaDockingViewTitleBarUI : BasicDockingViewTitleBarUI() {
    override fun installUI(paramJComponent: JComponent) {
        super.installUI(paramJComponent)
    }

    protected override fun paintBackground(
        paramJComponent: JComponent,
        paramGraphics: Graphics?,
        paramInt1: Int,
        paramInt2: Int,
        paramInt3: Int,
        paramInt4: Int
    ) {
        DockingPainter.getInstance().paintDockingTitleBarBackground(
            paramJComponent,
            SyntheticaState(if ((paramJComponent as DockingViewTitleBar).isActive()) SyntheticaState.State.SELECTED.toInt() else 0),
            paramGraphics,
            paramInt1,
            paramInt2,
            paramInt3,
            paramInt4
        )
    }

    companion object {
        fun createUI(paramJComponent: JComponent?): ComponentUI {
            return SyntheticaDockingViewTitleBarUI()
        }
    }
}