/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot.guide

import com.macrofocus.common.geom.Dimension
import com.macrofocus.common.transform.OneDScreenTransform
import org.mkui.geom.Rectangle2D
import org.mkui.graphics.IGraphics

class DefaultGridRenderer : GridRenderer {
    override fun drawGrid(
        g2: IGraphics,
        type: Guide.Type,
        coordinateAxis: OneDScreenTransform,
        axis: ValueAxis<*, *>,
        gridLineRenderer: GridLineRenderer,
        d: Dimension
    ) {
        if (coordinateAxis != null) {
            val min: Double = coordinateAxis.worldMin
            val max: Double = coordinateAxis.worldMax
            if (min <= max) {
                val dataArea: Rectangle2D = Rectangle2D.Double(0.0, 0.0, d.width.toDouble(), d.height.toDouble())
                axis.setRange(min, max)
                val ticks: List<ValueTick>
                ticks = when (type) {
                    Guide.Type.Top -> axis.refreshTicks(g2, dataArea, RectangleEdge.Top)
                    Guide.Type.Bottom -> axis.refreshTicks(g2, dataArea, RectangleEdge.Bottom)
                    Guide.Type.Left -> axis.refreshTicks(g2, dataArea, RectangleEdge.Left)
                    Guide.Type.Right -> axis.refreshTicks(g2, dataArea, RectangleEdge.Right)
                    else -> throw IllegalArgumentException()
                }

                // Draw vertical group starting lines
                for (tick in ticks) {
                    val t: com.macrofocus.plot.guide.ValueTick = tick
                    if (t.text != null && t.text.length > 0) {
                        val value: Double = t.value
                        gridLineRenderer.drawGridLine(g2, type, coordinateAxis, d, value)
                    }
                }
            }
        }
    }
}