package com.macrofocus.plot.guide

import org.mkui.font.MkFont

/**
 * The base class for all axes.  Subclasses are divided into
 * those that display values ([ValueAxis]) and those that display
 * categories.
 */
interface Axis<Color, Font> {
    /**
     * Returns the font used for the tick labels (if showing).
     *
     * @return The font (never `null`).
     */
    /**
     * Sets the font for the tick labels and sends an
     * to all registered listeners.
     *
     * @param font the font (`null` not allowed).
     */
    var tickLabelFont: MkFont?

    /**
     * Returns the insets for the tick labels.
     *
     * @return The insets (never `null`).
     */
    val tickLabelInsets: com.macrofocus.plot.guide.RectangleInsets?

    /**
     * Returns a flag indicating whether or not the tick labels are visible.
     *
     * @return The flag.
     */
    val isTickLabelsVisible: Boolean

    /**
     * Returns `true` if the axis is visible, and
     * `false` otherwise.
     *
     * @return A boolean.
     */
    val isVisible: Boolean
}