package com.macrofocus.plot.guide
/** A numerical tick.  */
class NumberTick : com.macrofocus.plot.guide.ValueTick {
    /**
     * Creates a new tick.
     *
     * @param number         the number (`null` not permitted).
     * @param label          the label.
     * @param textAnchor     the part of the label that is aligned with the anchor
     * point.
     * @param rotationAnchor defines the rotation point relative to the text.
     * @param angle          the rotation angle (in radians).
     */
    internal constructor(
        number: Number, label: String,
        textAnchor: TextAnchor?,
        rotationAnchor: TextAnchor?, angle: Double
    ) : super(number.toDouble(), label, textAnchor, rotationAnchor, angle) {
    }

    /**
     * Creates a new tick.
     *
     * @param value the value.
     */
    internal constructor(value: Double) : super(TickType.Minor, value, "", TextAnchor.TopCenter, TextAnchor.Center, 0.0) {}
}