package com.macrofocus.plot.guide

import com.macrofocus.common.format.CPFormat

/** A numerical tick unit.  */
internal class NumberTickUnit : TickUnit {
    /** A formatter for the tick unit.  */
    private val formatter: CPFormat<Any?>?

    /**
     * Creates a new number tick unit.
     *
     * @param size      the size of the tick unit.
     * @param formatter a number formatter for the tick unit (`null`
     * not permitted).
     */
    constructor(size: Double, formatter: CPFormat<Any?>?) : super(size) {
        this.formatter = formatter
    }

    /**
     * Creates a new number tick unit.
     *
     * @param size           the size of the tick unit.
     * @param formatter      a number formatter for the tick unit (`null`
     * not permitted).
     * @param minorTickCount the number of minor ticks.
     */
    constructor(
        size: Double, formatter: CPFormat<Any?>?,
        minorTickCount: Int
    ) : super(size, minorTickCount) {
        this.formatter = formatter
    }

    /**
     * Converts a value to a string.
     *
     * @param value the value.
     *
     * @return The formatted string.
     */
    override fun valueToString(value: Double): String {
        return formatter!!.format(value)!!
    }
}