package com.macrofocus.plot.guide
/**
 * An interface used by the [DateAxis] and [NumberAxis] classes to
 * obtain a suitable [TickUnit].
 */
interface TickUnitSource {
    /**
     * Returns a tick unit that is larger than the supplied unit.
     *
     * @param unit the unit.
     *
     * @return A tick unit that is larger than the supplied unit.
     */
    fun getLargerTickUnit(unit: TickUnit): com.macrofocus.plot.guide.TickUnit

    /**
     * Returns the tick unit in the collection that is greater than or equal
     * to (in size) the specified unit.
     *
     * @param unit the unit.
     *
     * @return A unit from the collection.
     */
    fun getCeilingTickUnit(unit: TickUnit): com.macrofocus.plot.guide.TickUnit

    /**
     * Returns the tick unit in the collection that is greater than or equal
     * to the specified size.
     *
     * @param size the size.
     *
     * @return A unit from the collection.
     */
    fun getCeilingTickUnit(size: Double): TickUnit
}