/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot

import com.macrofocus.common.format.CPFormat
import com.macrofocus.common.geom.Dimension
import org.mkui.component.CPComponent

interface AxisPlotPanel {
    val component: CPComponent

    val mainContainer: CPComponent
    val rightYAxisContainer: CPComponent
    val bottomTimeAxisContainer: CPComponent
    val leftYAxisContainer: CPComponent
    val topTimeAxisContainer: CPComponent
    fun valideAxis()
    fun addComponent(component: CPComponent)
    fun addBottomTimeAxisComponent(component: CPComponent)
    fun addTopTimeAxisComponent(component: CPComponent)
    fun addLeftYAxisComponent(component: CPComponent)
    fun addRightYAxisComponent(component: CPComponent)
    val panel: CPComponent
    val snapshotPanel: CPComponent

    /**
     * Sets the size of the left axis
     *
     * @param d the size of the left axis
     */
    fun setLeftAxisSize(d: Dimension?)

    /**
     * Sets the size of the top axis
     *
     * @param d the size of the top axis
     */
    fun setTopAxisSize(d: Dimension?)
    fun setBottomAxisSize(d: Dimension?)
    fun setLeftAxisVisible(visible: Boolean)
    fun setRightAxisVisible(visible: Boolean)
    fun setTopAxisVisible(visible: Boolean)
    fun setBottomAxisVisible(visible: Boolean)
    var showRightYAxis: Boolean
    var showBottomTimeAxis: Boolean
    var showLeftYAxis: Boolean
    var showTopTimeAxis: Boolean
    fun setXFormat(format: CPFormat<Any?>?)
    fun setYFormat(format: CPFormat<Any?>?)
}