package com.macrofocus.plot.guide
/** A record that contains the space required at each edge of a plot.  */
class AxisSpace
/** Creates a new axis space record.  */ internal constructor() {
    /**
     * Returns the space reserved for axes at the bottom of the plot area.
     *
     * @return The space (in Java2D units).
     */
    /** The bottom space.  */
    var bottom = 0.0
        private set
    /**
     * Returns the space reserved for axes at the left of the plot area.
     *
     * @return The space (in Java2D units).
     */
    /** The left space.  */
    var left = 0.0
        private set

    /**
     * Adds space to the top, bottom, left or right edge of the plot area.
     *
     * @param space the space (in Java2D units).
     * @param edge  the edge (`null` not permitted).
     */
    fun add(space: Double, edge: com.macrofocus.plot.guide.RectangleEdge?) {
        if (edge == com.macrofocus.plot.guide.RectangleEdge.Top) {
        } else if (edge == com.macrofocus.plot.guide.RectangleEdge.Bottom) {
            bottom += space
        } else if (edge == com.macrofocus.plot.guide.RectangleEdge.Left) {
            left += space
        } else if (edge == com.macrofocus.plot.guide.RectangleEdge.Right) {
        }
    }
}