/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactory;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.transform.OneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import com.macrofocus.plot.guide.AbstractGuide;
import com.macrofocus.plot.guide.AxisGuide;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.GridRenderer;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.NumberAxis;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.plot.guide.ValueTick;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.component.CPComponent;
import org.mkui.font.CPFontFactory;
import org.mkui.font.CPFontMetrics;
import org.mkui.font.Weight;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.CPHeadless;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010 \u001a\u00020\u001a2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001cH\u0002J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020$H\u0016J\u001a\u0010-\u001a\u00020\u001a2\u0010\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001eH\u0016J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010/\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u00100\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u00101\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u001aH\u0016J\b\u00105\u001a\u00020\u001aH\u0016J\b\u00106\u001a\u00020\u001aH\u0016J\u0018\u0010@\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;2\u0006\u0010>\u001a\u00020;H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010=R\u0016\u0010A\u001a\u0004\u0018\u00010$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0016\u0010D\u001a\u0004\u0018\u00010*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u00109\u00a8\u0006F"}, d2={"Lcom/macrofocus/plot/guide/AbstractAxisGuide;", "Lcom/macrofocus/plot/guide/AbstractGuide;", "Lcom/macrofocus/plot/guide/AxisGuide;", "type", "Lcom/macrofocus/plot/guide/Guide$Type;", "<init>", "(Lcom/macrofocus/plot/guide/Guide$Type;)V", "coordinateAxis", "Lcom/macrofocus/common/transform/OneDScreenTransform;", "(Lcom/macrofocus/plot/guide/Guide$Type;Lcom/macrofocus/common/transform/OneDScreenTransform;)V", "(Lcom/macrofocus/common/transform/OneDScreenTransform;)V", "()V", "canvas", "Lorg/mkui/canvas/CPCanvas;", "component", "Lorg/mkui/component/CPComponent;", "getComponent", "()Lorg/mkui/component/CPComponent;", "labelColor", "Lorg/mkui/color/MkColor;", "gridLinesColor", "paintTicks", "", "coordinateAxisListener", "Lcom/macrofocus/common/transform/ScreenTransformListener;", "refresh", "", "axis", "Lcom/macrofocus/plot/guide/ValueAxis;", "format", "Lcom/macrofocus/common/format/CPFormat;", "", "setCoordinateAxis", "computeSpace", "", "g2", "Lorg/mkui/graphics/IGraphics;", "dataArea", "Lorg/mkui/geom/Rectangle;", "getAxis", "drawGrid", "d", "Lcom/macrofocus/common/geom/Dimension;", "paintComponent", "g", "setFormat", "setAxis", "setGridLinesColor", "setLabelColor", "setPaintTicks", "toString", "", "invalidate", "revalidate", "repaint", "size", "getSize", "()Lcom/macrofocus/common/geom/Dimension;", "width", "", "getWidth", "()I", "height", "getHeight", "setSize", "graphics", "getGraphics", "()Lorg/mkui/graphics/IGraphics;", "preferredSize", "getPreferredSize", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public abstract class AbstractAxisGuide
extends AbstractGuide
implements AxisGuide {
    @NotNull
    private Guide.Type type;
    @NotNull
    private CPCanvas canvas;
    @NotNull
    private MkColor labelColor;
    @NotNull
    private MkColor gridLinesColor;
    private boolean paintTicks;
    @NotNull
    private final ScreenTransformListener coordinateAxisListener;
    @Nullable
    private OneDScreenTransform coordinateAxis;
    @Nullable
    private ValueAxis axis;
    @Nullable
    private CPFormat<Object> format;
    public static final int $stable = 8;

    public AbstractAxisGuide(@NotNull Guide.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.canvas = new CPCanvas();
        this.canvas.addLayer((IDrawing)new AbstractIDrawing(){

            public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
                this.paintComponent(g);
            }
        });
        this.labelColor = MkColorFactory.Companion.getInstance().getBlack();
        this.gridLinesColor = MkColorKt.colorOf((int)199, (int)199, (int)196);
        this.paintTicks = true;
        this.coordinateAxisListener = new ScreenTransformListener(this){
            final /* synthetic */ AbstractAxisGuide this$0;
            {
                this.this$0 = $receiver;
            }

            public void transformChanged(ScreenTransformEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AbstractAxisGuide.access$refresh(this.this$0);
            }
        };
    }

    @Override
    @NotNull
    public CPComponent getComponent() {
        return (CPComponent)this.canvas;
    }

    private final void refresh() {
        this.revalidate();
        this.repaint();
    }

    public AbstractAxisGuide(@NotNull Guide.Type type, @Nullable OneDScreenTransform coordinateAxis) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type);
        this.setCoordinateAxis(coordinateAxis);
    }

    public AbstractAxisGuide(@Nullable OneDScreenTransform coordinateAxis) {
        this(Guide.Type.Bottom);
        this.setCoordinateAxis(coordinateAxis);
    }

    public AbstractAxisGuide() {
        this(Guide.Type.Bottom);
    }

    @Override
    public void setCoordinateAxis(@Nullable OneDScreenTransform coordinateAxis) {
        if (this.coordinateAxis != null) {
            OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform);
            oneDScreenTransform.removeScreenTransformListener(this.coordinateAxisListener);
        }
        this.coordinateAxis = coordinateAxis;
        if (this.coordinateAxis != null) {
            OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform);
            oneDScreenTransform.addScreenTransformListener(this.coordinateAxisListener);
        }
        this.refresh();
    }

    @Override
    public double computeSpace(@NotNull IGraphics g2, @NotNull Rectangle dataArea) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)dataArea, (String)"dataArea");
        AxisSpace space = new AxisSpace();
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Top, space);
                return space.getBottom();
            }
            case 2: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom, space);
                return space.getBottom() + (double)4;
            }
            case 3: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Left, space);
                return space.getLeft();
            }
            case 4: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Right, space);
                return space.getLeft();
            }
        }
        throw new IllegalArgumentException();
    }

    private final ValueAxis getAxis() {
        if (this.axis == null) {
            ValueAxis valueAxis = this.axis = (ValueAxis)new NumberAxis(CPFontFactory.Companion.getInstance(), (IHeadless)CPHeadless.INSTANCE, FormatFactory.Companion.getInstance());
            Intrinsics.checkNotNull((Object)valueAxis);
            valueAxis.setTickLabelFont(CPFontFactory.Companion.getInstance().createFont("Roboto, Helvetica, Arial, sans-serif", Weight.NORMAL, 18));
            if (this.format != null) {
                ValueAxis valueAxis2 = this.axis;
                Intrinsics.checkNotNull((Object)valueAxis2);
                valueAxis2.setFormatOverride(this.format);
            }
        }
        ValueAxis valueAxis = this.axis;
        Intrinsics.checkNotNull((Object)valueAxis);
        return valueAxis;
    }

    @Override
    public void drawGrid(@NotNull IGraphics g2, @NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        GridRenderer gridRenderer = this.getGridRenderer();
        Guide.Type type = this.type;
        Intrinsics.checkNotNull((Object)((Object)type));
        OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
        Intrinsics.checkNotNull((Object)oneDScreenTransform);
        gridRenderer.drawGrid(g2, type, oneDScreenTransform, this.getAxis(), this.getGridLineRenderer(), d);
    }

    @Override
    public void paintComponent(@NotNull IGraphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Dimension d = this.getSize();
        if (this.coordinateAxis != null) {
            OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform);
            double d2 = oneDScreenTransform.getWorldMin();
            OneDScreenTransform oneDScreenTransform2 = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform2);
            double min = Math.min(d2, oneDScreenTransform2.getWorldMax());
            OneDScreenTransform oneDScreenTransform3 = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform3);
            double d3 = oneDScreenTransform3.getWorldMin();
            OneDScreenTransform oneDScreenTransform4 = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform4);
            double max = Math.max(d3, oneDScreenTransform4.getWorldMax());
            if (min <= max) {
                Dimension dimension = d;
                Intrinsics.checkNotNull((Object)dimension);
                Rectangle2D dataArea = (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), d.getHeight());
                this.getAxis().setRange(min, max);
                List<ValueTick> ticks = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 1 -> this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Top);
                    case 2 -> this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Bottom);
                    case 3 -> this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Left);
                    case 4 -> this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Right);
                    default -> throw new IllegalArgumentException();
                };
                block18: for (ValueTick tick : ticks) {
                    OneDScreenTransform oneDScreenTransform5 = this.coordinateAxis;
                    Intrinsics.checkNotNull((Object)oneDScreenTransform5);
                    ValueTick valueTick = tick;
                    Intrinsics.checkNotNull((Object)valueTick);
                    int position = oneDScreenTransform5.worldToScreen(valueTick.getValue());
                    if (this.paintTicks) {
                        MkColor mkColor = this.gridLinesColor;
                        Intrinsics.checkNotNull((Object)mkColor);
                        g.setColor(mkColor);
                        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                            case 1: {
                                g.drawLine((double)position, d.getHeight() - 5.0, (double)position, d.getHeight());
                                break;
                            }
                            case 2: {
                                g.drawLine(position, 0, position, 5);
                                break;
                            }
                            case 3: {
                                g.drawLine(d.getWidth() - 5.0, (double)position, d.getWidth(), (double)position);
                                break;
                            }
                            case 4: {
                                g.drawLine(0, position, 5, position);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    g.setColor(this.labelColor);
                    String text = tick.getText();
                    Intrinsics.checkNotNull((Object)g.getFontMetrics());
                    int width = (int)g.getStringWidth(text);
                    switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                        case 1: {
                            CPFontMetrics fontMetrics;
                            g.drawString(text, (float)(position - (width >> 1)), fontMetrics.getHeight());
                            continue block18;
                        }
                        case 2: {
                            g.drawString(text, (float)(position - (width >> 1)), (float)(d.getHeight() - (double)2));
                            continue block18;
                        }
                        case 3: {
                            CPFontMetrics fontMetrics;
                            g.drawString(text, (float)(d.getWidth() - (double)width - (double)7), (float)(position + (fontMetrics.getAscent() >> 1)));
                            continue block18;
                        }
                        case 4: {
                            CPFontMetrics fontMetrics;
                            g.drawString(text, 7.0f, (float)(position + (fontMetrics.getAscent() >> 1)));
                            continue block18;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Override
    public void setFormat(@Nullable CPFormat<Object> format) {
        this.format = format;
        if (this.axis != null) {
            ValueAxis valueAxis = this.axis;
            Intrinsics.checkNotNull((Object)valueAxis);
            valueAxis.setFormatOverride(this.format);
        }
        this.refresh();
    }

    @Override
    public void setAxis(@NotNull ValueAxis axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        this.axis = axis;
        this.refresh();
    }

    public final void setGridLinesColor(@NotNull MkColor gridLinesColor) {
        Intrinsics.checkNotNullParameter((Object)gridLinesColor, (String)"gridLinesColor");
        this.gridLinesColor = gridLinesColor;
        this.repaint();
    }

    public final void setLabelColor(@NotNull MkColor labelColor) {
        Intrinsics.checkNotNullParameter((Object)labelColor, (String)"labelColor");
        this.labelColor = labelColor;
        this.repaint();
    }

    public final void setPaintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
        this.repaint();
    }

    @NotNull
    public String toString() {
        return "AbstractAxisGuide{coordinateAxis=" + this.coordinateAxis + ", axis=" + this.axis + "}";
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint() {
        this.canvas.redraw();
    }

    @Override
    @Nullable
    public Dimension getSize() {
        return new Dimension((int)this.canvas.getWidth(), (int)this.canvas.getHeight());
    }

    @Override
    public int getWidth() {
        return (int)this.canvas.getWidth();
    }

    @Override
    public int getHeight() {
        return (int)this.canvas.getHeight();
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    @Nullable
    public IGraphics getGraphics() {
        return this.canvas.getIgraphics();
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public static final /* synthetic */ void access$refresh(AbstractAxisGuide $this) {
        $this.refresh();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Guide.Type.values().length];
            try {
                nArray[Guide.Type.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Guide.Type.Bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Guide.Type.Left.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Guide.Type.Right.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

