/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.date.CPTimeZone;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactory;
import com.macrofocus.common.locale.CPLocale;
import com.macrofocus.plot.datetime.CPCalendar;
import com.macrofocus.plot.guide.DateRange;
import com.macrofocus.plot.guide.DateTick;
import com.macrofocus.plot.guide.DateTickUnit;
import com.macrofocus.plot.guide.DateTickUnitType;
import com.macrofocus.plot.guide.DateTimeFormat;
import com.macrofocus.plot.guide.Month;
import com.macrofocus.plot.guide.Range;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.RectangleInsets;
import com.macrofocus.plot.guide.RegularTimePeriod;
import com.macrofocus.plot.guide.Tick;
import com.macrofocus.plot.guide.TickUnit;
import com.macrofocus.plot.guide.TickUnitSource;
import com.macrofocus.plot.guide.TickUnits;
import com.macrofocus.plot.guide.Timeline;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.plot.guide.ValueTick;
import com.macrofocus.plot.guide.Year;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import kotlinx.datetime.format.MonthNames;
import kotlinx.datetime.format.Padding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontFactory;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.CPHeadless;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 N2\u00020\u0001:\u0003LMNBI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u0019J\u001a\u0010\u001f\u001a\u00020\u001c2\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u0019H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0016J\u0012\u00102\u001a\u00020%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002J\u001c\u00103\u001a\u0004\u0018\u00010%2\u0006\u00104\u001a\u00020%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002J\u001a\u00105\u001a\u00020%2\u0006\u00104\u001a\u00020%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002J \u00106\u001a\u00020.2\u0006\u00107\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0014J \u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J \u0010@\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J \u0010A\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u001a\u0010B\u001a\u00020.2\u0006\u0010=\u001a\u00020>2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010C\u001a\u00020.2\u0006\u0010=\u001a\u00020>2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J&\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J&\u0010G\u001a\u0004\u0018\u00010%2\b\u0010H\u001a\u0004\u0018\u00010%2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010I\u001a\u00020\u0012H\u0002J&\u0010J\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J&\u0010K\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010'R\u0014\u00100\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006O"}, d2={"Lcom/macrofocus/plot/guide/DateAxis;", "Lcom/macrofocus/plot/guide/ValueAxis;", "fontFactory", "Lorg/mkui/font/CPFontFactory;", "headless", "Lorg/mkui/graphics/IHeadless;", "label", "", "zone", "Lcom/macrofocus/common/date/CPTimeZone;", "locale", "Lcom/macrofocus/common/locale/CPLocale;", "formatFactory", "Lcom/macrofocus/common/format/FormatFactory;", "<init>", "(Lorg/mkui/font/CPFontFactory;Lorg/mkui/graphics/IHeadless;Ljava/lang/String;Lcom/macrofocus/common/date/CPTimeZone;Lcom/macrofocus/common/locale/CPLocale;Lcom/macrofocus/common/format/FormatFactory;)V", "(Lorg/mkui/font/CPFontFactory;Lorg/mkui/graphics/IHeadless;Lcom/macrofocus/common/format/FormatFactory;)V", "tickMarkPosition", "Lcom/macrofocus/plot/guide/DateAxis$DateTickMarkPosition;", "timeZone", "timeline", "Lcom/macrofocus/plot/guide/Timeline;", "tickUnit", "Lcom/macrofocus/plot/guide/DateTickUnit;", "dateFormatOverride", "Lcom/macrofocus/common/format/CPFormat;", "", "setTickUnit", "", "unit", "getDateFormatOverride", "setFormatOverride", "formatter", "setRange", "range", "Lcom/macrofocus/plot/guide/Range;", "minimumDate", "Lkotlinx/datetime/Instant;", "getMinimumDate", "()Lkotlinx/datetime/Instant;", "turnOffAutoRange", "", "notify", "maximumDate", "getMaximumDate", "lower", "", "upper", "isHiddenValue", "()Z", "calculateLowestVisibleTickValue", "previousStandardDate", "date", "nextStandardDate", "valueToJava2D", "value", "area", "Lorg/mkui/geom/Rectangle2D;", "edge", "Lcom/macrofocus/plot/guide/RectangleEdge;", "selectAutoTickUnit", "g2", "Lorg/mkui/graphics/IGraphics;", "dataArea", "selectHorizontalAutoTickUnit", "selectVerticalAutoTickUnit", "estimateMaximumTickLabelWidth", "estimateMaximumTickLabelHeight", "refreshTicks", "", "Lcom/macrofocus/plot/guide/ValueTick;", "correctTickDateForPosition", "time", "position", "refreshTicksHorizontal", "refreshTicksVertical", "DefaultTimeline", "DateTickMarkPosition", "Companion", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class DateAxis
extends ValueAxis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DateTickMarkPosition tickMarkPosition;
    @Nullable
    private final CPTimeZone timeZone;
    @Nullable
    private final CPLocale locale;
    @NotNull
    private final Timeline timeline;
    @Nullable
    private DateTickUnit tickUnit;
    @Nullable
    private CPFormat<Object> dateFormatOverride;
    public static final int $stable = 8;
    @NotNull
    private static final DateRange DEFAULT_DATE_RANGE = new DateRange();
    @Nullable
    private static DateTickUnit DEFAULT_DATE_TICK_UNIT;
    @NotNull
    private static final Timeline DEFAULT_TIMELINE;

    public DateAxis(@NotNull CPFontFactory fontFactory, @NotNull IHeadless headless, @Nullable String label, @Nullable CPTimeZone zone, @Nullable CPLocale locale, @NotNull FormatFactory formatFactory) {
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        Intrinsics.checkNotNullParameter((Object)formatFactory, (String)"formatFactory");
        super(fontFactory, headless, label, DateAxis.Companion.createStandardDateTickUnits(zone, locale, formatFactory));
        this.tickMarkPosition = DateTickMarkPosition.Start;
        if (DEFAULT_DATE_TICK_UNIT == null) {
            DEFAULT_DATE_TICK_UNIT = new DateTickUnit(DateTickUnitType.Companion.getDAY(), (CPFormat<Object>)((CPFormat)new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(DateAxis::_init_$lambda$0))));
        }
        this.tickUnit = DEFAULT_DATE_TICK_UNIT;
        this.setRange(DEFAULT_DATE_RANGE, false, false);
        this.dateFormatOverride = null;
        this.timeZone = zone;
        this.locale = locale;
        this.timeline = DEFAULT_TIMELINE;
    }

    public /* synthetic */ DateAxis(CPFontFactory cPFontFactory, IHeadless iHeadless, String string, CPTimeZone cPTimeZone, CPLocale cPLocale, FormatFactory formatFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            cPFontFactory = CPFontFactory.Companion.getInstance();
        }
        if ((n & 2) != 0) {
            iHeadless = (IHeadless)CPHeadless.INSTANCE;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            cPTimeZone = null;
        }
        if ((n & 0x10) != 0) {
            cPLocale = null;
        }
        if ((n & 0x20) != 0) {
            formatFactory = FormatFactory.Companion.getInstance();
        }
        this(cPFontFactory, iHeadless, string, cPTimeZone, cPLocale, formatFactory);
    }

    public DateAxis(@NotNull CPFontFactory fontFactory, @NotNull IHeadless headless, @NotNull FormatFactory formatFactory) {
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        Intrinsics.checkNotNullParameter((Object)formatFactory, (String)"formatFactory");
        this(fontFactory, headless, null, null, null, formatFactory);
    }

    public final void setTickUnit(@Nullable DateTickUnit unit) {
        this.tickUnit = unit;
    }

    @Nullable
    public final CPFormat<Object> getDateFormatOverride() {
        return this.dateFormatOverride;
    }

    @Override
    public void setFormatOverride(@Nullable CPFormat<Object> formatter) {
        this.dateFormatOverride = formatter;
    }

    @Override
    public void setRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.setRange(range, true, true);
    }

    private final Instant getMinimumDate() {
        Instant result = null;
        Range range = this.getRange();
        Intrinsics.checkNotNull((Object)range);
        Range range2 = range;
        if (range2 instanceof DateRange) {
            DateRange r = (DateRange)range2;
            result = r.getLowerDate();
        } else {
            result = Instant.Companion.fromEpochMilliseconds(((Long)range2.getLowerBound()).longValue());
        }
        return result;
    }

    @Override
    public void setRange(@NotNull Range range, boolean turnOffAutoRange, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Range range2 = range;
        if (!(range2 instanceof DateRange)) {
            range2 = new DateRange(range2);
        }
        super.setRange(range2, turnOffAutoRange, notify);
    }

    private final Instant getMaximumDate() {
        Instant result = null;
        Range range = this.getRange();
        Intrinsics.checkNotNull((Object)range);
        Range range2 = range;
        if (range2 instanceof DateRange) {
            DateRange r = (DateRange)range2;
            result = r.getUpperDate();
        } else {
            result = Instant.Companion.fromEpochMilliseconds(((Long)range2.getUpperBound()).longValue());
        }
        return result;
    }

    @Override
    public void setRange(double lower, double upper) {
        if (!(lower < upper)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.setRange(new DateRange(lower, upper));
    }

    private final boolean isHiddenValue() {
        return !this.timeline.containsDomainValue();
    }

    private final Instant calculateLowestVisibleTickValue(DateTickUnit unit) {
        return this.nextStandardDate(this.getMinimumDate(), unit);
    }

    private final Instant previousStandardDate(Instant date, DateTickUnit unit) {
        Instant instant;
        CPCalendar calendar = new CPCalendar();
        calendar.setTime(date);
        DateTickUnit dateTickUnit = unit;
        Intrinsics.checkNotNull((Object)dateTickUnit);
        int count = dateTickUnit.getCount();
        int current = calendar.get(unit.getCalendarField());
        int value = count * current / count;
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int milliseconds = 0;
        int n = unit.getUnit();
        if (n == DateTickUnit.Companion.getMILLISECOND()) {
            years = calendar.get(1);
            months = calendar.get(2);
            days = calendar.get(5);
            hours = calendar.get(11);
            minutes = calendar.get(12);
            seconds = calendar.get(13);
            calendar.setAll(years, months, days, hours, minutes, seconds);
            calendar.set(14, value);
            Instant instant2 = calendar.getTime();
            Intrinsics.checkNotNull((Object)instant2);
            Instant mm = instant2;
            if (mm.toEpochMilliseconds() >= date.toEpochMilliseconds()) {
                calendar.set(14, value - 1);
                Instant instant3 = calendar.getTime();
                Intrinsics.checkNotNull((Object)instant3);
                mm = instant3;
            }
            instant = mm;
        } else if (n == DateTickUnit.Companion.getSECOND()) {
            years = calendar.get(1);
            months = calendar.get(2);
            days = calendar.get(5);
            hours = calendar.get(11);
            minutes = calendar.get(12);
            milliseconds = this.tickMarkPosition == DateTickMarkPosition.Start ? 0 : (this.tickMarkPosition == DateTickMarkPosition.Middle ? 500 : 999);
            calendar.set(14, milliseconds);
            calendar.setAll(years, months, days, hours, minutes, value);
            Instant instant4 = calendar.getTime();
            Intrinsics.checkNotNull((Object)instant4);
            Instant dd = instant4;
            if (dd.toEpochMilliseconds() >= date.toEpochMilliseconds()) {
                calendar.set(13, value - 1);
                Instant instant5 = calendar.getTime();
                Intrinsics.checkNotNull((Object)instant5);
                dd = instant5;
            }
            instant = dd;
        } else if (n == DateTickUnit.Companion.getMINUTE()) {
            years = calendar.get(1);
            months = calendar.get(2);
            days = calendar.get(5);
            hours = calendar.get(11);
            seconds = this.tickMarkPosition == DateTickMarkPosition.Start ? 0 : (this.tickMarkPosition == DateTickMarkPosition.Middle ? 30 : 59);
            calendar.clear(14);
            calendar.setAll(years, months, days, hours, value, seconds);
            Instant instant6 = calendar.getTime();
            Intrinsics.checkNotNull((Object)instant6);
            Instant d0 = instant6;
            if (d0.toEpochMilliseconds() >= date.toEpochMilliseconds()) {
                calendar.set(12, value - 1);
                Instant instant7 = calendar.getTime();
                Intrinsics.checkNotNull((Object)instant7);
                d0 = instant7;
            }
            instant = d0;
        } else if (n == DateTickUnit.Companion.getHOUR()) {
            years = calendar.get(1);
            months = calendar.get(2);
            days = calendar.get(5);
            if (this.tickMarkPosition == DateTickMarkPosition.Start) {
                minutes = 0;
                seconds = 0;
            } else if (this.tickMarkPosition == DateTickMarkPosition.Middle) {
                minutes = 30;
                seconds = 0;
            } else {
                minutes = 59;
                seconds = 59;
            }
            calendar.clear(14);
            calendar.setAll(years, months, days, value, minutes, seconds);
            Instant instant8 = calendar.getTime();
            Intrinsics.checkNotNull((Object)instant8);
            Instant d1 = instant8;
            if (d1.toEpochMilliseconds() >= date.toEpochMilliseconds()) {
                calendar.set(11, value - 1);
                Instant instant9 = calendar.getTime();
                Intrinsics.checkNotNull((Object)instant9);
                d1 = instant9;
            }
            instant = d1;
        } else if (n == DateTickUnit.Companion.getDAY()) {
            years = calendar.get(1);
            months = calendar.get(2);
            if (this.tickMarkPosition == DateTickMarkPosition.Start) {
                hours = 0;
                minutes = 0;
                seconds = 0;
            } else if (this.tickMarkPosition == DateTickMarkPosition.Middle) {
                hours = 12;
                minutes = 0;
                seconds = 0;
            } else {
                hours = 23;
                minutes = 59;
                seconds = 59;
            }
            calendar.clear(14);
            calendar.setAll(years, months, value, hours, 0, 0);
            Instant instant10 = calendar.getTime();
            Intrinsics.checkNotNull((Object)instant10);
            Instant d2 = instant10;
            if (d2.toEpochMilliseconds() >= date.toEpochMilliseconds()) {
                calendar.set(5, value - 1);
                Instant instant11 = calendar.getTime();
                Intrinsics.checkNotNull((Object)instant11);
                d2 = instant11;
            }
            instant = d2;
        } else if (n == DateTickUnit.Companion.getMONTH()) {
            Instant standardDate;
            years = calendar.get(1);
            calendar.clear(14);
            calendar.setAll(years, value, 1, 0, 0, 0);
            Month month = new Month(calendar.getTime(), this.timeZone, this.locale);
            Instant instant12 = standardDate = DateAxis.Companion.calculateDateForPosition(month, this.tickMarkPosition);
            Intrinsics.checkNotNull((Object)instant12);
            long millis = instant12.toEpochMilliseconds();
            if (millis >= date.toEpochMilliseconds()) {
                RegularTimePeriod regularTimePeriod = month.previous();
                Intrinsics.checkNotNull((Object)regularTimePeriod, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.Month");
                month = (Month)regularTimePeriod;
                month.peg(new CPCalendar());
                standardDate = DateAxis.Companion.calculateDateForPosition(month, this.tickMarkPosition);
            }
            instant = standardDate;
        } else if (n == DateTickUnit.Companion.getYEAR()) {
            if (this.tickMarkPosition == DateTickMarkPosition.Start) {
                months = 0;
                days = 1;
            } else if (this.tickMarkPosition == DateTickMarkPosition.Middle) {
                months = 6;
                days = 1;
            } else {
                months = 11;
                days = 31;
            }
            calendar.clear(14);
            calendar.setAll(value, months, days, 0, 0, 0);
            Instant instant13 = calendar.getTime();
            Intrinsics.checkNotNull((Object)instant13);
            Instant d3 = instant13;
            if (d3.toEpochMilliseconds() >= date.toEpochMilliseconds()) {
                calendar.set(1, value - 1);
                Instant instant14 = calendar.getTime();
                Intrinsics.checkNotNull((Object)instant14);
                d3 = instant14;
            }
            instant = d3;
        } else {
            instant = null;
        }
        return instant;
    }

    private final Instant nextStandardDate(Instant date, DateTickUnit unit) {
        Instant previous = this.previousStandardDate(date, unit);
        CPCalendar calendar = new CPCalendar();
        calendar.setTime(previous);
        DateTickUnit dateTickUnit = unit;
        Intrinsics.checkNotNull((Object)dateTickUnit);
        calendar.add(dateTickUnit.getCalendarField(), unit.getMultiple());
        Instant instant = calendar.getTime();
        Intrinsics.checkNotNull((Object)instant);
        return instant;
    }

    @Override
    protected double valueToJava2D(double value, @NotNull Rectangle2D area, @NotNull RectangleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        double value2 = value;
        value2 = this.timeline.toTimelineValue((long)value2);
        Range range = this.getRange();
        Intrinsics.checkNotNull((Object)range, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateRange");
        DateRange range2 = (DateRange)range;
        double axisMin = this.timeline.toTimelineValue(range2.getLowerMillis());
        double axisMax = this.timeline.toTimelineValue(range2.getUpperMillis());
        double result = 0.0;
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            double minX = area.getX();
            double maxX = area.getMaxX();
            result = this.isInverted() ? maxX + (value2 - axisMin) / (axisMax - axisMin) * minX - maxX : minX + (value2 - axisMin) / (axisMax - axisMin) * maxX - minX;
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            double minY = area.getMinY();
            double maxY = area.getMaxY();
            result = this.isInverted() ? minY + (value2 - axisMin) / (axisMax - axisMin) * maxY - minY : maxY - (value2 - axisMin) / (axisMax - axisMin) * maxY - minY;
        }
        return result;
    }

    private final void selectAutoTickUnit(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            this.selectHorizontalAutoTickUnit(g2, dataArea, edge);
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            this.selectVerticalAutoTickUnit(g2, dataArea, edge);
        }
    }

    private final void selectHorizontalAutoTickUnit(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        long shift = 0L;
        double zero = this.valueToJava2D((double)shift + 0.0, dataArea, edge);
        double tickLabelWidth = this.estimateMaximumTickLabelWidth(g2, this.tickUnit);
        TickUnitSource tickUnits = this.getStandardTickUnits();
        DateTickUnit dateTickUnit = this.tickUnit;
        Intrinsics.checkNotNull((Object)dateTickUnit, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateTickUnit");
        TickUnit unit1 = tickUnits.getCeilingTickUnit(dateTickUnit);
        double x1 = this.valueToJava2D((double)shift + unit1.getSize(), dataArea, edge);
        double unit1Width = Math.abs(x1 - zero);
        double guess = tickLabelWidth / unit1Width * unit1.getSize();
        TickUnit tickUnit = tickUnits.getCeilingTickUnit(guess);
        Intrinsics.checkNotNull((Object)tickUnit, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateTickUnit");
        DateTickUnit unit2 = (DateTickUnit)tickUnit;
        double x2 = this.valueToJava2D((double)shift + unit2.getSize(), dataArea, edge);
        double unit2Width = Math.abs(x2 - zero);
        tickLabelWidth = this.estimateMaximumTickLabelWidth(g2, unit2);
        if (tickLabelWidth > unit2Width) {
            TickUnit tickUnit2 = tickUnits.getLargerTickUnit(unit2);
            Intrinsics.checkNotNull((Object)tickUnit2, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateTickUnit");
            unit2 = (DateTickUnit)tickUnit2;
        }
        this.tickUnit = unit2;
    }

    private final void selectVerticalAutoTickUnit(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        DateTickUnit dateTickUnit;
        TickUnitSource tickUnits = this.getStandardTickUnits();
        double zero = this.valueToJava2D(0.0, dataArea, edge);
        Range range = this.getRange();
        Intrinsics.checkNotNull((Object)range);
        double estimate1 = range.getLength() / 10.0;
        TickUnit tickUnit = tickUnits.getCeilingTickUnit(estimate1);
        Intrinsics.checkNotNull((Object)tickUnit, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateTickUnit");
        DateTickUnit candidate1 = (DateTickUnit)tickUnit;
        double labelHeight1 = this.estimateMaximumTickLabelHeight(g2, candidate1);
        double y1 = this.valueToJava2D(candidate1.getSize(), dataArea, edge);
        double candidate1UnitHeight = Math.abs(y1 - zero);
        double estimate2 = labelHeight1 / candidate1UnitHeight * candidate1.getSize();
        TickUnit tickUnit2 = tickUnits.getCeilingTickUnit(estimate2);
        Intrinsics.checkNotNull((Object)tickUnit2, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateTickUnit");
        DateTickUnit candidate2 = (DateTickUnit)tickUnit2;
        double labelHeight2 = this.estimateMaximumTickLabelHeight(g2, candidate2);
        double y2 = this.valueToJava2D(candidate2.getSize(), dataArea, edge);
        double unit2Height = Math.abs(y2 - zero);
        DateTickUnit finalUnit = null;
        if (labelHeight2 < unit2Height) {
            dateTickUnit = candidate2;
        } else {
            TickUnit tickUnit3 = tickUnits.getLargerTickUnit(candidate2);
            Intrinsics.checkNotNull((Object)tickUnit3, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateTickUnit");
            dateTickUnit = (DateTickUnit)tickUnit3;
        }
        this.tickUnit = finalUnit = dateTickUnit;
    }

    private final double estimateMaximumTickLabelWidth(IGraphics g2, DateTickUnit unit) {
        RectangleInsets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.getLeft() + tickLabelInsets.getRight();
        if (this.isVerticalTickLabels()) {
            result += (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "Dummy");
        } else {
            Range range = this.getRange();
            Intrinsics.checkNotNull((Object)range, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateRange");
            DateRange range2 = (DateRange)range;
            Instant lower = range2.getLowerDate();
            Instant upper = range2.getUpperDate();
            String lowerStr = null;
            String upperStr = null;
            CPFormat<Object> formatter = this.dateFormatOverride;
            if (formatter != null) {
                String string = formatter.format((Object)lower);
                Intrinsics.checkNotNull((Object)string);
                lowerStr = string;
                String string2 = formatter.format((Object)upper);
                Intrinsics.checkNotNull((Object)string2);
                upperStr = string2;
            } else {
                DateTickUnit dateTickUnit = unit;
                Intrinsics.checkNotNull((Object)dateTickUnit);
                lowerStr = dateTickUnit.dateToString(lower);
                upperStr = unit.dateToString(upper);
            }
            double w1 = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), lowerStr);
            double w2 = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), upperStr);
            result += Math.max(w1, w2);
        }
        return result;
    }

    private final double estimateMaximumTickLabelHeight(IGraphics g2, DateTickUnit unit) {
        RectangleInsets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.getTop() + tickLabelInsets.getBottom();
        if (this.isVerticalTickLabels()) {
            Range range = this.getRange();
            Intrinsics.checkNotNull((Object)range, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.DateRange");
            DateRange range2 = (DateRange)range;
            Instant lower = range2.getLowerDate();
            Instant upper = range2.getUpperDate();
            String lowerStr = null;
            String upperStr = null;
            CPFormat<Object> formatter = this.dateFormatOverride;
            if (formatter != null) {
                String string = formatter.format((Object)lower);
                Intrinsics.checkNotNull((Object)string);
                lowerStr = string;
                String string2 = formatter.format((Object)upper);
                Intrinsics.checkNotNull((Object)string2);
                upperStr = string2;
            } else {
                lowerStr = unit.dateToString(lower);
                upperStr = unit.dateToString(upper);
            }
            double w1 = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), lowerStr);
            double w2 = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), upperStr);
            result += Math.max(w1, w2);
        } else {
            result += (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "Dummy");
        }
        return result;
    }

    @Override
    @NotNull
    public List<ValueTick> refreshTicks(@NotNull IGraphics g2, @NotNull Rectangle2D dataArea, @NotNull RectangleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)dataArea, (String)"dataArea");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        List<ValueTick> result = null;
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            result = this.refreshTicksHorizontal(g2, dataArea, edge);
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            result = this.refreshTicksVertical(g2, dataArea, edge);
        }
        List<ValueTick> list = result;
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final Instant correctTickDateForPosition(Instant time, DateTickUnit unit, DateTickMarkPosition position) {
        Instant result = time;
        DateTickUnit dateTickUnit = unit;
        Intrinsics.checkNotNull((Object)dateTickUnit);
        int n = dateTickUnit.getUnit();
        if (n != DateTickUnit.Companion.getMILLISECOND() && n != DateTickUnit.Companion.getSECOND() && n != DateTickUnit.Companion.getMINUTE() && n != DateTickUnit.Companion.getHOUR() && n != DateTickUnit.Companion.getDAY()) {
            if (n == DateTickUnit.Companion.getMONTH()) {
                result = DateAxis.Companion.calculateDateForPosition(new Month(time, this.timeZone, this.locale), position);
            } else if (n == DateTickUnit.Companion.getYEAR()) {
                result = DateAxis.Companion.calculateDateForPosition(new Year(time, this.timeZone, this.locale), position);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ValueTick> refreshTicksHorizontal(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        result = new ArrayList<E>();
        g2.setFont(this.getTickLabelFont());
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, dataArea, edge);
        }
        unit = this.tickUnit;
        tickDate = this.calculateLowestVisibleTickValue(unit);
        upperDate = this.getMaximumDate();
        block0: while (true) {
            v0 = tickDate;
            Intrinsics.checkNotNull((Object)v0);
            if (v0.compareTo(upperDate) >= 0) break;
            v1 = tickDate = this.correctTickDateForPosition(tickDate, unit, this.tickMarkPosition);
            Intrinsics.checkNotNull((Object)v1);
            lowestTickTime = v1.toEpochMilliseconds();
            v2 = unit;
            Intrinsics.checkNotNull((Object)v2);
            distance = v2.addToDate(tickDate, this.timeZone).toEpochMilliseconds() - lowestTickTime;
            minorTickSpaces = this.getMinorTickCount();
            if (minorTickSpaces <= 0) {
                minorTickSpaces = unit.getMinorTickCount();
            }
            var14_13 = minorTickSpaces;
            for (minorTick = 1; minorTick < var14_13; ++minorTick) {
                minorTickTime = lowestTickTime - distance * (long)minorTick / (long)minorTickSpaces;
                if (minorTickTime <= 0L) continue;
                v3 = this.getRange();
                Intrinsics.checkNotNull((Object)v3);
                if (!v3.contains(minorTickTime) || this.isHiddenValue()) continue;
                result.add(new DateTick(ValueTick.TickType.Minor, Instant.Companion.fromEpochMilliseconds(minorTickTime), "", Tick.TextAnchor.TopCenter, Tick.TextAnchor.Center, 0.0));
            }
            if (this.isHiddenValue()) {
                tickDate = unit.rollDate(tickDate, this.timeZone);
                continue;
            }
            tickLabel = null;
            v4 = formatter = this.dateFormatOverride;
            if (v4 != null) {
                v5 = v4.format((Object)tickDate);
                v6 = v5;
                Intrinsics.checkNotNull((Object)v5);
            } else {
                v7 = this.tickUnit;
                Intrinsics.checkNotNull((Object)v7);
                v6 = v7.dateToString(tickDate);
            }
            tickLabel = v6;
            anchor = null;
            rotationAnchor = null;
            angle = 0.0;
            if (this.isVerticalTickLabels()) {
                anchor = Tick.TextAnchor.CenterRight;
                rotationAnchor = Tick.TextAnchor.CenterRight;
                angle = edge == RectangleEdge.Top ? 1.5707963267948966 : -1.5707963267948966;
            } else if (edge == RectangleEdge.Top) {
                anchor = Tick.TextAnchor.BottomCenter;
                rotationAnchor = Tick.TextAnchor.BottomCenter;
            } else {
                anchor = Tick.TextAnchor.TopCenter;
                rotationAnchor = Tick.TextAnchor.TopCenter;
            }
            tick = new DateTick(tickDate, tickLabel, anchor, rotationAnchor, angle);
            result.add(tick);
            currentTickTime = tickDate.toEpochMilliseconds();
            tickDate = unit.addToDate(tickDate, this.timeZone);
            nextTickTime = tickDate.toEpochMilliseconds();
            minorTick = 1;
            var25_23 = minorTickSpaces;
            while (true) {
                if (minorTick < var25_23) ** break;
                continue block0;
                minorTickTime = currentTickTime + (nextTickTime - currentTickTime) * (long)minorTick / (long)minorTickSpaces;
                v8 = this.getRange();
                Intrinsics.checkNotNull((Object)v8);
                if (v8.contains(minorTickTime) && !this.isHiddenValue()) {
                    result.add(new DateTick(ValueTick.TickType.Minor, Instant.Companion.fromEpochMilliseconds(minorTickTime), "", Tick.TextAnchor.TopCenter, Tick.TextAnchor.Center, 0.0));
                }
                ++minorTick;
            }
            break;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ValueTick> refreshTicksVertical(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        result = new ArrayList<E>();
        g2.setFont(this.getTickLabelFont());
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, dataArea, edge);
        }
        unit = this.tickUnit;
        tickDate = this.calculateLowestVisibleTickValue(unit);
        upperDate = this.getMaximumDate();
        block0: while (true) {
            v0 = tickDate;
            Intrinsics.checkNotNull((Object)v0);
            if (v0.compareTo(upperDate) >= 0) break;
            v1 = tickDate = this.correctTickDateForPosition(tickDate, unit, this.tickMarkPosition);
            Intrinsics.checkNotNull((Object)v1);
            lowestTickTime = v1.toEpochMilliseconds();
            v2 = unit;
            Intrinsics.checkNotNull((Object)v2);
            distance = v2.addToDate(tickDate, this.timeZone).toEpochMilliseconds() - lowestTickTime;
            minorTickSpaces = this.getMinorTickCount();
            if (minorTickSpaces <= 0) {
                minorTickSpaces = unit.getMinorTickCount();
            }
            var14_13 = minorTickSpaces;
            for (minorTick = 1; minorTick < var14_13; ++minorTick) {
                minorTickTime = lowestTickTime - distance * (long)minorTick / (long)minorTickSpaces;
                if (minorTickTime <= 0L) continue;
                v3 = this.getRange();
                Intrinsics.checkNotNull((Object)v3);
                if (!v3.contains(minorTickTime) || this.isHiddenValue()) continue;
                result.add(new DateTick(ValueTick.TickType.Minor, Instant.Companion.fromEpochMilliseconds(minorTickTime), "", Tick.TextAnchor.TopCenter, Tick.TextAnchor.Center, 0.0));
            }
            if (this.isHiddenValue()) {
                tickDate = unit.rollDate(tickDate, this.timeZone);
                continue;
            }
            tickLabel = null;
            v4 = formatter = this.dateFormatOverride;
            if (v4 != null) {
                v5 = v4.format((Object)tickDate);
                v6 = v5;
                Intrinsics.checkNotNull((Object)v5);
            } else {
                v7 = this.tickUnit;
                Intrinsics.checkNotNull((Object)v7);
                v6 = v7.dateToString(tickDate);
            }
            tickLabel = v6;
            anchor = null;
            rotationAnchor = null;
            angle = 0.0;
            if (this.isVerticalTickLabels()) {
                anchor = Tick.TextAnchor.BottomCenter;
                rotationAnchor = Tick.TextAnchor.BottomCenter;
                angle = edge == RectangleEdge.Left ? -1.5707963267948966 : 1.5707963267948966;
            } else if (edge == RectangleEdge.Left) {
                anchor = Tick.TextAnchor.CenterRight;
                rotationAnchor = Tick.TextAnchor.CenterRight;
            } else {
                anchor = Tick.TextAnchor.CenterLeft;
                rotationAnchor = Tick.TextAnchor.CenterLeft;
            }
            tick = new DateTick(tickDate, tickLabel, anchor, rotationAnchor, angle);
            result.add(tick);
            currentTickTime = tickDate.toEpochMilliseconds();
            tickDate = unit.addToDate(tickDate, this.timeZone);
            nextTickTime = tickDate.toEpochMilliseconds();
            minorTick = 1;
            var25_23 = minorTickSpaces;
            while (true) {
                if (minorTick < var25_23) ** break;
                continue block0;
                minorTickTime = currentTickTime + (nextTickTime - currentTickTime) * (long)minorTick / (long)minorTickSpaces;
                v8 = this.getRange();
                Intrinsics.checkNotNull((Object)v8);
                if (v8.contains(minorTickTime) && !this.isHiddenValue()) {
                    result.add(new DateTick(ValueTick.TickType.Minor, Instant.Companion.fromEpochMilliseconds(minorTickTime), "", Tick.TextAnchor.TopCenter, Tick.TextAnchor.Center, 0.0));
                }
                ++minorTick;
            }
            break;
        }
        return result;
    }

    private static final Unit _init_$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        $this$Format.dayOfMonth(Padding.NONE);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'.');
        $this$Format.monthNumber(Padding.NONE);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'.');
        DateTimeFormatBuilder.WithDate.DefaultImpls.year$default((DateTimeFormatBuilder.WithDate)((DateTimeFormatBuilder.WithDate)$this$Format), null, (int)1, null);
        return Unit.INSTANCE;
    }

    public DateAxis() {
        this(null, null, null, null, null, null, 63, null);
    }

    static {
        DEFAULT_TIMELINE = new DefaultTimeline();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/macrofocus/plot/guide/DateAxis$Companion;", "", "<init>", "()V", "DEFAULT_DATE_RANGE", "Lcom/macrofocus/plot/guide/DateRange;", "DEFAULT_DATE_TICK_UNIT", "Lcom/macrofocus/plot/guide/DateTickUnit;", "DEFAULT_TIMELINE", "Lcom/macrofocus/plot/guide/Timeline;", "createStandardDateTickUnits", "Lcom/macrofocus/plot/guide/TickUnitSource;", "zone", "Lcom/macrofocus/common/date/CPTimeZone;", "locale", "Lcom/macrofocus/common/locale/CPLocale;", "formatFactory", "Lcom/macrofocus/common/format/FormatFactory;", "calculateDateForPosition", "Lkotlinx/datetime/Instant;", "period", "Lcom/macrofocus/plot/guide/RegularTimePeriod;", "position", "Lcom/macrofocus/plot/guide/DateAxis$DateTickMarkPosition;", "macrofocus-slider"})
    public static final class Companion {
        private Companion() {
        }

        private final TickUnitSource createStandardDateTickUnits(CPTimeZone zone, CPLocale locale, FormatFactory formatFactory) {
            TickUnits units = new TickUnits(formatFactory);
            CPFormat f1 = new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(Companion::createStandardDateTickUnits$lambda$0));
            CPFormat f2 = new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(Companion::createStandardDateTickUnits$lambda$1));
            CPFormat f3 = new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(Companion::createStandardDateTickUnits$lambda$2));
            CPFormat f4 = new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(Companion::createStandardDateTickUnits$lambda$3));
            CPFormat f5 = new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(Companion::createStandardDateTickUnits$lambda$4));
            CPFormat f6 = new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(Companion::createStandardDateTickUnits$lambda$5));
            CPFormat f7 = new DateTimeFormat((kotlinx.datetime.format.DateTimeFormat<LocalDateTime>)LocalDateTime.Companion.Format(Companion::createStandardDateTickUnits$lambda$6));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), 5, DateTickUnitType.Companion.getMILLISECOND(), 1, (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), 10, DateTickUnitType.Companion.getMILLISECOND(), 1, (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), 25, DateTickUnitType.Companion.getMILLISECOND(), 5, (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), 50, DateTickUnitType.Companion.getMILLISECOND(), 10, (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), 100, DateTickUnitType.Companion.getMILLISECOND(), 10, (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), 250, DateTickUnitType.Companion.getMILLISECOND(), 10, (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMILLISECOND(), 500, DateTickUnitType.Companion.getMILLISECOND(), 50, (CPFormat<Object>)f1));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getSECOND(), 1, DateTickUnitType.Companion.getMILLISECOND(), 50, (CPFormat<Object>)f2));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getSECOND(), 5, DateTickUnitType.Companion.getSECOND(), 1, (CPFormat<Object>)f2));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getSECOND(), 10, DateTickUnitType.Companion.getSECOND(), 1, (CPFormat<Object>)f2));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getSECOND(), 30, DateTickUnitType.Companion.getSECOND(), 5, (CPFormat<Object>)f2));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMINUTE(), 1, DateTickUnitType.Companion.getSECOND(), 5, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMINUTE(), 2, DateTickUnitType.Companion.getSECOND(), 10, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMINUTE(), 5, DateTickUnitType.Companion.getMINUTE(), 1, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMINUTE(), 10, DateTickUnitType.Companion.getMINUTE(), 1, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMINUTE(), 15, DateTickUnitType.Companion.getMINUTE(), 5, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMINUTE(), 20, DateTickUnitType.Companion.getMINUTE(), 5, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMINUTE(), 30, DateTickUnitType.Companion.getMINUTE(), 5, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getHOUR(), 1, DateTickUnitType.Companion.getMINUTE(), 5, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getHOUR(), 2, DateTickUnitType.Companion.getMINUTE(), 10, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getHOUR(), 4, DateTickUnitType.Companion.getMINUTE(), 30, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getHOUR(), 6, DateTickUnitType.Companion.getHOUR(), 1, (CPFormat<Object>)f3));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getHOUR(), 12, DateTickUnitType.Companion.getHOUR(), 1, (CPFormat<Object>)f4));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getDAY(), 1, DateTickUnitType.Companion.getHOUR(), 1, (CPFormat<Object>)f5));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getDAY(), 2, DateTickUnitType.Companion.getHOUR(), 1, (CPFormat<Object>)f5));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getDAY(), 7, DateTickUnitType.Companion.getDAY(), 1, (CPFormat<Object>)f5));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getDAY(), 15, DateTickUnitType.Companion.getDAY(), 1, (CPFormat<Object>)f5));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMONTH(), 1, DateTickUnitType.Companion.getDAY(), 1, (CPFormat<Object>)f6));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMONTH(), 2, DateTickUnitType.Companion.getDAY(), 1, (CPFormat<Object>)f6));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMONTH(), 3, DateTickUnitType.Companion.getMONTH(), 1, (CPFormat<Object>)f6));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMONTH(), 4, DateTickUnitType.Companion.getMONTH(), 1, (CPFormat<Object>)f6));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getMONTH(), 6, DateTickUnitType.Companion.getMONTH(), 1, (CPFormat<Object>)f6));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getYEAR(), 1, DateTickUnitType.Companion.getMONTH(), 1, (CPFormat<Object>)f7));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getYEAR(), 2, DateTickUnitType.Companion.getMONTH(), 3, (CPFormat<Object>)f7));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getYEAR(), 5, DateTickUnitType.Companion.getYEAR(), 1, (CPFormat<Object>)f7));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getYEAR(), 10, DateTickUnitType.Companion.getYEAR(), 1, (CPFormat<Object>)f7));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getYEAR(), 25, DateTickUnitType.Companion.getYEAR(), 5, (CPFormat<Object>)f7));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getYEAR(), 50, DateTickUnitType.Companion.getYEAR(), 10, (CPFormat<Object>)f7));
            units.add(new DateTickUnit(DateTickUnitType.Companion.getYEAR(), 100, DateTickUnitType.Companion.getYEAR(), 20, (CPFormat<Object>)f7));
            return units;
        }

        private final Instant calculateDateForPosition(RegularTimePeriod period, DateTickMarkPosition position) {
            if (!(position != null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Instant result = null;
            if (position == DateTickMarkPosition.Start) {
                RegularTimePeriod regularTimePeriod = period;
                Intrinsics.checkNotNull((Object)regularTimePeriod);
                result = Instant.Companion.fromEpochMilliseconds(regularTimePeriod.getFirstMillisecond());
            } else if (position == DateTickMarkPosition.Middle) {
                RegularTimePeriod regularTimePeriod = period;
                Intrinsics.checkNotNull((Object)regularTimePeriod);
                result = Instant.Companion.fromEpochMilliseconds(regularTimePeriod.getMiddleMillisecond());
            } else if (position == DateTickMarkPosition.End) {
                RegularTimePeriod regularTimePeriod = period;
                Intrinsics.checkNotNull((Object)regularTimePeriod);
                result = Instant.Companion.fromEpochMilliseconds(regularTimePeriod.getLastMillisecond());
            }
            return result;
        }

        private static final Unit createStandardDateTickUnits$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            DateTimeFormatBuilder.WithTime.DefaultImpls.hour$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
            DateTimeFormatBuilder.WithTime.DefaultImpls.minute$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
            DateTimeFormatBuilder.WithTime.DefaultImpls.second$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'.');
            $this$Format.secondFraction(3);
            return Unit.INSTANCE;
        }

        private static final Unit createStandardDateTickUnits$lambda$1(DateTimeFormatBuilder.WithDateTime $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            DateTimeFormatBuilder.WithTime.DefaultImpls.hour$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
            DateTimeFormatBuilder.WithTime.DefaultImpls.minute$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
            DateTimeFormatBuilder.WithTime.DefaultImpls.second$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createStandardDateTickUnits$lambda$2(DateTimeFormatBuilder.WithDateTime $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            DateTimeFormatBuilder.WithTime.DefaultImpls.hour$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
            DateTimeFormatBuilder.WithTime.DefaultImpls.minute$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createStandardDateTickUnits$lambda$3(DateTimeFormatBuilder.WithDateTime $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            $this$Format.dayOfMonth(Padding.NONE);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'-');
            $this$Format.monthName(MonthNames.Companion.getENGLISH_ABBREVIATED());
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)',');
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)' ');
            DateTimeFormatBuilder.WithTime.DefaultImpls.hour$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
            DateTimeFormatBuilder.WithTime.DefaultImpls.minute$default((DateTimeFormatBuilder.WithTime)((DateTimeFormatBuilder.WithTime)$this$Format), null, (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createStandardDateTickUnits$lambda$4(DateTimeFormatBuilder.WithDateTime $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            $this$Format.dayOfMonth(Padding.NONE);
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'-');
            $this$Format.monthName(MonthNames.Companion.getENGLISH_ABBREVIATED());
            return Unit.INSTANCE;
        }

        private static final Unit createStandardDateTickUnits$lambda$5(DateTimeFormatBuilder.WithDateTime $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            $this$Format.monthName(MonthNames.Companion.getENGLISH_ABBREVIATED());
            DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'-');
            DateTimeFormatBuilder.WithDate.DefaultImpls.year$default((DateTimeFormatBuilder.WithDate)((DateTimeFormatBuilder.WithDate)$this$Format), null, (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createStandardDateTickUnits$lambda$6(DateTimeFormatBuilder.WithDateTime $this$Format) {
            Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
            DateTimeFormatBuilder.WithDate.DefaultImpls.year$default((DateTimeFormatBuilder.WithDate)((DateTimeFormatBuilder.WithDate)$this$Format), null, (int)1, null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/macrofocus/plot/guide/DateAxis$DateTickMarkPosition;", "", "<init>", "(Ljava/lang/String;I)V", "Start", "Middle", "End", "macrofocus-slider"})
    public static final class DateTickMarkPosition
    extends Enum<DateTickMarkPosition> {
        public static final /* enum */ DateTickMarkPosition Start = new DateTickMarkPosition();
        public static final /* enum */ DateTickMarkPosition Middle = new DateTickMarkPosition();
        public static final /* enum */ DateTickMarkPosition End = new DateTickMarkPosition();
        private static final /* synthetic */ DateTickMarkPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DateTickMarkPosition[] values() {
            return (DateTickMarkPosition[])$VALUES.clone();
        }

        public static DateTickMarkPosition valueOf(String value) {
            return Enum.valueOf(DateTickMarkPosition.class, value);
        }

        @NotNull
        public static EnumEntries<DateTickMarkPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dateTickMarkPositionArray = new DateTickMarkPosition[]{DateTickMarkPosition.Start, DateTickMarkPosition.Middle, DateTickMarkPosition.End};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/macrofocus/plot/guide/DateAxis$DefaultTimeline;", "Lcom/macrofocus/plot/guide/Timeline;", "<init>", "()V", "toTimelineValue", "", "millisecond", "containsDomainValue", "", "macrofocus-slider"})
    private static final class DefaultTimeline
    implements Timeline {
        @Override
        public long toTimelineValue(long millisecond) {
            return millisecond;
        }

        @Override
        public boolean containsDomainValue() {
            return true;
        }
    }
}

