/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.plot.guide.Range;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0002\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/macrofocus/plot/guide/DateRange;", "Lcom/macrofocus/plot/guide/Range;", "<init>", "()V", "lower", "Lkotlinx/datetime/Instant;", "upper", "(Lkotlinx/datetime/Instant;Lkotlinx/datetime/Instant;)V", "other", "(Lcom/macrofocus/plot/guide/Range;)V", "", "(DD)V", "lowerMillis", "", "getLowerMillis", "()J", "upperMillis", "getUpperMillis", "getLowerDate", "getUpperDate", "macrofocus-slider"})
@StabilityInferred(parameters=1)
public final class DateRange
extends Range {
    private final long lowerMillis;
    private final long upperMillis;
    public static final int $stable;

    public final long getLowerMillis() {
        return this.lowerMillis;
    }

    public final long getUpperMillis() {
        return this.upperMillis;
    }

    public DateRange() {
        this(TimeZoneKt.toInstant((LocalDateTime)new LocalDateTime(2024, 1, 1, 0, 0, 0, 0, 96, null), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds(), TimeZoneKt.toInstant((LocalDateTime)new LocalDateTime(2025, 1, 1, 0, 0, 0, 0, 96, null), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).toEpochMilliseconds());
    }

    private DateRange(Instant lower, Instant upper) {
        super(lower.toEpochMilliseconds(), upper.toEpochMilliseconds());
        this.lowerMillis = lower.toEpochMilliseconds();
        this.upperMillis = upper.toEpochMilliseconds();
    }

    public DateRange(@NotNull Range other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this(other.getLowerBound(), other.getUpperBound());
    }

    public DateRange(double lower, double upper) {
        super(lower, upper);
        this.lowerMillis = (long)lower;
        this.upperMillis = (long)upper;
    }

    @NotNull
    public final Instant getLowerDate() {
        return Instant.Companion.fromEpochMilliseconds(this.lowerMillis);
    }

    @NotNull
    public final Instant getUpperDate() {
        return Instant.Companion.fromEpochMilliseconds(this.upperMillis);
    }
}

