/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.date.CPTimeZone;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.plot.datetime.CPCalendar;
import com.macrofocus.plot.guide.DateTickUnitType;
import com.macrofocus.plot.guide.TickUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010!J\u001a\u0010\"\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u00020\u00058GX\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/macrofocus/plot/guide/DateTickUnit;", "Lcom/macrofocus/plot/guide/TickUnit;", "unitType", "Lcom/macrofocus/plot/guide/DateTickUnitType;", "multiple", "", "rollUnitType", "rollMultiple", "formatter", "Lcom/macrofocus/common/format/CPFormat;", "", "<init>", "(Lcom/macrofocus/plot/guide/DateTickUnitType;ILcom/macrofocus/plot/guide/DateTickUnitType;ILcom/macrofocus/common/format/CPFormat;)V", "(Lcom/macrofocus/plot/guide/DateTickUnitType;Lcom/macrofocus/common/format/CPFormat;)V", "count", "getCount", "()I", "getMultiple", "rollCount", "unit", "getUnit$annotations", "()V", "getUnit", "valueToString", "", "milliseconds", "", "dateToString", "date", "Lkotlinx/datetime/Instant;", "addToDate", "base", "zone", "Lcom/macrofocus/common/date/CPTimeZone;", "rollDate", "calendarField", "getCalendarField", "Companion", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class DateTickUnit
extends TickUnit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DateTickUnitType unitType;
    private final int multiple;
    @NotNull
    private final DateTickUnitType rollUnitType;
    private final int rollCount;
    @Nullable
    private final CPFormat<Object> formatter;
    private final int unit;
    public static final int $stable = 8;
    private static final int YEAR;
    private static final int MONTH;
    private static final int DAY;
    private static final int HOUR;
    private static final int MINUTE;
    private static final int SECOND;
    private static final int MILLISECOND;

    public DateTickUnit(@NotNull DateTickUnitType unitType, int multiple, @NotNull DateTickUnitType rollUnitType, int rollMultiple, @Nullable CPFormat<Object> formatter) {
        Intrinsics.checkNotNullParameter((Object)unitType, (String)"unitType");
        Intrinsics.checkNotNullParameter((Object)rollUnitType, (String)"rollUnitType");
        super(DateTickUnit.Companion.getMillisecondCount(unitType, multiple));
        if (!(formatter != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(multiple > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(rollMultiple > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.unitType = unitType;
        this.multiple = multiple;
        this.rollUnitType = rollUnitType;
        this.rollCount = rollMultiple;
        this.formatter = formatter;
        this.unit = DateTickUnit.Companion.unitTypeToInt(unitType);
    }

    public final int getCount() {
        return this.getMultiple();
    }

    @Deprecated(message="Use {@link #getMultiple()}.")
    public final int getMultiple() {
        return this.multiple;
    }

    @Deprecated(message="Use the getUnitType() method.")
    public final int getUnit() {
        return this.unit;
    }

    @Deprecated(message="Use the unitType field.")
    public static /* synthetic */ void getUnit$annotations() {
    }

    public DateTickUnit(@NotNull DateTickUnitType unitType, @Nullable CPFormat<Object> formatter) {
        Intrinsics.checkNotNullParameter((Object)unitType, (String)"unitType");
        this(unitType, 1, unitType, 1, formatter);
    }

    @Override
    @NotNull
    public String valueToString(double milliseconds) {
        CPFormat<Object> cPFormat = this.formatter;
        Intrinsics.checkNotNull(cPFormat);
        String string = cPFormat.format((Object)Instant.Companion.fromEpochMilliseconds((long)milliseconds));
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String dateToString(@Nullable Instant date) {
        CPFormat<Object> cPFormat = this.formatter;
        Intrinsics.checkNotNull(cPFormat);
        String string = cPFormat.format((Object)date);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final Instant addToDate(@Nullable Instant base, @Nullable CPTimeZone zone) {
        CPCalendar calendar = new CPCalendar();
        calendar.setTime(base);
        calendar.add(this.unitType.getCalendarField(), this.getMultiple());
        Instant instant = calendar.getTime();
        Intrinsics.checkNotNull((Object)instant);
        return instant;
    }

    @NotNull
    public final Instant rollDate(@Nullable Instant base, @Nullable CPTimeZone zone) {
        CPCalendar calendar = new CPCalendar();
        calendar.setTime(base);
        calendar.add(this.rollUnitType.getCalendarField(), this.rollCount);
        Instant instant = calendar.getTime();
        Intrinsics.checkNotNull((Object)instant);
        return instant;
    }

    public final int getCalendarField() {
        return this.unitType.getCalendarField();
    }

    static {
        MONTH = 1;
        DAY = 2;
        HOUR = 3;
        MINUTE = 4;
        SECOND = 5;
        MILLISECOND = 6;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0005H\u0002R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\bR\u001c\u0010\u0015\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0003\u001a\u0004\b\u0017\u0010\bR\u001c\u0010\u0018\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0003\u001a\u0004\b\u001a\u0010\b\u00a8\u0006\""}, d2={"Lcom/macrofocus/plot/guide/DateTickUnit$Companion;", "", "<init>", "()V", "YEAR", "", "getYEAR$annotations", "getYEAR", "()I", "MONTH", "getMONTH$annotations", "getMONTH", "DAY", "getDAY$annotations", "getDAY", "HOUR", "getHOUR$annotations", "getHOUR", "MINUTE", "getMINUTE$annotations", "getMINUTE", "SECOND", "getSECOND$annotations", "getSECOND", "MILLISECOND", "getMILLISECOND$annotations", "getMILLISECOND", "unitTypeToInt", "unitType", "Lcom/macrofocus/plot/guide/DateTickUnitType;", "getMillisecondCount", "", "unit", "count", "macrofocus-slider"})
    public static final class Companion {
        private Companion() {
        }

        public final int getYEAR() {
            return YEAR;
        }

        @Deprecated(message="As of version 1.0.13, use {@link DateTickUnitType} instead.")
        public static /* synthetic */ void getYEAR$annotations() {
        }

        public final int getMONTH() {
            return MONTH;
        }

        @Deprecated(message="As of version 1.0.13, use {@link DateTickUnitType} instead.")
        public static /* synthetic */ void getMONTH$annotations() {
        }

        public final int getDAY() {
            return DAY;
        }

        @Deprecated(message="As of version 1.0.13, use {@link DateTickUnitType} instead.")
        public static /* synthetic */ void getDAY$annotations() {
        }

        public final int getHOUR() {
            return HOUR;
        }

        @Deprecated(message="As of version 1.0.13, use {@link DateTickUnitType} instead.")
        public static /* synthetic */ void getHOUR$annotations() {
        }

        public final int getMINUTE() {
            return MINUTE;
        }

        @Deprecated(message="As of version 1.0.13, use {@link DateTickUnitType} instead.")
        public static /* synthetic */ void getMINUTE$annotations() {
        }

        public final int getSECOND() {
            return SECOND;
        }

        @Deprecated(message="As of version 1.0.13, use {@link DateTickUnitType} instead.")
        public static /* synthetic */ void getSECOND$annotations() {
        }

        public final int getMILLISECOND() {
            return MILLISECOND;
        }

        @Deprecated(message="As of version 1.0.13, use {@link DateTickUnitType} instead.")
        public static /* synthetic */ void getMILLISECOND$annotations() {
        }

        private final int unitTypeToInt(DateTickUnitType unitType) {
            if (!(unitType != null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return Intrinsics.areEqual((Object)unitType, (Object)DateTickUnitType.Companion.getYEAR()) ? this.getYEAR() : (Intrinsics.areEqual((Object)unitType, (Object)DateTickUnitType.Companion.getMONTH()) ? this.getMONTH() : (Intrinsics.areEqual((Object)unitType, (Object)DateTickUnitType.Companion.getDAY()) ? this.getDAY() : (Intrinsics.areEqual((Object)unitType, (Object)DateTickUnitType.Companion.getHOUR()) ? this.getHOUR() : (Intrinsics.areEqual((Object)unitType, (Object)DateTickUnitType.Companion.getMINUTE()) ? this.getMINUTE() : (Intrinsics.areEqual((Object)unitType, (Object)DateTickUnitType.Companion.getSECOND()) ? this.getSECOND() : (Intrinsics.areEqual((Object)unitType, (Object)DateTickUnitType.Companion.getMILLISECOND()) ? this.getMILLISECOND() : -1))))));
        }

        private final long getMillisecondCount(DateTickUnitType unit, int count) {
            return Intrinsics.areEqual((Object)unit, (Object)DateTickUnitType.Companion.getYEAR()) ? 31536000000L * (long)count : (Intrinsics.areEqual((Object)unit, (Object)DateTickUnitType.Companion.getMONTH()) ? 2678400000L * (long)count : (Intrinsics.areEqual((Object)unit, (Object)DateTickUnitType.Companion.getDAY()) ? 86400000L * (long)count : (Intrinsics.areEqual((Object)unit, (Object)DateTickUnitType.Companion.getHOUR()) ? 3600000L * (long)count : (Intrinsics.areEqual((Object)unit, (Object)DateTickUnitType.Companion.getMINUTE()) ? 60000L * (long)count : (Intrinsics.areEqual((Object)unit, (Object)DateTickUnitType.Companion.getSECOND()) ? 1000L * (long)count : (Intrinsics.areEqual((Object)unit, (Object)DateTickUnitType.Companion.getMILLISECOND()) ? (long)count : -1L))))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

