/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot

import com.macrofocus.common.format.CPFormat
import com.macrofocus.plot.guide.Guide

abstract class AbstractAxisPlotPanel : AxisPlotPanel {
    protected var xGuide: Guide? = null
    protected var yGuide: Guide? = null
    override var showRightYAxis = false
        set(value) {
            if (field != value) {
                field = value
                valideAxis()
            }
        }
    override var showBottomTimeAxis = true
        set(value) {
            if (field != value) {
                field = value
                valideAxis()
            }
        }
    override var showLeftYAxis = true
        set(value) {
            if (field != value) {
                field = value
                valideAxis()
            }
        }
    override var showTopTimeAxis = false
        set(value) {
            if (field != value) {
                field = value
                valideAxis()
            }
        }

    override fun setXFormat(format: CPFormat<Any?>?) {
        xGuide?.setFormat(format)
    }

    override fun setYFormat(format: CPFormat<Any?>?) {
        yGuide?.setFormat(format)
    }
}