package com.macrofocus.plot

import com.macrofocus.common.geom.Dimension
import com.macrofocus.plot.guide.Guide
import org.mkui.component.CPComponent
import org.mkui.component.CPFactory
import org.mkui.component.absolute.AbsoluteCPContainer
import org.mkui.component.absolute.Layout
import org.mkui.component.panel.CPOverlayPanel
import org.mkui.geom.Rectangle
import org.mkui.geom.Rectangle2D

class DefaultAxisPlotPanel : AbstractAxisPlotPanel {
    override lateinit var panel: AbsoluteCPContainer

    override val component: CPComponent
        get() = panel

    override lateinit var snapshotPanel: AbsoluteCPContainer
    override var mainContainer: CPOverlayPanel = CPFactory.instance.createOverlayPanel()
    override var rightYAxisContainer: CPOverlayPanel = CPFactory.instance.createOverlayPanel()
    override var bottomTimeAxisContainer: CPOverlayPanel = CPFactory.instance.createOverlayPanel()
    override var leftYAxisContainer: CPOverlayPanel = CPFactory.instance.createOverlayPanel()
    override var topTimeAxisContainer: CPOverlayPanel = CPFactory.instance.createOverlayPanel()

    constructor(
        xGuide: Guide?,
        yGuide: Guide?,
        plot: CPComponent?
    ) {
        snapshotPanel = AbsoluteCPContainer(object : Layout {
            override fun layout(container: AbsoluteCPContainer, width: Double, height: Double) {
                val x1: Double = getLeftAxisPreferredSize().width
                val x2: Double = width - getRightAxisPreferredSize().width

                val y1: Double = getTopAxisPreferredSize().height
                val y2: Double = height - getBottomAxisPreferredSize().height

                // This are inside the snapshot panel
                container.setBounds(leftYAxisContainer, Rectangle2D.Double(0.0, 0.0, x1, y2 - y1))
                container.setBounds(
                    bottomTimeAxisContainer,
                    Rectangle2D.Double(x1, height - y1 - (height - y2), x2 - x1, height - y2)
                )
                container.setBounds(mainContainer, Rectangle2D.Double(x1, 0.0, x2 - x1, y2 - y1))
            }
        })
        snapshotPanel.addComponent(mainContainer)
        snapshotPanel.addComponent(leftYAxisContainer)
        snapshotPanel.addComponent(bottomTimeAxisContainer)

        panel = AbsoluteCPContainer(object : Layout {
            override fun layout(container: AbsoluteCPContainer, width: Double, height: Double) {
                val x1: Double = getLeftAxisPreferredSize().width
                val x2: Double = width - getRightAxisPreferredSize().width

                val y1: Double = getTopAxisPreferredSize().height
                val y2: Double = height - getBottomAxisPreferredSize().height
                container.setBounds(snapshotPanel, Rectangle2D.Double(0.0, y1, x2, height - y1))

                container.setBounds(topTimeAxisContainer, Rectangle2D.Double(x1, 0.0, x2 - x1, y1))
                container.setBounds(rightYAxisContainer, Rectangle2D.Double(x2, y1, width - x2, y2 - y1))
            }
        })
        panel.addComponent(snapshotPanel)
        panel.addComponent(topTimeAxisContainer)
        panel.addComponent(rightYAxisContainer)

        // Paramters handling
        this.xGuide = xGuide
        this.yGuide = yGuide

        if (xGuide != null) {
            addBottomTimeAxisComponent(xGuide.component)
        }
        if (yGuide != null) {
            addLeftYAxisComponent(yGuide.component)
        }
        if (plot != null) {
            addComponent(plot)
        }

//        if (id != null) {
//            val panel: ResizeLayoutPanel = ResizeLayoutPanel()
//            panel.setSize("100%", "100%")
//            panel.setWidget(getNativeComponent())
//
//            RootPanel.get(id).add(panel)
//
//            //        if(url != null) {
//            //            loadJsonUrl(url);
//            //        }
//        }
    }

    fun getTopAxisPreferredSize(): Dimension {
//        if (showTopTimeAxis) {
//            return getTopTimeAxisContainer().getPreferredSize();
//        } else {
        return Dimension(0, 0)
//        }
    }

    fun getBottomAxisPreferredSize(): Dimension {
        if (showBottomTimeAxis && xGuide != null) {
            val dataArea: Rectangle =
                Rectangle(0, 0, panel.width.toInt(), panel.height.toInt())
            //            final Graphics2D g2 = (Graphics2D) getNativeComponent().getGraphics();
            val space = xGuide!!.computeSpace(xGuide!!.graphics!!, dataArea)
            return Dimension(panel.width.toInt(), space.toInt())
        } else {
            return Dimension(0, 0)
        }
    }

    fun getLeftAxisPreferredSize(): Dimension {
        if (showLeftYAxis && yGuide != null) {
            val dataArea: Rectangle =
                Rectangle(0, 0, panel.width.toInt(), panel.height.toInt())
            //            final Graphics2D g2 = (Graphics2D) getNativeComponent().getGraphics();
            val space = yGuide!!.computeSpace(yGuide!!.graphics!!, dataArea)
            return Dimension(space.toInt(), panel.height.toInt())
        } else {
            return Dimension(0, 0)
        }
    }

    fun getRightAxisPreferredSize(): Dimension {
//        if (showRightYAxis) {
//            return getRightYAxisContainer().getPreferredSize();
//        } else {
        return Dimension(0, 0)
//        }
    }

    override fun valideAxis() {
        val topAxisVisible = showTopTimeAxis
        val bottomAxisVisible = showBottomTimeAxis && xGuide != null
        val leftAxisVisible = showLeftYAxis && yGuide != null

        setTopAxisVisible(topAxisVisible)
        setBottomAxisVisible(bottomAxisVisible)
        setLeftAxisVisible(leftAxisVisible)
        val topAxisPreferredSize: Dimension = if (topAxisVisible) {
            getTopAxisPreferredSize()
        } else {
            Dimension(0, 0)
        }
        val bottomAxisPreferredSize: Dimension = if (bottomAxisVisible) {
            getBottomAxisPreferredSize()
        } else {
            Dimension(0, 0)
        }
        val leftAxisPreferredSize: Dimension = if (leftAxisVisible) {
            getLeftAxisPreferredSize()
        } else {
            Dimension(0, 0)
        }

        //        setTopAxisSize(topAxisPreferredSize);
        setBottomAxisSize(bottomAxisPreferredSize)
        setLeftAxisSize(leftAxisPreferredSize)

//        if(getNativeComponent().isPaintingForPrint()) {
//            getNativeComponent().doLayout();
//        } else {
//            SwingUtilities.invokeLater(new Runnable() {
//                @Override
//                public void run() {
//                    getNativeComponent().validate();
//                }
//            });
//        }
    }

    override fun addComponent(component: CPComponent) {
        if (mainContainer != null) {
            mainContainer.set(component)
        }
    }

    override fun addBottomTimeAxisComponent(component: CPComponent) {
        if (bottomTimeAxisContainer != null) {
            bottomTimeAxisContainer.set(component)
            valideAxis()
        }
    }

    override fun addTopTimeAxisComponent(component: CPComponent) {
        if (topTimeAxisContainer != null) {
            topTimeAxisContainer.set(component)
            valideAxis()
        }
    }

    override fun addLeftYAxisComponent(component: CPComponent) {
        if (leftYAxisContainer != null) {
            leftYAxisContainer.set(component)
            valideAxis()
        }
    }

    override fun addRightYAxisComponent(component: CPComponent) {
        if (rightYAxisContainer != null) {
            rightYAxisContainer.set(component)
            valideAxis()
        }
    }

    override fun setLeftAxisSize(d: Dimension?) {
    }

    override fun setTopAxisSize(d: Dimension?) {
    }

    override fun setBottomAxisSize(d: Dimension?) {
    }

    override fun setLeftAxisVisible(visible: Boolean) {
//        if (leftYAxisContainer.isVisible() !== visible) {
//            leftYAxisContainer.setVisible(visible)
//        }
    }

    override fun setRightAxisVisible(visible: Boolean) {
//        if (rightYAxisContainer.isVisible() !== visible) {
//            rightYAxisContainer.setVisible(visible)
//        }
    }

    override fun setTopAxisVisible(visible: Boolean) {
//        if (topTimeAxisContainer.isVisible() !== visible) {
//            topTimeAxisContainer.setVisible(visible)
//        }
    }

    override fun setBottomAxisVisible(visible: Boolean) {
//        if (bottomTimeAxisContainer.isVisible() !== visible) {
//            bottomTimeAxisContainer.setVisible(visible)
//        }
    }
}