/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot.guide

abstract class AbstractGuide : Guide {
    private val listeners: MutableList<Guide.Listener> = ArrayList<Guide.Listener>()
    protected var gridRenderer: GridRenderer = DefaultGridRenderer()
    protected var gridLineRenderer: GridLineRenderer = DefaultGridLineRenderer()
        set(value) {
            field = value
            repaint()
        }
    override fun addListener(listener: Guide.Listener) {
        listeners.add(listener)
    }

    protected fun notifyGuideChanged() {
        for (listener in listeners) {
            listener.guideChanged()
        }
    }
}