@file:OptIn(ExperimentalTime::class)

package com.macrofocus.plot.guide

import com.macrofocus.common.format.CPFormat
import kotlin.time.Instant
import kotlinx.datetime.LocalDateTime
import kotlinx.datetime.TimeZone
import kotlinx.datetime.format.DateTimeFormat
import kotlinx.datetime.toLocalDateTime
import kotlin.time.ExperimentalTime

class DateTimeFormat(private val format: DateTimeFormat<LocalDateTime>) : CPFormat<Any?> {
    override fun format(value: Any?): String? {
        return formatHtml(value, false)
    }

    override fun formatHtml(value: Any?, htmlSupported: Boolean): String? {
        return if (value != null) {
            val date: Instant
            date = if (value is Number) {
                Instant.fromEpochMilliseconds(value.toLong())
            } else if (value is Instant) {
                value
            } else {
                return value.toString()
            }
            val dateTime = date.toLocalDateTime(TimeZone.UTC)
            format.format(dateTime)
        } else {
            ""
        }
    }

    @Throws(CPFormat.ParsingException::class)
    override fun parse(text: String?): Any? {
        return try {
            format.parse(text!!)
        } catch (e: IllegalArgumentException) {
            throw CPFormat.ParsingException(e.message, -1)
        }
    }

    override val pattern: String?
        get() = null
    override val nativeFormat: Any?
        get() = null
    override val horizontalAlignment: CPFormat.HorizontalAlignment?
        get() = null

    override fun getClassName(value: Any?): String? {
        return null
    }
}