/*
 * Copyright (c) 2005 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.slider
class RangeSliderEvent(
    rangeSliderModel: RangeSliderModel, source: Any, rangeMin: Double, rangeMax: Double,
    previousRangeMin: Double, previousRangeMax: Double
) {
    val sliderModel: RangeSliderModel
        get() = rangeSliderModel

    override fun toString(): String {
        return this::class.simpleName + "[sliderModel=" + rangeSliderModel + ",source=" + source + ",rangeMin=" + rangeMinimum + ",rangeMax=" + rangeMaximum + "]"
    }

    val rangeMinimum: Double
    val rangeMaximum: Double
    val previousRangeMinimum: Double
    val previousRangeMaximum: Double
    private val rangeSliderModel: com.macrofocus.slider.RangeSliderModel
    val source: Any

    init {
        this.rangeSliderModel = rangeSliderModel
        this.source = source
        rangeMinimum = rangeMin
        rangeMaximum = rangeMax
        previousRangeMinimum = previousRangeMin
        previousRangeMaximum = previousRangeMax
    }
}