@file:OptIn(ExperimentalTime::class)

package com.macrofocus.plot.datetime

import kotlin.time.Instant
import java.util.*
import kotlin.time.ExperimentalTime

actual class CPCalendar(private val calendar: Calendar) {
    actual constructor() : this(GregorianCalendar())

    actual fun get(field: Int): Int {
        return calendar[field]
    }

    actual fun setAll(years: Int, months: Int, days: Int, hours: Int, minutes: Int, seconds: Int) {
        calendar[years, months, days, hours, minutes] = seconds
    }

    actual var time: Instant?
        get() = Instant.fromEpochMilliseconds(calendar.time.time)
        set(date) {
            calendar.time = Date(date!!.toEpochMilliseconds())
        }

    actual fun set(field: Int, i: Int) {
        calendar[field] = i
    }

    actual fun clear(field: Int) {
        calendar.clear(field)
    }

    actual fun add(field: Int, multiple: Int) {
        calendar.add(field, multiple)
    }

    actual companion object {
        /**
         * Field number for `get` and `set` indicating the
         * year. This is a calendar-specific value; see subclass documentation.
         */
        actual const val YEAR: Int = 1

        /**
         * Field number for `get` and `set` indicating the
         * month. This is a calendar-specific value. The first month of
         * the year in the Gregorian and Julian calendars is
         * `JANUARY` which is 0; the last depends on the number
         * of months in a year.
         */
        actual const val MONTH: Int = 2

        /**
         * Field number for `get` and `set` indicating the
         * day of the month. This is a synonym for `DAY_OF_MONTH`.
         * The first day of the month has value 1.
         */
        actual const val DATE: Int = 5

        /**
         * Field number for `get` and `set` indicating the
         * hour of the day. `HOUR_OF_DAY` is used for the 24-hour clock.
         * E.g., at 10:04:15.250 PM the `HOUR_OF_DAY` is 22.
         */
        actual const val HOUR_OF_DAY: Int = 11

        /**
         * Field number for `get` and `set` indicating the
         * minute within the hour.
         * E.g., at 10:04:15.250 PM the `MINUTE` is 4.
         */
        actual const val MINUTE: Int = 12

        /**
         * Field number for `get` and `set` indicating the
         * second within the minute.
         * E.g., at 10:04:15.250 PM the `SECOND` is 15.
         */
        actual const val SECOND: Int = 13

        /**
         * Field number for `get` and `set` indicating the
         * millisecond within the second.
         * E.g., at 10:04:15.250 PM the `MILLISECOND` is 250.
         */
        actual const val MILLISECOND: Int = 14

        /**
         * Value of the [.MONTH] field indicating the
         * first month of the year in the Gregorian and Julian calendars.
         */
        actual const val JANUARY: Int = 0

        /**
         * Value of the [.MONTH] field indicating the
         * second month of the year in the Gregorian and Julian calendars.
         */
        actual const val FEBRUARY: Int = 1

        /**
         * Value of the [.MONTH] field indicating the
         * third month of the year in the Gregorian and Julian calendars.
         */
        actual const val MARCH: Int = 2

        /**
         * Value of the [.MONTH] field indicating the
         * fourth month of the year in the Gregorian and Julian calendars.
         */
        actual const val APRIL: Int = 3

        /**
         * Value of the [.MONTH] field indicating the
         * fifth month of the year in the Gregorian and Julian calendars.
         */
        actual const val MAY: Int = 4

        /**
         * Value of the [.MONTH] field indicating the
         * sixth month of the year in the Gregorian and Julian calendars.
         */
        actual const val JUNE: Int = 5

        /**
         * Value of the [.MONTH] field indicating the
         * seventh month of the year in the Gregorian and Julian calendars.
         */
        actual const val JULY: Int = 6

        /**
         * Value of the [.MONTH] field indicating the
         * eighth month of the year in the Gregorian and Julian calendars.
         */
        actual const val AUGUST: Int = 7

        /**
         * Value of the [.MONTH] field indicating the
         * ninth month of the year in the Gregorian and Julian calendars.
         */
        actual const val SEPTEMBER: Int = 8

        /**
         * Value of the [.MONTH] field indicating the
         * tenth month of the year in the Gregorian and Julian calendars.
         */
        actual const val OCTOBER: Int = 9

        /**
         * Value of the [.MONTH] field indicating the
         * eleventh month of the year in the Gregorian and Julian calendars.
         */
        actual const val NOVEMBER: Int = 10

        /**
         * Value of the [.MONTH] field indicating the
         * twelfth month of the year in the Gregorian and Julian calendars.
         */
        actual const val DECEMBER: Int = 11
    }
}