/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.date.CPTimeZone;
import com.macrofocus.common.locale.CPLocale;
import com.macrofocus.plot.datetime.CPCalendar;
import com.macrofocus.plot.guide.RegularTimePeriod;
import com.macrofocus.plot.guide.SerialDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B'\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0005\u0010\rJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0013\u0010!\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010 H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/macrofocus/plot/guide/Month;", "Lcom/macrofocus/plot/guide/RegularTimePeriod;", "month", "", "year", "<init>", "(II)V", "time", "Lkotlin/time/Instant;", "zone", "Lcom/macrofocus/common/date/CPTimeZone;", "locale", "Lcom/macrofocus/common/locale/CPLocale;", "(Lkotlin/time/Instant;Lcom/macrofocus/common/date/CPTimeZone;Lcom/macrofocus/common/locale/CPLocale;)V", "value", "", "firstMillisecond", "getFirstMillisecond", "()J", "lastMillisecond", "getLastMillisecond", "peg", "", "calendar", "Lcom/macrofocus/plot/datetime/CPCalendar;", "toString", "", "previous", "hashCode", "equals", "", "obj", "", "compareTo", "o1", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class Month
extends RegularTimePeriod {
    private final int month;
    private final int year;
    private long firstMillisecond;
    private long lastMillisecond;
    public static final int $stable = 8;

    @Override
    public long getFirstMillisecond() {
        return this.firstMillisecond;
    }

    @Override
    public long getLastMillisecond() {
        return this.lastMillisecond;
    }

    private Month(int month, int year) {
        if (!(month >= 1 && month <= 12)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.month = month;
        this.year = year;
        this.peg(new CPCalendar());
    }

    public Month(@Nullable Instant time, @Nullable CPTimeZone zone, @Nullable CPLocale locale) {
        CPCalendar calendar = new CPCalendar();
        calendar.setTime(time);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
        this.peg(calendar);
    }

    public final void peg(@NotNull CPCalendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        this.firstMillisecond = this.getFirstMillisecond(calendar);
        this.lastMillisecond = this.getLastMillisecond(calendar);
    }

    private final long getLastMillisecond(CPCalendar calendar) {
        int eom = SerialDate.INSTANCE.lastDayOfMonth(this.month, this.year);
        System.out.println((Object)("getLastMillisecond " + this.year + " " + this.month + " " + eom));
        calendar.setAll(this.year, this.month - 1, eom, 23, 59, 59);
        calendar.set(14, 999);
        Instant instant = calendar.getTime();
        Intrinsics.checkNotNull((Object)instant);
        return instant.toEpochMilliseconds();
    }

    private final long getFirstMillisecond(CPCalendar calendar) {
        calendar.setAll(this.year, this.month - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        Instant instant = calendar.getTime();
        Intrinsics.checkNotNull((Object)instant);
        return instant.toEpochMilliseconds();
    }

    @Override
    @NotNull
    public String toString() {
        return SerialDate.INSTANCE.monthCodeToString(this.month) + " " + this.year;
    }

    @Nullable
    public final RegularTimePeriod previous() {
        Month result = null;
        result = this.month == 1 ? (this.year > 1900 ? new Month(12, this.year - 1) : null) : new Month(this.month - 1, this.year);
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.month;
        result = 37 * result + this.year;
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Month)) {
            return false;
        }
        Object that = obj;
        return this.month != ((Month)that).month ? false : this.year == ((Month)that).year;
    }

    @Override
    public int compareTo(@Nullable Object o1) {
        int result = 0;
        if (o1 instanceof Month) {
            Object m = o1;
            result = this.year - ((Month)m).year;
            if (result == 0) {
                result = this.month - ((Month)m).month;
            }
        } else {
            result = o1 instanceof RegularTimePeriod ? 0 : 1;
        }
        return result;
    }
}

