/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactory;
import com.macrofocus.plot.guide.NumberTick;
import com.macrofocus.plot.guide.NumberTickUnit;
import com.macrofocus.plot.guide.Range;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.RectangleInsets;
import com.macrofocus.plot.guide.Tick;
import com.macrofocus.plot.guide.TickUnit;
import com.macrofocus.plot.guide.TickUnitSource;
import com.macrofocus.plot.guide.TickUnits;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.plot.guide.ValueTick;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontFactory;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.CPHeadless;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\u0012\u001a\u00020\u00102\u0010\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\"H\u0002J \u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010%\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010&\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J&\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J&\u0010+\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/macrofocus/plot/guide/NumberAxis;", "Lcom/macrofocus/plot/guide/ValueAxis;", "fontFactory", "Lorg/mkui/font/CPFontFactory;", "headless", "Lorg/mkui/graphics/IHeadless;", "formatFactory", "Lcom/macrofocus/common/format/FormatFactory;", "<init>", "(Lorg/mkui/font/CPFontFactory;Lorg/mkui/graphics/IHeadless;Lcom/macrofocus/common/format/FormatFactory;)V", "tickUnit", "Lcom/macrofocus/plot/guide/NumberTickUnit;", "numberFormatOverride", "Lcom/macrofocus/common/format/CPFormat;", "", "setTickUnit", "", "unit", "setFormatOverride", "formatter", "valueToJava2D", "", "value", "area", "Lorg/mkui/geom/Rectangle2D;", "edge", "Lcom/macrofocus/plot/guide/RectangleEdge;", "calculateLowestVisibleTickValue", "calculateVisibleTickCount", "", "estimateMaximumTickLabelHeight", "g2", "Lorg/mkui/graphics/IGraphics;", "estimateMaximumTickLabelWidth", "Lcom/macrofocus/plot/guide/TickUnit;", "selectAutoTickUnit", "dataArea", "selectHorizontalAutoTickUnit", "selectVerticalAutoTickUnit", "refreshTicks", "", "Lcom/macrofocus/plot/guide/ValueTick;", "refreshTicksHorizontal", "refreshTicksVertical", "Companion", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class NumberAxis
extends ValueAxis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private NumberTickUnit tickUnit;
    @Nullable
    private CPFormat<Object> numberFormatOverride;
    public static final int $stable = 8;
    @Nullable
    private static NumberTickUnit DEFAULT_TICK_UNIT;

    public NumberAxis(@NotNull CPFontFactory fontFactory, @NotNull IHeadless headless, @NotNull FormatFactory formatFactory) {
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        Intrinsics.checkNotNullParameter((Object)formatFactory, (String)"formatFactory");
        super(fontFactory, headless, null, NumberAxis.Companion.createStandardTickUnits(formatFactory));
        if (DEFAULT_TICK_UNIT == null) {
            DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, (CPFormat<Object>)formatFactory.createNumberFormat("0"));
        }
        this.tickUnit = DEFAULT_TICK_UNIT;
        this.numberFormatOverride = null;
    }

    public /* synthetic */ NumberAxis(CPFontFactory cPFontFactory, IHeadless iHeadless, FormatFactory formatFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            cPFontFactory = CPFontFactory.Companion.getInstance();
        }
        if ((n & 2) != 0) {
            iHeadless = (IHeadless)CPHeadless.INSTANCE;
        }
        if ((n & 4) != 0) {
            formatFactory = FormatFactory.Companion.getInstance();
        }
        this(cPFontFactory, iHeadless, formatFactory);
    }

    private final void setTickUnit(NumberTickUnit unit) {
        this.tickUnit = unit;
    }

    @Override
    public void setFormatOverride(@Nullable CPFormat<Object> formatter) {
        this.numberFormatOverride = formatter;
    }

    @Override
    protected double valueToJava2D(double value, @NotNull Rectangle2D area, @NotNull RectangleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Range range = this.getRange();
        Intrinsics.checkNotNull((Object)range);
        Range range2 = range;
        double axisMin = range2.getLowerBound();
        double axisMax = range2.getUpperBound();
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            max = area.getMinY();
            min = area.getMaxY();
        }
        return this.isInverted() ? max - (value - axisMin) / (axisMax - axisMin) * (max - min) : min + (value - axisMin) / (axisMax - axisMin) * (max - min);
    }

    private final double calculateLowestVisibleTickValue() {
        NumberTickUnit numberTickUnit = this.tickUnit;
        Intrinsics.checkNotNull((Object)numberTickUnit);
        double unit = numberTickUnit.getSize();
        Range range = this.getRange();
        Intrinsics.checkNotNull((Object)range);
        double index = Math.ceil(range.getLowerBound() / unit);
        return index * unit;
    }

    private final int calculateVisibleTickCount() {
        NumberTickUnit numberTickUnit = this.tickUnit;
        Intrinsics.checkNotNull((Object)numberTickUnit);
        double unit = numberTickUnit.getSize();
        Range range = this.getRange();
        Intrinsics.checkNotNull((Object)range);
        Range range2 = range;
        return (int)(Math.floor(range2.getUpperBound() / unit) - Math.ceil(range2.getLowerBound() / unit) + 1.0);
    }

    private final double estimateMaximumTickLabelHeight(IGraphics g2) {
        RectangleInsets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.getTop() + tickLabelInsets.getBottom();
        return result += (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "123");
    }

    private final double estimateMaximumTickLabelWidth(IGraphics g2, TickUnit unit) {
        RectangleInsets tickLabelInsets = this.getTickLabelInsets();
        double result = tickLabelInsets.getLeft() + tickLabelInsets.getRight();
        if (this.isVerticalTickLabels()) {
            result += (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "0");
        } else {
            Range range = this.getRange();
            Intrinsics.checkNotNull((Object)range);
            Range range2 = range;
            double lower = range2.getLowerBound();
            double upper = range2.getUpperBound();
            String lowerStr = null;
            String upperStr = null;
            CPFormat<Object> formatter = this.numberFormatOverride;
            if (formatter != null) {
                String string = formatter.format((Object)lower);
                Intrinsics.checkNotNull((Object)string);
                lowerStr = string;
                String string2 = formatter.format((Object)upper);
                Intrinsics.checkNotNull((Object)string2);
                upperStr = string2;
            } else {
                TickUnit tickUnit = unit;
                Intrinsics.checkNotNull((Object)tickUnit);
                lowerStr = tickUnit.valueToString(lower);
                upperStr = unit.valueToString(upper);
            }
            float w1 = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), lowerStr);
            float w2 = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), upperStr);
            result += (double)Math.max(w1, w2);
        }
        return result;
    }

    private final void selectAutoTickUnit(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            this.selectHorizontalAutoTickUnit(g2, dataArea, edge);
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            this.selectVerticalAutoTickUnit(g2, dataArea, edge);
        }
    }

    private final void selectHorizontalAutoTickUnit(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        double tickLabelWidth = this.estimateMaximumTickLabelWidth(g2, this.tickUnit);
        TickUnitSource tickUnits = this.getStandardTickUnits();
        NumberTickUnit numberTickUnit = this.tickUnit;
        Intrinsics.checkNotNull((Object)numberTickUnit, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.TickUnit");
        TickUnit unit1 = tickUnits.getCeilingTickUnit(numberTickUnit);
        double unit1Width = this.lengthToJava2D(unit1.getSize(), dataArea, edge);
        double guess = tickLabelWidth / unit1Width * unit1.getSize();
        TickUnit tickUnit = tickUnits.getCeilingTickUnit(guess);
        Intrinsics.checkNotNull((Object)tickUnit, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.NumberTickUnit");
        NumberTickUnit unit2 = (NumberTickUnit)tickUnit;
        double unit2Width = this.lengthToJava2D(unit2.getSize(), dataArea, edge);
        tickLabelWidth = this.estimateMaximumTickLabelWidth(g2, unit2);
        if (tickLabelWidth > unit2Width) {
            TickUnit tickUnit2 = tickUnits.getLargerTickUnit(unit2);
            Intrinsics.checkNotNull((Object)tickUnit2, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.NumberTickUnit");
            unit2 = (NumberTickUnit)tickUnit2;
        }
        this.setTickUnit(unit2);
    }

    private final void selectVerticalAutoTickUnit(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        double tickLabelHeight = this.estimateMaximumTickLabelHeight(g2);
        TickUnitSource tickUnits = this.getStandardTickUnits();
        NumberTickUnit numberTickUnit = this.tickUnit;
        Intrinsics.checkNotNull((Object)numberTickUnit, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.NumberTickUnit");
        TickUnit unit1 = tickUnits.getCeilingTickUnit(numberTickUnit);
        double unitHeight = this.lengthToJava2D(unit1.getSize(), dataArea, edge);
        double guess = tickLabelHeight / unitHeight * unit1.getSize();
        TickUnit tickUnit = tickUnits.getCeilingTickUnit(guess);
        Intrinsics.checkNotNull((Object)tickUnit, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.NumberTickUnit");
        NumberTickUnit unit2 = (NumberTickUnit)tickUnit;
        double unit2Height = this.lengthToJava2D(unit2.getSize(), dataArea, edge);
        tickLabelHeight = this.estimateMaximumTickLabelHeight(g2);
        if (tickLabelHeight > unit2Height) {
            TickUnit tickUnit2 = tickUnits.getLargerTickUnit(unit2);
            Intrinsics.checkNotNull((Object)tickUnit2, (String)"null cannot be cast to non-null type com.macrofocus.plot.guide.NumberTickUnit");
            unit2 = (NumberTickUnit)tickUnit2;
        }
        this.setTickUnit(unit2);
    }

    @Override
    @NotNull
    public List<ValueTick> refreshTicks(@NotNull IGraphics g2, @NotNull Rectangle2D dataArea, @NotNull RectangleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)dataArea, (String)"dataArea");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        List<ValueTick> result = new ArrayList();
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            result = this.refreshTicksHorizontal(g2, dataArea, edge);
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            result = this.refreshTicksVertical(g2, dataArea, edge);
        }
        return result;
    }

    private final List<ValueTick> refreshTicksHorizontal(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        List result = new ArrayList();
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, dataArea, edge);
        }
        NumberTickUnit numberTickUnit = this.tickUnit;
        Intrinsics.checkNotNull((Object)numberTickUnit);
        TickUnit tu = numberTickUnit;
        double size = tu.getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        if (count <= 500) {
            int minorTickSpaces = this.getMinorTickCount();
            if (minorTickSpaces <= 0) {
                minorTickSpaces = tu.getMinorTickCount();
            }
            int n = minorTickSpaces;
            for (int minorTick = 1; minorTick < n; ++minorTick) {
                double minorTickValue = lowestTickValue - size * (double)minorTick / (double)minorTickSpaces;
                Range range = this.getRange();
                Intrinsics.checkNotNull((Object)range);
                if (!range.contains(minorTickValue)) continue;
                result.add(new NumberTick(minorTickValue));
            }
            for (int i = 0; i < count; ++i) {
                String string;
                CPFormat<Object> formatter;
                double currentTickValue = lowestTickValue + (double)i * size;
                String tickLabel = null;
                CPFormat<Object> cPFormat = formatter = this.numberFormatOverride;
                if (cPFormat != null) {
                    string = cPFormat.format((Object)currentTickValue);
                } else {
                    NumberTickUnit numberTickUnit2 = this.tickUnit;
                    Intrinsics.checkNotNull((Object)numberTickUnit2);
                    string = numberTickUnit2.valueToString(currentTickValue);
                }
                tickLabel = string;
                Tick.TextAnchor anchor = null;
                Tick.TextAnchor rotationAnchor = null;
                double angle = 0.0;
                if (this.isVerticalTickLabels()) {
                    anchor = Tick.TextAnchor.CenterRight;
                    rotationAnchor = Tick.TextAnchor.CenterRight;
                    angle = edge == RectangleEdge.Top ? 1.5707963267948966 : -1.5707963267948966;
                } else if (edge == RectangleEdge.Top) {
                    anchor = Tick.TextAnchor.BottomCenter;
                    rotationAnchor = Tick.TextAnchor.BottomCenter;
                } else {
                    anchor = Tick.TextAnchor.TopCenter;
                    rotationAnchor = Tick.TextAnchor.TopCenter;
                }
                Number number = currentTickValue;
                String string2 = tickLabel;
                Intrinsics.checkNotNull((Object)string2);
                ValueTick tick = new NumberTick(number, string2, anchor, rotationAnchor, angle);
                result.add(tick);
                double nextTickValue = lowestTickValue + (double)(i + 1) * size;
                int n2 = minorTickSpaces;
                for (int minorTick = 1; minorTick < n2; ++minorTick) {
                    double minorTickValue = currentTickValue + (nextTickValue - currentTickValue) * (double)minorTick / (double)minorTickSpaces;
                    Range range = this.getRange();
                    Intrinsics.checkNotNull((Object)range);
                    if (!range.contains(minorTickValue)) continue;
                    result.add(new NumberTick(minorTickValue));
                }
            }
        }
        return result;
    }

    private final List<ValueTick> refreshTicksVertical(IGraphics g2, Rectangle2D dataArea, RectangleEdge edge) {
        List result = new ArrayList();
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(g2, dataArea, edge);
        }
        NumberTickUnit numberTickUnit = this.tickUnit;
        Intrinsics.checkNotNull((Object)numberTickUnit);
        TickUnit tu = numberTickUnit;
        double size = tu.getSize();
        int count = this.calculateVisibleTickCount();
        double lowestTickValue = this.calculateLowestVisibleTickValue();
        if (count <= 500) {
            int minorTickSpaces = this.getMinorTickCount();
            if (minorTickSpaces <= 0) {
                minorTickSpaces = tu.getMinorTickCount();
            }
            int n = minorTickSpaces;
            for (int minorTick = 1; minorTick < n; ++minorTick) {
                double minorTickValue = lowestTickValue - size * (double)minorTick / (double)minorTickSpaces;
                Range range = this.getRange();
                Intrinsics.checkNotNull((Object)range);
                if (!range.contains(minorTickValue)) continue;
                result.add(new NumberTick(minorTickValue));
            }
            for (int i = 0; i < count; ++i) {
                String string;
                CPFormat<Object> formatter;
                double currentTickValue = lowestTickValue + (double)i * size;
                String tickLabel = null;
                CPFormat<Object> cPFormat = formatter = this.numberFormatOverride;
                if (cPFormat != null) {
                    string = cPFormat.format((Object)currentTickValue);
                } else {
                    NumberTickUnit numberTickUnit2 = this.tickUnit;
                    Intrinsics.checkNotNull((Object)numberTickUnit2);
                    string = numberTickUnit2.valueToString(currentTickValue);
                }
                tickLabel = string;
                Tick.TextAnchor anchor = null;
                Tick.TextAnchor rotationAnchor = null;
                double angle = 0.0;
                if (this.isVerticalTickLabels()) {
                    if (edge == RectangleEdge.Left) {
                        anchor = Tick.TextAnchor.BottomCenter;
                        rotationAnchor = Tick.TextAnchor.BottomCenter;
                        angle = -1.5707963267948966;
                    } else {
                        anchor = Tick.TextAnchor.BottomCenter;
                        rotationAnchor = Tick.TextAnchor.BottomCenter;
                        angle = 1.5707963267948966;
                    }
                } else if (edge == RectangleEdge.Left) {
                    anchor = Tick.TextAnchor.CenterRight;
                    rotationAnchor = Tick.TextAnchor.CenterRight;
                } else {
                    anchor = Tick.TextAnchor.CenterLeft;
                    rotationAnchor = Tick.TextAnchor.CenterLeft;
                }
                Number number = currentTickValue;
                String string2 = tickLabel;
                Intrinsics.checkNotNull((Object)string2);
                ValueTick tick = new NumberTick(number, string2, anchor, rotationAnchor, angle);
                result.add(tick);
                double nextTickValue = lowestTickValue + (double)(i + 1) * size;
                int n2 = minorTickSpaces;
                for (int minorTick = 1; minorTick < n2; ++minorTick) {
                    double minorTickValue = currentTickValue + (nextTickValue - currentTickValue) * (double)minorTick / (double)minorTickSpaces;
                    Range range = this.getRange();
                    Intrinsics.checkNotNull((Object)range);
                    if (!range.contains(minorTickValue)) continue;
                    result.add(new NumberTick(minorTickValue));
                }
            }
        }
        return result;
    }

    public NumberAxis() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/macrofocus/plot/guide/NumberAxis$Companion;", "", "<init>", "()V", "DEFAULT_TICK_UNIT", "Lcom/macrofocus/plot/guide/NumberTickUnit;", "createStandardTickUnits", "Lcom/macrofocus/plot/guide/TickUnitSource;", "formatFactory", "Lcom/macrofocus/common/format/FormatFactory;", "macrofocus-slider"})
    public static final class Companion {
        private Companion() {
        }

        private final TickUnitSource createStandardTickUnits(FormatFactory formatFactory) {
            TickUnits units = new TickUnits(formatFactory);
            CPFormat df000 = formatFactory.createNumberFormat("0.0000000000");
            CPFormat df00 = formatFactory.createNumberFormat("0.000000000");
            CPFormat df0 = formatFactory.createNumberFormat("0.00000000");
            CPFormat df1 = formatFactory.createNumberFormat("0.0000000");
            CPFormat df2 = formatFactory.createNumberFormat("0.000000");
            CPFormat df3 = formatFactory.createNumberFormat("0.00000");
            CPFormat df4 = formatFactory.createNumberFormat("0.0000");
            CPFormat df5 = formatFactory.createNumberFormat("0.000");
            CPFormat df6 = formatFactory.createNumberFormat("0.00");
            CPFormat df7 = formatFactory.createNumberFormat("0.0");
            CPFormat df8 = formatFactory.createNumberFormat("#,##0");
            CPFormat df9 = formatFactory.createNumberFormat("#,###,##0");
            CPFormat df10 = formatFactory.createNumberFormat("#,###,###,##0");
            units.add(new NumberTickUnit(1.0E-9, (CPFormat<Object>)df00, 2));
            units.add(new NumberTickUnit(1.0E-8, (CPFormat<Object>)df0, 2));
            units.add(new NumberTickUnit(1.0E-7, (CPFormat<Object>)df1, 2));
            units.add(new NumberTickUnit(1.0E-6, (CPFormat<Object>)df2, 2));
            units.add(new NumberTickUnit(1.0E-5, (CPFormat<Object>)df3, 2));
            units.add(new NumberTickUnit(1.0E-4, (CPFormat<Object>)df4, 2));
            units.add(new NumberTickUnit(0.001, (CPFormat<Object>)df5, 2));
            units.add(new NumberTickUnit(0.01, (CPFormat<Object>)df6, 2));
            units.add(new NumberTickUnit(0.1, (CPFormat<Object>)df7, 2));
            units.add(new NumberTickUnit(1.0, (CPFormat<Object>)df8, 2));
            units.add(new NumberTickUnit(10.0, (CPFormat<Object>)df8, 2));
            units.add(new NumberTickUnit(100.0, (CPFormat<Object>)df8, 2));
            units.add(new NumberTickUnit(1000.0, (CPFormat<Object>)df8, 2));
            units.add(new NumberTickUnit(10000.0, (CPFormat<Object>)df8, 2));
            units.add(new NumberTickUnit(100000.0, (CPFormat<Object>)df8, 2));
            units.add(new NumberTickUnit(1000000.0, (CPFormat<Object>)df9, 2));
            units.add(new NumberTickUnit(1.0E7, (CPFormat<Object>)df9, 2));
            units.add(new NumberTickUnit(1.0E8, (CPFormat<Object>)df9, 2));
            units.add(new NumberTickUnit(1.0E9, (CPFormat<Object>)df10, 2));
            units.add(new NumberTickUnit(1.0E10, (CPFormat<Object>)df10, 2));
            units.add(new NumberTickUnit(1.0E11, (CPFormat<Object>)df10, 2));
            units.add(new NumberTickUnit(2.5E-9, (CPFormat<Object>)df000, 5));
            units.add(new NumberTickUnit(2.5E-8, (CPFormat<Object>)df00, 5));
            units.add(new NumberTickUnit(2.5E-7, (CPFormat<Object>)df0, 5));
            units.add(new NumberTickUnit(2.5E-6, (CPFormat<Object>)df1, 5));
            units.add(new NumberTickUnit(2.5E-5, (CPFormat<Object>)df2, 5));
            units.add(new NumberTickUnit(2.5E-4, (CPFormat<Object>)df3, 5));
            units.add(new NumberTickUnit(0.0025, (CPFormat<Object>)df4, 5));
            units.add(new NumberTickUnit(0.025, (CPFormat<Object>)df5, 5));
            units.add(new NumberTickUnit(0.25, (CPFormat<Object>)df6, 5));
            units.add(new NumberTickUnit(2.5, (CPFormat<Object>)df7, 5));
            units.add(new NumberTickUnit(25.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(250.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(2500.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(25000.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(250000.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(2500000.0, (CPFormat<Object>)df9, 5));
            units.add(new NumberTickUnit(2.5E7, (CPFormat<Object>)df9, 5));
            units.add(new NumberTickUnit(2.5E8, (CPFormat<Object>)df9, 5));
            units.add(new NumberTickUnit(2.5E9, (CPFormat<Object>)df10, 5));
            units.add(new NumberTickUnit(2.5E10, (CPFormat<Object>)df10, 5));
            units.add(new NumberTickUnit(2.5E11, (CPFormat<Object>)df10, 5));
            units.add(new NumberTickUnit(5.0E-9, (CPFormat<Object>)df00, 5));
            units.add(new NumberTickUnit(5.0E-8, (CPFormat<Object>)df0, 5));
            units.add(new NumberTickUnit(5.0E-7, (CPFormat<Object>)df1, 5));
            units.add(new NumberTickUnit(5.0E-6, (CPFormat<Object>)df2, 5));
            units.add(new NumberTickUnit(5.0E-5, (CPFormat<Object>)df3, 5));
            units.add(new NumberTickUnit(5.0E-4, (CPFormat<Object>)df4, 5));
            units.add(new NumberTickUnit(0.005, (CPFormat<Object>)df5, 5));
            units.add(new NumberTickUnit(0.05, (CPFormat<Object>)df6, 5));
            units.add(new NumberTickUnit(0.5, (CPFormat<Object>)df7, 5));
            units.add(new NumberTickUnit(5.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(50.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(500.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(5000.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(50000.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(500000.0, (CPFormat<Object>)df8, 5));
            units.add(new NumberTickUnit(5000000.0, (CPFormat<Object>)df9, 5));
            units.add(new NumberTickUnit(5.0E7, (CPFormat<Object>)df9, 5));
            units.add(new NumberTickUnit(5.0E8, (CPFormat<Object>)df9, 5));
            units.add(new NumberTickUnit(5.0E9, (CPFormat<Object>)df10, 5));
            units.add(new NumberTickUnit(5.0E10, (CPFormat<Object>)df10, 5));
            units.add(new NumberTickUnit(5.0E11, (CPFormat<Object>)df10, 5));
            return units;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

