/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactory;
import com.macrofocus.plot.guide.NumberTickUnit;
import com.macrofocus.plot.guide.TickUnit;
import com.macrofocus.plot.guide.TickUnitSource;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/macrofocus/plot/guide/TickUnits;", "Lcom/macrofocus/plot/guide/TickUnitSource;", "formatFactory", "Lcom/macrofocus/common/format/FormatFactory;", "<init>", "(Lcom/macrofocus/common/format/FormatFactory;)V", "tickUnits", "", "Lcom/macrofocus/plot/guide/TickUnit;", "add", "", "unit", "getLargerTickUnit", "getCeilingTickUnit", "size", "", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class TickUnits
implements TickUnitSource {
    @NotNull
    private final FormatFactory formatFactory;
    @NotNull
    private final List<TickUnit> tickUnits;
    public static final int $stable = 8;

    public TickUnits(@NotNull FormatFactory formatFactory) {
        Intrinsics.checkNotNullParameter((Object)formatFactory, (String)"formatFactory");
        this.formatFactory = formatFactory;
        this.tickUnits = new ArrayList();
    }

    public final void add(@NotNull TickUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.tickUnits.add(unit);
        CollectionsKt.sort(this.tickUnits);
    }

    @Override
    @NotNull
    public TickUnit getLargerTickUnit(@NotNull TickUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        int index = CollectionsKt.binarySearch$default(this.tickUnits, (Comparable)unit, (int)0, (int)0, (int)6, null);
        return this.tickUnits.get(Math.min(index += index >= 0 ? 1 : -index, this.tickUnits.size() - 1));
    }

    @Override
    @NotNull
    public TickUnit getCeilingTickUnit(@NotNull TickUnit unit) {
        TickUnit tickUnit;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        int index = CollectionsKt.binarySearch$default(this.tickUnits, (Comparable)unit, (int)0, (int)0, (int)6, null);
        if (index >= 0) {
            tickUnit = this.tickUnits.get(index);
        } else {
            index = -(index + 1);
            tickUnit = this.tickUnits.get(Math.min(index, this.tickUnits.size() - 1));
        }
        return tickUnit;
    }

    @Override
    @NotNull
    public TickUnit getCeilingTickUnit(double size) {
        return this.getCeilingTickUnit(new NumberTickUnit(size, (CPFormat<Object>)this.formatFactory.createDecimalFormat()));
    }
}

