/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.plot.guide.AbstractAxis;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.Range;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.RectangleInsets;
import com.macrofocus.plot.guide.Tick;
import com.macrofocus.plot.guide.TickUnitSource;
import com.macrofocus.plot.guide.ValueTick;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontFactory;
import org.mkui.geom.Polygon;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b'\u0018\u0000 92\u00020\u0001:\u00019B+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!J&\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\rH\u0002J&\u0010(\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\rH\u0002J\b\u0010)\u001a\u0004\u0018\u00010\u0015J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010*\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rH\u0016J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020#H\u0016J\u0006\u0010/\u001a\u00020\u0019J\u0006\u00100\u001a\u00020\tJ\u001e\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ \u00104\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020#2\u0006\u00103\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH$J\u001a\u00105\u001a\u00020\u00192\u0010\u00106\u001a\f\u0012\u0006\u0012\u0004\u0018\u000108\u0018\u000107H&R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006:"}, d2={"Lcom/macrofocus/plot/guide/ValueAxis;", "Lcom/macrofocus/plot/guide/AbstractAxis;", "fontFactory", "Lorg/mkui/font/CPFontFactory;", "headless", "Lorg/mkui/graphics/IHeadless;", "label", "", "standardTickUnits", "Lcom/macrofocus/plot/guide/TickUnitSource;", "<init>", "(Lorg/mkui/font/CPFontFactory;Lorg/mkui/graphics/IHeadless;Ljava/lang/String;Lcom/macrofocus/plot/guide/TickUnitSource;)V", "isInverted", "", "()Z", "minorTickCount", "", "getMinorTickCount", "()I", "isVerticalTickLabels", "range", "Lcom/macrofocus/plot/guide/Range;", "value", "isAutoTickUnitSelection", "reserveSpace", "", "g2", "Lorg/mkui/graphics/IGraphics;", "plotArea", "Lorg/mkui/geom/Rectangle2D;", "edge", "Lcom/macrofocus/plot/guide/RectangleEdge;", "space", "Lcom/macrofocus/plot/guide/AxisSpace;", "findMaximumTickLabelHeight", "", "ticks", "", "Lcom/macrofocus/plot/guide/Tick;", "vertical", "findMaximumTickLabelWidth", "getRange", "setRange", "turnOffAutoRange", "notify", "lower", "upper", "setAutoTickUnitSelection", "getStandardTickUnits", "lengthToJava2D", "length", "area", "valueToJava2D", "setFormatOverride", "format", "Lcom/macrofocus/common/format/CPFormat;", "", "Companion", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public abstract class ValueAxis
extends AbstractAxis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isInverted;
    @NotNull
    private final TickUnitSource standardTickUnits;
    private final int minorTickCount;
    private final boolean isVerticalTickLabels;
    @Nullable
    private Range range;
    private boolean isAutoTickUnitSelection;
    public static final int $stable = 8;
    public static final int MAXIMUM_TICK_COUNT = 500;
    @NotNull
    private static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    private static final boolean DEFAULT_INVERTED = false;
    private static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;

    protected ValueAxis(@NotNull CPFontFactory fontFactory, @NotNull IHeadless headless, @Nullable String label, @NotNull TickUnitSource standardTickUnits) {
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        Intrinsics.checkNotNullParameter((Object)standardTickUnits, (String)"standardTickUnits");
        super(fontFactory, headless, label);
        this.range = DEFAULT_RANGE;
        this.isInverted = false;
        this.isAutoTickUnitSelection = true;
        this.standardTickUnits = standardTickUnits;
        Polygon p1 = new Polygon();
        p1.addPoint(0, 0);
        p1.addPoint(-2, 2);
        p1.addPoint(2, 2);
        Polygon p2 = new Polygon();
        p2.addPoint(0, 0);
        p2.addPoint(-2, -2);
        p2.addPoint(2, -2);
        Polygon p3 = new Polygon();
        p3.addPoint(0, 0);
        p3.addPoint(-2, -2);
        p3.addPoint(-2, 2);
        Polygon p4 = new Polygon();
        p4.addPoint(0, 0);
        p4.addPoint(2, -2);
        p4.addPoint(2, 2);
        this.isVerticalTickLabels = false;
        this.minorTickCount = 0;
    }

    public final boolean isInverted() {
        return this.isInverted;
    }

    public final int getMinorTickCount() {
        return this.minorTickCount;
    }

    public final boolean isVerticalTickLabels() {
        return this.isVerticalTickLabels;
    }

    public final boolean isAutoTickUnitSelection() {
        return this.isAutoTickUnitSelection;
    }

    public final void reserveSpace(@NotNull IGraphics g2, @NotNull Rectangle2D plotArea, @NotNull RectangleEdge edge, @Nullable AxisSpace space) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)plotArea, (String)"plotArea");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        AxisSpace space2 = space;
        if (space2 == null) {
            space2 = new AxisSpace();
        }
        if (!this.isVisible()) {
            return;
        }
        double tickLabelHeight = 0.0;
        double tickLabelWidth = 0.0;
        if (this.isTickLabelsVisible()) {
            List<ValueTick> ticks = this.refreshTicks(g2, plotArea, edge);
            if (RectangleEdge.Companion.isTopOrBottom(edge)) {
                tickLabelHeight = this.findMaximumTickLabelHeight((Iterable<? extends Tick>)ticks, g2, this.isVerticalTickLabels);
            } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
                tickLabelWidth = this.findMaximumTickLabelWidth((Iterable<? extends Tick>)ticks, g2, this.isVerticalTickLabels);
            }
        }
        Rectangle2D labelEnclosure = this.getLabelEnclosure(g2, edge);
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            double labelHeight = labelEnclosure.getHeight();
            space2.add(labelHeight + tickLabelHeight, edge);
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            double labelWidth = labelEnclosure.getWidth();
            space2.add(labelWidth + tickLabelWidth, edge);
        }
    }

    private final double findMaximumTickLabelHeight(Iterable<? extends Tick> ticks, IGraphics g2, boolean vertical) {
        RectangleInsets insets = this.getTickLabelInsets();
        double maxHeight = 0.0;
        if (vertical) {
            for (Tick tick : ticks) {
                float labelWidth = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), tick.getText());
                if (!((double)labelWidth + insets.getTop() + insets.getBottom() > maxHeight)) continue;
                maxHeight = (double)labelWidth + insets.getTop() + insets.getBottom();
            }
        } else {
            maxHeight = (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "ABCxyz") + insets.getTop() + insets.getBottom();
        }
        return maxHeight;
    }

    private final double findMaximumTickLabelWidth(Iterable<? extends Tick> ticks, IGraphics g2, boolean vertical) {
        RectangleInsets insets = this.getTickLabelInsets();
        double maxWidth = 0.0;
        if (vertical) {
            maxWidth = (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "ABCxyz") + insets.getTop() + insets.getBottom();
        } else {
            for (Tick tick : ticks) {
                float labelWidth = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), tick.getText());
                if (!((double)labelWidth + insets.getLeft() + insets.getRight() > maxWidth)) continue;
                maxWidth = (double)labelWidth + insets.getLeft() + insets.getRight();
            }
        }
        return maxWidth;
    }

    @Nullable
    public final Range getRange() {
        return this.range;
    }

    public void setRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.setRange(range, true, true);
    }

    public void setRange(@NotNull Range range, boolean turnOffAutoRange, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.range = range;
    }

    public void setRange(double lower, double upper) {
        this.setRange(new Range(lower, upper));
    }

    public final void setAutoTickUnitSelection() {
        if (this.isAutoTickUnitSelection) {
            this.isAutoTickUnitSelection = false;
        }
    }

    @NotNull
    public final TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public final double lengthToJava2D(double length, @NotNull Rectangle2D area, @NotNull RectangleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        double zero = this.valueToJava2D(0.0, area, edge);
        double l = this.valueToJava2D(length, area, edge);
        return Math.abs(l - zero);
    }

    protected abstract double valueToJava2D(double var1, @NotNull Rectangle2D var3, @NotNull RectangleEdge var4);

    public abstract void setFormatOverride(@Nullable CPFormat<Object> var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/macrofocus/plot/guide/ValueAxis$Companion;", "", "<init>", "()V", "MAXIMUM_TICK_COUNT", "", "DEFAULT_RANGE", "Lcom/macrofocus/plot/guide/Range;", "DEFAULT_INVERTED", "", "DEFAULT_AUTO_TICK_UNIT_SELECTION", "macrofocus-slider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

