/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.math.Histogram;
import com.macrofocus.slider.AbstractRangeSliderModel;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\tJ \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016J \u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u00104\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u00105\u001a\u00020$2\u0006\u00106\u001a\u00020\u001cH\u0016J\u0010\u00107\u001a\u00020$2\u0006\u00106\u001a\u00020\u001cH\u0016J\u0010\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020$2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010<\u001a\u00020=H\u0016R\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010*\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\rR\u0014\u0010,\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\rR\u0014\u0010.\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\rR\u0014\u00100\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\rR\u0014\u00102\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\rR\u0014\u0010>\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010@\u00a8\u0006A"}, d2={"Lcom/macrofocus/slider/SimpleRangeSliderModel;", "Lcom/macrofocus/slider/AbstractRangeSliderModel;", "min", "", "max", "<init>", "(DD)V", "minExtent", "maxExtent", "(DDDD)V", "value", "currentMinimum", "getCurrentMinimum", "()D", "currentMaximum", "getCurrentMaximum", "currentExtent", "getCurrentExtent", "minimum", "getMinimum", "maximum", "getMaximum", "minimumExtent", "getMinimumExtent", "maximumExtent", "getMaximumExtent", "sliderListeners", "", "Lcom/macrofocus/slider/RangeSliderListener;", "histogram", "Lcom/macrofocus/common/math/Histogram;", "getHistogram", "()Lcom/macrofocus/common/math/Histogram;", "setHistogram", "(Lcom/macrofocus/common/math/Histogram;)V", "setValues", "", "source", "", "rangeMin", "rangeMax", "setMinMax", "extent", "getExtent", "upperMinimumValue", "getUpperMinimumValue", "upperMaximumValue", "getUpperMaximumValue", "lowerMinimumValue", "getLowerMinimumValue", "lowerMaximumValue", "getLowerMaximumValue", "reset", "addSliderListener", "rangeSliderListener", "removeSliderListener", "notifySliderChanged", "eventRange", "Lcom/macrofocus/slider/RangeSliderEvent;", "notifySliderScaleChanged", "toString", "", "isInvertedScale", "", "()Z", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class SimpleRangeSliderModel
extends AbstractRangeSliderModel {
    private double currentMinimum;
    private double currentMaximum;
    private double currentExtent;
    private double minimum;
    private double maximum;
    private double minimumExtent;
    private double maximumExtent;
    @NotNull
    private List<RangeSliderListener> sliderListeners;
    @Nullable
    private Histogram histogram;
    public static final int $stable = 8;

    @Override
    public double getCurrentMinimum() {
        return this.currentMinimum;
    }

    @Override
    public double getCurrentMaximum() {
        return this.currentMaximum;
    }

    @Override
    public double getCurrentExtent() {
        return this.currentExtent;
    }

    @Override
    public double getMinimum() {
        return this.minimum;
    }

    @Override
    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public double getMinimumExtent() {
        return this.minimumExtent;
    }

    @Override
    public double getMaximumExtent() {
        return this.maximumExtent;
    }

    @Override
    @Nullable
    public Histogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(@Nullable Histogram histogram) {
        this.histogram = histogram;
    }

    public SimpleRangeSliderModel(double min, double max) {
        this.minimum = min;
        this.maximum = max;
        this.currentMinimum = min;
        this.currentMaximum = max;
        this.currentExtent = Math.max(this.getCurrentMinimum(), this.getCurrentMaximum()) - Math.min(this.getCurrentMinimum(), this.getCurrentMaximum());
        this.minimumExtent = 0.0;
        this.maximumExtent = Math.max(min, max) - Math.min(min, max);
        this.sliderListeners = new ArrayList();
    }

    public SimpleRangeSliderModel(double min, double max, double minExtent, double maxExtent) {
        this.minimum = min;
        this.maximum = max;
        this.currentMinimum = min;
        this.currentMaximum = max;
        this.currentExtent = Math.max(this.getCurrentMinimum(), this.getCurrentMaximum()) - Math.min(this.getCurrentMinimum(), this.getCurrentMaximum());
        this.minimumExtent = minExtent;
        this.maximumExtent = maxExtent;
        this.sliderListeners = new ArrayList();
    }

    @Override
    public void setValues(@NotNull Object source, double rangeMin, double rangeMax) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(this.getCurrentMinimum() == rangeMin) || !(this.getCurrentMaximum() == rangeMax)) {
            double previousRangeMin = this.getCurrentMinimum();
            double previousRangeMax = this.getCurrentMaximum();
            this.currentMinimum = rangeMin;
            this.currentMaximum = rangeMax;
            this.currentExtent = Math.max(rangeMin, rangeMax) - Math.min(rangeMin, rangeMax);
            RangeSliderEvent eventRange = new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), previousRangeMin, previousRangeMax);
            this.notifySliderChanged(eventRange);
        }
    }

    @Override
    public void setMinMax(@NotNull Object source, double min, double max) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(this.getMinimum() == min) || !(this.getMaximum() == max)) {
            this.minimum = min;
            this.maximum = max;
            RangeSliderEvent eventRange = new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), this.getCurrentMinimum(), this.getCurrentMaximum());
            this.notifySliderScaleChanged(eventRange);
        }
    }

    @Override
    public double getExtent() {
        return Math.max(this.getMinimum(), this.getMaximum()) - Math.min(this.getMinimum(), this.getMaximum());
    }

    @Override
    public double getUpperMinimumValue() {
        return this.getMinimum();
    }

    @Override
    public double getUpperMaximumValue() {
        return this.getMaximum();
    }

    @Override
    public double getLowerMinimumValue() {
        return this.getMinimum();
    }

    @Override
    public double getLowerMaximumValue() {
        return this.getMaximum();
    }

    @Override
    public void reset(@NotNull Object source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        double previousRangeMin = this.getCurrentMinimum();
        double previousRangeMax = this.getCurrentMaximum();
        if (!this.isInvertedScale()) {
            double tmpRangeMin;
            double tmpRangeMax = this.getMaximum();
            if (tmpRangeMax - (tmpRangeMin = this.getMinimum()) > this.getMaximumExtent()) {
                tmpRangeMax = this.getCurrentMinimum() + this.getMaximumExtent();
                tmpRangeMin = this.getCurrentMinimum();
                if (tmpRangeMax > this.getMaximum()) {
                    tmpRangeMin -= tmpRangeMax - this.getMaximum();
                    tmpRangeMax = this.getMaximum();
                }
            }
            this.currentMaximum = tmpRangeMax;
            this.currentMinimum = tmpRangeMin;
            if (!(this.getCurrentMinimum() == previousRangeMin) || !(this.getCurrentMaximum() == previousRangeMax)) {
                this.notifySliderChanged(new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), previousRangeMin, previousRangeMax));
            }
        } else {
            double tmpRangeMax = this.getMaximum();
            double tmpRangeMin = this.getMinimum();
            if (tmpRangeMin - tmpRangeMax > this.getMaximumExtent()) {
                tmpRangeMax = this.getCurrentMinimum();
                tmpRangeMin = this.getCurrentMinimum() + this.getMaximumExtent();
                if (tmpRangeMin > this.getMinimum()) {
                    tmpRangeMax -= tmpRangeMin - this.getMinimum();
                    tmpRangeMin = this.getMinimum();
                }
            }
            this.currentMaximum = tmpRangeMax;
            this.currentMinimum = tmpRangeMin;
            if (!(this.getCurrentMinimum() == previousRangeMin) || !(this.getCurrentMaximum() == previousRangeMax)) {
                this.notifySliderChanged(new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), previousRangeMin, previousRangeMax));
            }
        }
    }

    @Override
    public void addSliderListener(@NotNull RangeSliderListener rangeSliderListener2) {
        Intrinsics.checkNotNullParameter((Object)rangeSliderListener2, (String)"rangeSliderListener");
        this.sliderListeners.add(rangeSliderListener2);
    }

    @Override
    public void removeSliderListener(@NotNull RangeSliderListener rangeSliderListener2) {
        Intrinsics.checkNotNullParameter((Object)rangeSliderListener2, (String)"rangeSliderListener");
        this.sliderListeners.remove(rangeSliderListener2);
    }

    private final void notifySliderChanged(RangeSliderEvent eventRange) {
        Iterator<RangeSliderListener> iterator = this.sliderListeners.iterator();
        while (iterator.hasNext()) {
            RangeSliderListener listener2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            listener2.sliderChanged(eventRange);
        }
    }

    private final void notifySliderScaleChanged(RangeSliderEvent eventRange) {
        Iterator<RangeSliderListener> iterator = this.sliderListeners.iterator();
        while (iterator.hasNext()) {
            RangeSliderListener listener2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            listener2.sliderScaleChanged(eventRange);
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "[rangeMin=" + this.getCurrentMinimum() + ",rangeMax=" + this.getCurrentMaximum() + ",amount=" + this.getCurrentExtent() + ",min=" + this.getMinimum() + ",max=" + this.getMaximum() + "]";
    }

    @Override
    public boolean isInvertedScale() {
        return this.getMinimum() > this.getMaximum();
    }
}

