/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.transform.SimpleOneDScreenTransform;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.RangeSliderView;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.MouseEvent;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u00002\u00020\u00012\u00020\u0002:\u0003234B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\b\u0010/\u001a\u00020)H\u0002J\u0012\u00100\u001a\u00020)2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u00101\u001a\u00020)H\u0002R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\b\u0018\u00010\u0010R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000bR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/macrofocus/slider/AbstractRangeSliderView;", "Lorg/mkui/canvas/CPCanvas;", "Lcom/macrofocus/slider/RangeSliderView;", "()V", "arrowColor", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "colorTheme", "Lcom/macrofocus/common/properties/MutableProperty;", "Lorg/mkui/graphics/colortheme/ColorTheme;", "getColorTheme", "()Lcom/macrofocus/common/properties/MutableProperty;", "continuousUpdating", "", "getContinuousUpdating", "drawing", "Lcom/macrofocus/slider/AbstractRangeSliderView$SliderDrawing;", "fullInterval", "Lcom/macrofocus/common/interval/SimpleBoundedInterval;", "height", "", "getHeight", "()I", "interval", "model", "Lcom/macrofocus/slider/RangeSliderModel;", "mouseReleased", "orientation", "Lcom/macrofocus/slider/RangeSliderView$Orientation;", "getOrientation", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "Lcom/macrofocus/slider/RangeSliderView$PropertyType;", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "rangeSliderListener", "Lcom/macrofocus/slider/RangeSliderListener;", "showValues", "updateModelTimer", "Lcom/macrofocus/common/timer/CPTimer;", "drawArrow", "", "g", "Lorg/mkui/graphics/IGraphics;", "from", "Lorg/mkui/geom/Point2D;", "to", "scheduleUpdateModel", "setModel", "updateModel", "Knob", "SliderDrawing", "SliderListener", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public abstract class AbstractRangeSliderView
extends CPCanvas
implements RangeSliderView {
    @NotNull
    private final MutableProperties<RangeSliderView.PropertyType> properties = (MutableProperties)new EnumProperties((Enum[])RangeSliderView.PropertyType.values());
    private final boolean showValues;
    private boolean mouseReleased;
    @Nullable
    private RangeSliderModel model;
    @Nullable
    private SimpleBoundedInterval interval;
    @Nullable
    private SimpleBoundedInterval fullInterval;
    @Nullable
    private SliderDrawing drawing;
    @NotNull
    private Color arrowColor;
    @NotNull
    private final CPTimer updateModelTimer;
    @NotNull
    private final RangeSliderListener rangeSliderListener = new RangeSliderListener(this){
        final /* synthetic */ AbstractRangeSliderView this$0;
        {
            this.this$0 = $receiver;
        }

        public void sliderChanged(@NotNull RangeSliderEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SimpleBoundedInterval simpleBoundedInterval = AbstractRangeSliderView.access$getInterval$p(this.this$0);
                if (simpleBoundedInterval == null) break block0;
                RangeSliderModel rangeSliderModel = AbstractRangeSliderView.access$getModel$p(this.this$0);
                Intrinsics.checkNotNull((Object)rangeSliderModel);
                double d = rangeSliderModel.getCurrentMinimum();
                RangeSliderModel rangeSliderModel2 = AbstractRangeSliderView.access$getModel$p(this.this$0);
                Intrinsics.checkNotNull((Object)rangeSliderModel2);
                simpleBoundedInterval.setValue(d, rangeSliderModel2.getCurrentExtent());
            }
        }

        public void sliderScaleChanged(@NotNull RangeSliderEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }
    };
    public static final int $stable = 8;

    public AbstractRangeSliderView() {
        this.showValues = true;
        this.updateModelTimer = CPHelper.Companion.getInstance().createTimer("RangeSliderUpdater", 40, true, new CPTimerListener(){

            public void timerTriggered() {
                this.updateModel();
            }
        });
        this.properties.createProperty((Object)RangeSliderView.PropertyType.Orientation, (Object)RangeSliderView.Orientation.Vertical);
        this.properties.createProperty((Object)RangeSliderView.PropertyType.ContinuousUpdating, (Object)true);
        this.properties.createProperty((Object)RangeSliderView.PropertyType.ColorTheme, null);
        this.arrowColor = MkColorKt.colorOf((int)127, (int)127, (int)127);
    }

    @NotNull
    protected final MutableProperties<RangeSliderView.PropertyType> getProperties() {
        return this.properties;
    }

    @Override
    public void setModel(@Nullable RangeSliderModel model) {
        if (this.model != model) {
            if (this.model != null) {
                RangeSliderModel rangeSliderModel = this.model;
                Intrinsics.checkNotNull((Object)rangeSliderModel);
                rangeSliderModel.removeSliderListener(this.rangeSliderListener);
            }
            this.model = model;
            RangeSliderModel rangeSliderModel = model;
            Intrinsics.checkNotNull((Object)rangeSliderModel);
            this.interval = new SimpleBoundedInterval(rangeSliderModel.getCurrentMinimum(), model.getCurrentExtent(), 0.0, 0.0, 12, null);
            SimpleBoundedInterval simpleBoundedInterval = this.fullInterval = new SimpleBoundedInterval(model.getMinimum(), model.getExtent(), 0.0, 0.0, 12, null);
            Intrinsics.checkNotNull((Object)simpleBoundedInterval);
            SimpleOneDScreenTransform transform = new SimpleOneDScreenTransform((BoundedInterval)simpleBoundedInterval, 0);
            SimpleBoundedInterval simpleBoundedInterval2 = this.interval;
            Intrinsics.checkNotNull((Object)simpleBoundedInterval2);
            SimpleBoundedInterval simpleBoundedInterval3 = this.fullInterval;
            Intrinsics.checkNotNull((Object)simpleBoundedInterval3);
            SliderDrawing sliderDrawing = this.drawing = new SliderDrawing(simpleBoundedInterval2, simpleBoundedInterval3, transform);
            Intrinsics.checkNotNull((Object)((Object)sliderDrawing));
            this.addLayer((IDrawing)sliderDrawing);
            SimpleBoundedInterval simpleBoundedInterval4 = this.interval;
            Intrinsics.checkNotNull((Object)simpleBoundedInterval4);
            SliderListener l = new SliderListener(simpleBoundedInterval4, transform);
            this.addMouseListener(l);
            this.addMouseMotionListener(l);
            model.addSliderListener(this.rangeSliderListener);
        }
    }

    @Override
    @NotNull
    public MutableProperty<RangeSliderView.Orientation> getOrientation() {
        MutableProperty mutableProperty = this.properties.getProperty((Object)RangeSliderView.PropertyType.Orientation);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<com.macrofocus.slider.RangeSliderView.Orientation>");
        return mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getContinuousUpdating() {
        MutableProperty mutableProperty = this.properties.getProperty((Object)RangeSliderView.PropertyType.ContinuousUpdating);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<kotlin.Boolean>");
        return mutableProperty;
    }

    @NotNull
    public final MutableProperty<ColorTheme> getColorTheme() {
        MutableProperty mutableProperty = this.properties.getProperty((Object)RangeSliderView.PropertyType.ColorTheme);
        Intrinsics.checkNotNull((Object)mutableProperty, (String)"null cannot be cast to non-null type com.macrofocus.common.properties.MutableProperty<org.mkui.graphics.colortheme.ColorTheme>");
        return mutableProperty;
    }

    public final int getHeight() {
        return (int)this.getHeight();
    }

    public final void drawArrow(@NotNull IGraphics g, @NotNull Point2D from, @NotNull Point2D to) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        boolean drawPath = false;
        boolean triangle = true;
        int headlen = 10;
        double a = 0.8975979010256552;
        double angle = Math.atan2(to.getY() - from.getY(), to.getX() - from.getX());
        g.beginPath();
        g.moveTo(to.getX() - (double)headlen * Math.cos(angle - a), to.getY() - (double)headlen * Math.sin(angle - a));
        g.lineTo(to.getX(), to.getY());
        g.lineTo(to.getX() - (double)headlen * Math.cos(angle + a), to.getY() - (double)headlen * Math.sin(angle + a));
        g.closePath();
        g.fill();
    }

    private final void scheduleUpdateModel() {
        this.updateModelTimer.restart();
    }

    private final void updateModel() {
        RangeSliderModel rangeSliderModel = this.model;
        Intrinsics.checkNotNull((Object)rangeSliderModel);
        SimpleBoundedInterval simpleBoundedInterval = this.interval;
        Intrinsics.checkNotNull((Object)simpleBoundedInterval);
        double d = simpleBoundedInterval.getStart();
        SimpleBoundedInterval simpleBoundedInterval2 = this.interval;
        Intrinsics.checkNotNull((Object)simpleBoundedInterval2);
        rangeSliderModel.setValues(this, d, simpleBoundedInterval2.getEnd());
    }

    public static final /* synthetic */ SimpleBoundedInterval access$getInterval$p(AbstractRangeSliderView $this) {
        return $this.interval;
    }

    public static final /* synthetic */ RangeSliderModel access$getModel$p(AbstractRangeSliderView $this) {
        return $this.model;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/slider/AbstractRangeSliderView$Knob;", "", "(Ljava/lang/String;I)V", "Start", "End", "Thumb", "macrofocus-slider"})
    private static final class Knob
    extends Enum<Knob> {
        public static final /* enum */ Knob Start = new Knob();
        public static final /* enum */ Knob End = new Knob();
        public static final /* enum */ Knob Thumb = new Knob();
        private static final /* synthetic */ Knob[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Knob[] values() {
            return (Knob[])$VALUES.clone();
        }

        public static Knob valueOf(String value) {
            return Enum.valueOf(Knob.class, value);
        }

        @NotNull
        public static EnumEntries<Knob> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = knobArray = new Knob[]{Knob.Start, Knob.End, Knob.Thumb};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/macrofocus/slider/AbstractRangeSliderView$SliderDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "interval", "Lcom/macrofocus/common/interval/SimpleBoundedInterval;", "fullInterval", "transform", "Lcom/macrofocus/common/transform/SimpleOneDScreenTransform;", "(Lcom/macrofocus/slider/AbstractRangeSliderView;Lcom/macrofocus/common/interval/SimpleBoundedInterval;Lcom/macrofocus/common/interval/SimpleBoundedInterval;Lcom/macrofocus/common/transform/SimpleOneDScreenTransform;)V", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "notifyIDrawingChanged", "macrofocus-slider"})
    private final class SliderDrawing
    extends AbstractIDrawing {
        @NotNull
        private final SimpleBoundedInterval interval;
        @NotNull
        private final SimpleBoundedInterval fullInterval;
        @NotNull
        private final SimpleOneDScreenTransform transform;

        public SliderDrawing(@NotNull SimpleBoundedInterval interval, @NotNull SimpleBoundedInterval fullInterval, SimpleOneDScreenTransform transform) {
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            Intrinsics.checkNotNullParameter((Object)fullInterval, (String)"fullInterval");
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            this.interval = interval;
            this.fullInterval = fullInterval;
            this.transform = transform;
            transform.setScreenMargins(16);
            interval.addIntervalListener(new IntervalListener(){

                public void intervalChanged(@NotNull IntervalEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.notifyIDrawingChanged();
                }
            });
        }

        public void draw(@NotNull IGraphics g, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
            double w = 0.0;
            double h = 0.0;
            if (AbstractRangeSliderView.this.getOrientation().getValue() == RangeSliderView.Orientation.Horizontal) {
                w = width;
                h = height;
            } else {
                w = height;
                h = width;
                int w2 = (int)width / 2;
                int h2 = (int)height / 2;
                g.translate(w2, h2);
                g.rotate(-1.5707963267948966);
                g.translate(-h2, -w2);
            }
            this.transform.setScreenSize((int)w);
            g.setLineWidth(1.5);
            int centerY = (int)(h / (double)2);
            int fullX1 = this.transform.worldToScreen(this.fullInterval.getStart());
            int fullX2 = this.transform.worldToScreen(this.fullInterval.getEnd());
            int x1 = this.transform.worldToScreen(this.interval.getStart());
            int x2 = this.transform.worldToScreen(this.interval.getEnd());
            g.setColor(AbstractRangeSliderView.this.arrowColor);
            AbstractRangeSliderView.this.drawArrow(g, (Point2D)new Point(fullX1 - 1, centerY), (Point2D)new Point(x1, centerY));
            AbstractRangeSliderView.this.drawArrow(g, (Point2D)new Point(fullX2 + 1, centerY), (Point2D)new Point(x2, centerY));
        }

        public void notifyIDrawingChanged() {
            super.notifyIDrawingChanged();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/macrofocus/slider/AbstractRangeSliderView$SliderListener;", "Lorg/mkui/canvas/MouseListener;", "Lorg/mkui/canvas/MouseMotionListener;", "interval", "Lcom/macrofocus/common/interval/SimpleBoundedInterval;", "transform", "Lcom/macrofocus/common/transform/SimpleOneDScreenTransform;", "(Lcom/macrofocus/slider/AbstractRangeSliderView;Lcom/macrofocus/common/interval/SimpleBoundedInterval;Lcom/macrofocus/common/transform/SimpleOneDScreenTransform;)V", "knob", "Lcom/macrofocus/slider/AbstractRangeSliderView$Knob;", "last", "", "getLast", "()Ljava/lang/Integer;", "setLast", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "lastEnd", "", "getLastEnd", "()Ljava/lang/Double;", "setLastEnd", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "lastStart", "getLastStart", "setLastStart", "mouseClicked", "", "e", "Lorg/mkui/canvas/MouseEvent;", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "updateInterval", "event", "macrofocus-slider"})
    private final class SliderListener
    implements MouseListener,
    MouseMotionListener {
        @NotNull
        private final SimpleBoundedInterval interval;
        @NotNull
        private final SimpleOneDScreenTransform transform;
        @Nullable
        private Integer last;
        @Nullable
        private Double lastStart;
        @Nullable
        private Double lastEnd;
        @Nullable
        private Knob knob;

        public SliderListener(@NotNull SimpleBoundedInterval interval, SimpleOneDScreenTransform transform) {
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            this.interval = interval;
            this.transform = transform;
        }

        @Nullable
        public final Integer getLast() {
            return this.last;
        }

        public final void setLast(@Nullable Integer n) {
            this.last = n;
        }

        @Nullable
        public final Double getLastStart() {
            return this.lastStart;
        }

        public final void setLastStart(@Nullable Double d) {
            this.lastStart = d;
        }

        @Nullable
        public final Double getLastEnd() {
            return this.lastEnd;
        }

        public final void setLastEnd(@Nullable Double d) {
            this.lastEnd = d;
        }

        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getClickCount() > 1) {
                this.interval.reset();
            }
        }

        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int x = AbstractRangeSliderView.this.getOrientation().getValue() == RangeSliderView.Orientation.Horizontal ? e.getX() : AbstractRangeSliderView.this.getHeight() - e.getY();
            this.last = x;
            int x1 = this.transform.worldToScreen(this.interval.getStart());
            int x2 = this.transform.worldToScreen(this.interval.getEnd());
            if (Math.abs(x - x1) <= 8) {
                this.knob = Knob.Start;
            } else if (Math.abs(x - x2) <= 8) {
                this.knob = Knob.End;
            } else if (!this.interval.isFullRange() && x > x1 && x < x2) {
                this.knob = Knob.Thumb;
                this.lastStart = this.interval.getStart();
                this.lastEnd = this.interval.getEnd();
            } else {
                this.knob = null;
            }
            if (this.knob != null) {
                e.stopPropagation();
            }
        }

        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AbstractRangeSliderView.this.mouseReleased = true;
            if (this.knob != null && this.last != null) {
                this.updateInterval(e);
            }
            this.last = null;
            this.lastStart = null;
            this.lastEnd = null;
            this.knob = null;
        }

        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AbstractRangeSliderView.this.arrowColor = AbstractRangeSliderView.this.getColorTheme().getValue() != null ? ((ColorTheme)AbstractRangeSliderView.this.getColorTheme().getValue()).getProbing() : MkColorKt.colorOf((int)255, (int)200, (int)0);
            SliderDrawing sliderDrawing = AbstractRangeSliderView.this.drawing;
            Intrinsics.checkNotNull((Object)((Object)sliderDrawing));
            sliderDrawing.notifyIDrawingChanged();
        }

        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            AbstractRangeSliderView.this.arrowColor = MkColorKt.colorOf((int)127, (int)127, (int)127);
            SliderDrawing sliderDrawing = AbstractRangeSliderView.this.drawing;
            Intrinsics.checkNotNull((Object)((Object)sliderDrawing));
            sliderDrawing.notifyIDrawingChanged();
        }

        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.knob != null && this.last != null) {
                this.updateInterval(e);
                e.stopPropagation();
            }
        }

        private final void updateInterval(MouseEvent event) {
            int x = AbstractRangeSliderView.this.getOrientation().getValue() == RangeSliderView.Orientation.Horizontal ? event.getX() : AbstractRangeSliderView.this.getHeight() - event.getY();
            Knob knob = this.knob;
            switch (knob == null ? -1 : WhenMappings.$EnumSwitchMapping$0[knob.ordinal()]) {
                case 1: {
                    SimpleBoundedInterval simpleBoundedInterval = AbstractRangeSliderView.this.fullInterval;
                    Intrinsics.checkNotNull((Object)simpleBoundedInterval);
                    int x1 = this.transform.worldToScreen(simpleBoundedInterval.getStart());
                    double d = this.interval.getEnd();
                    double d2 = this.interval.getMinimum();
                    Integer n = this.last;
                    Intrinsics.checkNotNull((Object)n);
                    double start = Math.min(d, Math.max(d2, this.transform.screenToWorld(x1 + (x - n))));
                    if (!(start >= this.interval.getMinimum()) || !(start <= this.interval.getEnd())) break;
                    this.interval.setStart(start);
                    break;
                }
                case 2: {
                    SimpleBoundedInterval simpleBoundedInterval = AbstractRangeSliderView.this.fullInterval;
                    Intrinsics.checkNotNull((Object)simpleBoundedInterval);
                    int x2 = this.transform.worldToScreen(simpleBoundedInterval.getEnd());
                    double d = this.interval.getStart();
                    double d3 = this.interval.getMaximum();
                    Integer n = this.last;
                    Intrinsics.checkNotNull((Object)n);
                    double end = Math.max(d, Math.min(d3, this.transform.screenToWorld(x2 + (x - n))));
                    if (!(end <= this.interval.getMaximum()) || !(end >= this.interval.getStart())) break;
                    this.interval.setEnd(end);
                    break;
                }
                case 3: {
                    Double d = this.lastStart;
                    Intrinsics.checkNotNull((Object)d);
                    int x1 = this.transform.worldToScreen(d.doubleValue());
                    Double d4 = this.lastEnd;
                    Intrinsics.checkNotNull((Object)d4);
                    int x2 = this.transform.worldToScreen(d4.doubleValue());
                    Integer n = this.last;
                    Intrinsics.checkNotNull((Object)n);
                    double s = this.transform.screenToWorld(x1 + (x - n));
                    Integer n2 = this.last;
                    Intrinsics.checkNotNull((Object)n2);
                    double e = this.transform.screenToWorld(x2 + (x - n2));
                    if (s < this.interval.getMinimum()) {
                        s = this.interval.getMinimum();
                        e = this.interval.getMinimum() + this.interval.getExtent();
                    }
                    if (e > this.interval.getMaximum()) {
                        e = this.interval.getMaximum();
                        s = this.interval.getMaximum() - this.interval.getExtent();
                    }
                    double start = Math.min(this.interval.getEnd(), Math.max(this.interval.getMinimum(), s));
                    double end = Math.max(this.interval.getStart(), Math.min(this.interval.getMaximum(), e));
                    if (start >= this.interval.getMinimum() && start <= this.interval.getEnd()) {
                        this.interval.setStart(start);
                    }
                    if (!(end <= this.interval.getMaximum()) || !(end >= this.interval.getStart())) break;
                    this.interval.setEnd(end);
                }
            }
            SliderDrawing sliderDrawing = AbstractRangeSliderView.this.drawing;
            Intrinsics.checkNotNull((Object)((Object)sliderDrawing));
            sliderDrawing.notifyIDrawingChanged();
            if (((Boolean)AbstractRangeSliderView.this.getContinuousUpdating().getValue()).booleanValue() || AbstractRangeSliderView.this.mouseReleased) {
                AbstractRangeSliderView.this.scheduleUpdateModel();
            }
            AbstractRangeSliderView.this.mouseReleased = false;
        }

        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Knob.values().length];
                try {
                    nArray[Knob.Start.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Knob.End.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Knob.Thumb.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

