/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.math.Histogram;
import com.macrofocus.slider.AbstractRangeSliderModel;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001[B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u000208H\u0016J\u0010\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020C2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010I\u001a\u00020C2\u0006\u0010D\u001a\u000208H\u0016J\u0010\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020LH\u0016J\u000e\u0010M\u001a\u00020C2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010N\u001a\u00020C2\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010O\u001a\u00020C2\u0006\u0010$\u001a\u00020\u001bJ \u0010P\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u0006H\u0016J\u000e\u0010S\u001a\u00020C2\u0006\u00100\u001a\u000201J\u000e\u0010T\u001a\u00020C2\u0006\u0010:\u001a\u00020\u001bJ\u000e\u0010U\u001a\u00020C2\u0006\u0010>\u001a\u00020\u001bJ \u0010V\u001a\u00020C2\u0006\u0010K\u001a\u00020L2\u0006\u0010W\u001a\u00020\u00062\u0006\u0010X\u001a\u00020\u0006H\u0016J\b\u0010Y\u001a\u00020ZH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010 \u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010%\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010#R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\rR\u0014\u0010*\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\rR\u0014\u0010.\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\rR\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001e\u00106\u001a\u0012\u0012\u0004\u0012\u00020807j\b\u0012\u0004\u0012\u000208`9X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010;\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\r\"\u0004\b=\u0010#R\u000e\u0010>\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010?\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\r\"\u0004\bA\u0010#\u00a8\u0006\\"}, d2={"Lcom/macrofocus/slider/BoundedIntervalRangeSliderAdapter;", "Lcom/macrofocus/slider/AbstractRangeSliderModel;", "boundedRangeModel", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "(Lcom/macrofocus/common/interval/MutableBoundedInterval;)V", "minExtentFactor", "", "maxExtentFactor", "(Lcom/macrofocus/common/interval/MutableBoundedInterval;DD)V", "boundedListener", "Lcom/macrofocus/common/interval/BoundedIntervalListener;", "currentExtent", "getCurrentExtent", "()D", "currentMaximum", "getCurrentMaximum", "currentMinimum", "getCurrentMinimum", "extent", "getExtent", "histogram", "Lcom/macrofocus/common/math/Histogram;", "getHistogram", "()Lcom/macrofocus/common/math/Histogram;", "setHistogram", "(Lcom/macrofocus/common/math/Histogram;)V", "isInvertedScale", "", "()Z", "listener", "Lcom/macrofocus/common/interval/IntervalListener;", "lowerMaximumEnabled", "lowerMaximumValue", "getLowerMaximumValue", "setLowerMaximumValue", "(D)V", "lowerMinimumEnabled", "lowerMinimumValue", "getLowerMinimumValue", "setLowerMinimumValue", "maximum", "getMaximum", "maximumExtent", "getMaximumExtent", "minimum", "getMinimum", "minimumExtent", "getMinimumExtent", "resetStrategy", "Lcom/macrofocus/slider/BoundedIntervalRangeSliderAdapter$ResetStrategy;", "self", "Lcom/macrofocus/slider/RangeSliderModel;", "getSelf", "()Lcom/macrofocus/slider/RangeSliderModel;", "sliderListeners", "Ljava/util/ArrayList;", "Lcom/macrofocus/slider/RangeSliderListener;", "Lkotlin/collections/ArrayList;", "upperMaximumEnabled", "upperMaximumValue", "getUpperMaximumValue", "setUpperMaximumValue", "upperMinimumEnabled", "upperMinimumValue", "getUpperMinimumValue", "setUpperMinimumValue", "addSliderListener", "", "rangeSliderListener", "notifySliderChanged", "eventRange", "Lcom/macrofocus/slider/RangeSliderEvent;", "notifySliderScaleChanged", "removeSliderListener", "reset", "source", "", "setBoundedRangeModel", "setLowerMaximumEnabled", "setLowerMinimumEnabled", "setMinMax", "min", "max", "setResetStrategy", "setUpperMaximumEnabled", "setUpperMinimumEnabled", "setValues", "rangeMin", "rangeMax", "toString", "", "ResetStrategy", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class BoundedIntervalRangeSliderAdapter
extends AbstractRangeSliderModel {
    @NotNull
    private MutableBoundedInterval boundedRangeModel;
    private final double minExtentFactor;
    private final double maxExtentFactor;
    private double lowerMinimumValue;
    private double lowerMaximumValue;
    private double upperMinimumValue;
    private double upperMaximumValue;
    private boolean lowerMinimumEnabled;
    private boolean lowerMaximumEnabled;
    private boolean upperMinimumEnabled;
    private boolean upperMaximumEnabled;
    @NotNull
    private final ArrayList<RangeSliderListener> sliderListeners;
    @Nullable
    private Histogram histogram;
    @NotNull
    private final IntervalListener listener;
    @NotNull
    private final BoundedIntervalListener boundedListener;
    @NotNull
    private ResetStrategy resetStrategy;
    public static final int $stable = 8;

    public BoundedIntervalRangeSliderAdapter(@NotNull MutableBoundedInterval boundedRangeModel, double minExtentFactor, double maxExtentFactor) {
        Intrinsics.checkNotNullParameter((Object)boundedRangeModel, (String)"boundedRangeModel");
        this.listener = new IntervalListener(this){
            final /* synthetic */ BoundedIntervalRangeSliderAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalChanged(@NotNull IntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                BoundedIntervalRangeSliderAdapter.access$notifySliderChanged(this.this$0, new RangeSliderEvent(BoundedIntervalRangeSliderAdapter.access$getSelf(this.this$0), this, event.getNewStart(), event.getNewEnd(), event.getOldStart(), event.getOldEnd()));
            }
        };
        this.boundedListener = new BoundedIntervalListener(this, boundedRangeModel){
            final /* synthetic */ BoundedIntervalRangeSliderAdapter this$0;
            final /* synthetic */ MutableBoundedInterval $boundedRangeModel;
            {
                this.this$0 = $receiver;
                this.$boundedRangeModel = $boundedRangeModel;
            }

            public void boundedIntervalChanged(@NotNull BoundedIntervalEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                RangeSliderEvent eventRange = new RangeSliderEvent(BoundedIntervalRangeSliderAdapter.access$getSelf(this.this$0), this, this.$boundedRangeModel.getMinimum(), this.$boundedRangeModel.getMaximum(), this.$boundedRangeModel.getMinimum(), this.$boundedRangeModel.getMaximum());
                BoundedIntervalRangeSliderAdapter.access$notifySliderScaleChanged(this.this$0, eventRange);
            }
        };
        this.resetStrategy = new ResetStrategy(this, boundedRangeModel){
            final /* synthetic */ BoundedIntervalRangeSliderAdapter this$0;
            final /* synthetic */ MutableBoundedInterval $boundedRangeModel;
            {
                this.this$0 = $receiver;
                this.$boundedRangeModel = $boundedRangeModel;
            }

            public void reset() {
                this.this$0.setValues(this, this.$boundedRangeModel.getMinimum(), Math.min(this.$boundedRangeModel.getMinimum() + this.$boundedRangeModel.getMaximumExtent(), this.$boundedRangeModel.getMaximum()));
            }
        };
        this.boundedRangeModel = boundedRangeModel;
        this.minExtentFactor = minExtentFactor;
        this.maxExtentFactor = maxExtentFactor;
        boundedRangeModel.addIntervalListener(this.listener);
        boundedRangeModel.addBoundedIntervalListener(this.boundedListener);
        this.sliderListeners = new ArrayList();
    }

    @Override
    public double getLowerMinimumValue() {
        return this.lowerMinimumEnabled ? this.lowerMinimumValue : this.getMinimum();
    }

    public void setLowerMinimumValue(double lowerMinimumValue) {
        this.lowerMinimumValue = lowerMinimumValue;
        this.lowerMinimumEnabled = true;
    }

    @Override
    public double getLowerMaximumValue() {
        return this.lowerMaximumEnabled ? this.lowerMaximumValue : this.getMaximum();
    }

    public void setLowerMaximumValue(double lowerMaximumValue) {
        this.lowerMaximumValue = lowerMaximumValue;
        this.lowerMaximumEnabled = true;
    }

    @Override
    public double getUpperMinimumValue() {
        return this.upperMinimumEnabled ? this.upperMinimumValue : this.getMinimum();
    }

    public void setUpperMinimumValue(double upperMinimumValue) {
        this.upperMinimumValue = upperMinimumValue;
        this.upperMinimumEnabled = true;
    }

    @Override
    public double getUpperMaximumValue() {
        return this.upperMaximumEnabled ? this.upperMaximumValue : this.getMaximum();
    }

    public void setUpperMaximumValue(double upperMaximumValue) {
        this.upperMaximumValue = upperMaximumValue;
        this.upperMaximumEnabled = true;
    }

    @Override
    @Nullable
    public Histogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(@Nullable Histogram histogram) {
        this.histogram = histogram;
    }

    public BoundedIntervalRangeSliderAdapter(@NotNull MutableBoundedInterval boundedRangeModel) {
        Intrinsics.checkNotNullParameter((Object)boundedRangeModel, (String)"boundedRangeModel");
        this(boundedRangeModel, 0.0, 1.0);
    }

    private final RangeSliderModel getSelf() {
        return this;
    }

    @Override
    public void setValues(@NotNull Object source, double rangeMin, double rangeMax) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.boundedRangeModel.setValue(rangeMin, rangeMax - rangeMin);
    }

    @Override
    public double getCurrentExtent() {
        return this.boundedRangeModel.getExtent();
    }

    @Override
    public double getCurrentMinimum() {
        return this.boundedRangeModel.getStart();
    }

    @Override
    public double getCurrentMaximum() {
        return this.boundedRangeModel.getEnd();
    }

    @Override
    public double getMinimum() {
        return this.boundedRangeModel.getMinimum();
    }

    @Override
    public double getMaximum() {
        return this.boundedRangeModel.getMaximum();
    }

    @Override
    public void setMinMax(@NotNull Object source, double min, double max) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.boundedRangeModel.setMinMax(min, max);
    }

    @Override
    public double getExtent() {
        return Math.abs(this.getMaximum() - this.getMinimum());
    }

    public final void setLowerMinimumEnabled(boolean lowerMinimumEnabled) {
        this.lowerMinimumEnabled = lowerMinimumEnabled;
    }

    public final void setLowerMaximumEnabled(boolean lowerMaximumEnabled) {
        this.lowerMaximumEnabled = lowerMaximumEnabled;
    }

    public final void setUpperMinimumEnabled(boolean upperMinimumEnabled) {
        this.upperMinimumEnabled = upperMinimumEnabled;
    }

    public final void setUpperMaximumEnabled(boolean upperMaximumEnabled) {
        this.upperMaximumEnabled = upperMaximumEnabled;
    }

    @Override
    public void reset(@NotNull Object source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.resetStrategy.reset();
    }

    @Override
    public double getMaximumExtent() {
        return this.maxExtentFactor == 0.0 ? (this.boundedRangeModel.getMaximumExtent() == 0.0 ? Double.MAX_VALUE : Math.abs(this.boundedRangeModel.getMaximumExtent())) : Math.abs(this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.maxExtentFactor;
    }

    @Override
    public double getMinimumExtent() {
        return this.minExtentFactor == 0.0 ? (this.boundedRangeModel.getMinimumExtent() == 0.0 ? 0.0 : this.boundedRangeModel.getMinimumExtent()) : Math.abs(this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.minExtentFactor;
    }

    public final void setBoundedRangeModel(@NotNull MutableBoundedInterval boundedRangeModel) {
        Intrinsics.checkNotNullParameter((Object)boundedRangeModel, (String)"boundedRangeModel");
        if (this.boundedRangeModel != null) {
            this.boundedRangeModel.removeIntervalListener(this.listener);
        }
        this.boundedRangeModel = boundedRangeModel;
        if (this.boundedRangeModel == null) {
            throw new RuntimeException("Debug: Null range model");
        }
        RangeSliderEvent eventRange = new RangeSliderEvent(this, this, boundedRangeModel.getMinimum(), boundedRangeModel.getMaximum(), this.boundedRangeModel.getMinimum(), this.boundedRangeModel.getMaximum());
        this.boundedRangeModel.addIntervalListener(this.listener);
        this.notifySliderScaleChanged(eventRange);
    }

    @Override
    public void addSliderListener(@NotNull RangeSliderListener rangeSliderListener2) {
        Intrinsics.checkNotNullParameter((Object)rangeSliderListener2, (String)"rangeSliderListener");
        this.sliderListeners.add(rangeSliderListener2);
    }

    @Override
    public void removeSliderListener(@NotNull RangeSliderListener rangeSliderListener2) {
        Intrinsics.checkNotNullParameter((Object)rangeSliderListener2, (String)"rangeSliderListener");
        this.sliderListeners.remove(rangeSliderListener2);
    }

    private final void notifySliderChanged(RangeSliderEvent eventRange) {
        for (RangeSliderListener sliderListener : this.sliderListeners) {
            sliderListener.sliderChanged(eventRange);
        }
    }

    private final void notifySliderScaleChanged(RangeSliderEvent eventRange) {
        for (RangeSliderListener sliderListener : this.sliderListeners) {
            sliderListener.sliderScaleChanged(eventRange);
        }
    }

    @NotNull
    public String toString() {
        return this.boundedRangeModel.toString();
    }

    @Override
    public boolean isInvertedScale() {
        return this.boundedRangeModel.getMinimum() > this.boundedRangeModel.getMaximum();
    }

    public final void setResetStrategy(@NotNull ResetStrategy resetStrategy2) {
        Intrinsics.checkNotNullParameter((Object)resetStrategy2, (String)"resetStrategy");
        this.resetStrategy = resetStrategy2;
    }

    public static final /* synthetic */ void access$notifySliderChanged(BoundedIntervalRangeSliderAdapter $this, RangeSliderEvent eventRange) {
        $this.notifySliderChanged(eventRange);
    }

    public static final /* synthetic */ RangeSliderModel access$getSelf(BoundedIntervalRangeSliderAdapter $this) {
        return $this.getSelf();
    }

    public static final /* synthetic */ void access$notifySliderScaleChanged(BoundedIntervalRangeSliderAdapter $this, RangeSliderEvent eventRange) {
        $this.notifySliderScaleChanged(eventRange);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/macrofocus/slider/BoundedIntervalRangeSliderAdapter$ResetStrategy;", "", "reset", "", "macrofocus-slider"})
    public static interface ResetStrategy {
        public void reset();
    }
}

