/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot.guide

import com.macrofocus.common.format.CPFormat
import com.macrofocus.common.geom.Dimension
import org.mkui.component.CPComponent
import org.mkui.geom.Rectangle
import org.mkui.graphics.IGraphics

interface Guide : CPComponent {
    enum class Type {
        Top, Bottom, Left, Right
    }

    fun paintComponent(g: IGraphics)
    fun computeSpace(g2: IGraphics, dataArea: Rectangle): Double
    fun setFormat(format: CPFormat<Any?>?)
    fun drawGrid(g2: IGraphics, d: Dimension)
    fun setAxis(axis: ValueAxis<*, *>)
    fun addListener(listener: Listener)
    fun invalidate()
    fun revalidate()
    fun repaint()
    val size: Dimension?
    val width: Int
    val height: Int
    fun setSize(width: Int, height: Int)
    val graphics: IGraphics?
    val preferredSize: Dimension?

    interface Listener {
        fun guideChanged()
    }
}