package com.macrofocus.plot.guide

import kotlin.jvm.Strictfp

/** Represents an immutable range of values.  */
@Strictfp
open class Range(lower: Double, upper: Double) {
    /**
     * Returns the lower bound for the range.
     *
     * @return The lower bound.
     */
    /** The lower bound of the range.  */
    val lowerBound: Double
    /**
     * Returns the upper bound for the range.
     *
     * @return The upper bound.
     */
    /** The upper bound of the range.  */
    val upperBound: Double

    /**
     * Returns the length of the range.
     *
     * @return The length.
     */
    val length: Double
        get() = upperBound - lowerBound

    /**
     * Returns `true` if the range contains the specified value and
     * `false` otherwise.
     *
     * @param value the value to lookup.
     *
     * @return `true` if the range contains the specified value.
     */
    operator fun contains(value: Double): Boolean {
        return value >= lowerBound && value <= upperBound
    }

    /**
     * Creates a new range.
     *
     * @param lower the lower bound (must be <= upper bound).
     * @param upper the upper bound (must be >= lower bound).
     */
    init {
        lowerBound = lower
        upperBound = upper
    }
}