/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot.guide

import com.macrofocus.common.geom.Dimension
import com.macrofocus.common.transform.OneDScreenTransform
import org.mkui.graphics.IGraphics

class DefaultGridLineRenderer : GridLineRenderer {
    override fun drawGridLine(g2: IGraphics, type: Guide.Type, coordinateAxis: OneDScreenTransform, d: Dimension, value: Double) {
        val x: Int = coordinateAxis.worldToScreen(value)
        when (type) {
            Guide.Type.Top, Guide.Type.Bottom -> g2.drawLine(x, 0, x, d.iheight)
            Guide.Type.Left, Guide.Type.Right -> g2.drawLine(0, x, d.iwidth, x)
        }
    }
}