package com.macrofocus.plot.guide

import com.macrofocus.plot.datetime.CPCalendar

/** An enumeration of the unit types for a [DateTickUnit] instance.  */
class DateTickUnitType
/**
 * Private constructor.
 *
 * @param calendarField the calendar field.
 */ private constructor(
    /** The corresponding field value in Java's Calendar class.  */
    val calendarField: Int
) {
    /**
     * Returns the calendar field.
     *
     * @return The calendar field.
     */

    companion object {
        /** Year.  */
        val YEAR = DateTickUnitType(CPCalendar.YEAR)

        /** Month.  */
        val MONTH = DateTickUnitType(CPCalendar.MONTH)

        /** Day.  */
        val DAY = DateTickUnitType(CPCalendar.DATE)

        /** Hour.  */
        val HOUR = DateTickUnitType(
            CPCalendar.HOUR_OF_DAY
        )

        /** Minute.  */
        val MINUTE = DateTickUnitType(CPCalendar.MINUTE)

        /** Second.  */
        val SECOND = DateTickUnitType(CPCalendar.SECOND)

        /** Millisecond.  */
        val MILLISECOND = DateTickUnitType(
            CPCalendar.MILLISECOND
        )
    }
}