package com.macrofocus.plot.datetime

import kotlinx.datetime.*

actual class CPCalendar actual constructor() {
    actual fun get(field: Int): Int {
        when (field) {
            YEAR -> return time!!.toLocalDateTime(TimeZone.UTC).year
            MONTH -> return time!!.toLocalDateTime(TimeZone.UTC).monthNumber - 1
            DATE -> return time!!.toLocalDateTime(TimeZone.UTC).dayOfMonth
            HOUR_OF_DAY -> return time!!.toLocalDateTime(TimeZone.UTC).hour
            MINUTE -> return time!!.toLocalDateTime(TimeZone.UTC).minute
            SECOND -> return time!!.toLocalDateTime(TimeZone.UTC).second
            MILLISECOND -> return time!!.toLocalDateTime(TimeZone.UTC).nanosecond / 1000
        }
        throw UnsupportedOperationException()
    }

    actual fun setAll(years: Int, months: Int, days: Int, hours: Int, minutes: Int, seconds: Int) {
        time = LocalDateTime(years, months + 1, days, hours, minutes, seconds).toInstant(TimeZone.UTC)
//        set(YEAR, years)
//        set(MONTH, months)
//        set(DATE, days)
//        set(HOUR_OF_DAY, hours)
//        set(MINUTE, minutes)
//        set(SECOND, seconds)
    }

    actual var time: Instant? = Clock.System.now()

    actual fun set(field: Int, i: Int) {
        when (field) {
            YEAR -> time = time!!.modify(year = i)
            MONTH -> time = time!!.modify(month = Month(i + 1))
            DATE -> time = time!!.modify( dayOfMonth = i + 1)
            HOUR_OF_DAY -> time = time!!.modify(hour = i)
            MINUTE -> time = time!!.modify(minute = i)
            SECOND -> time = time!!.modify(second = i)
            MILLISECOND -> time = time!!.modify(millisecond = i)
        }
    }

    actual fun clear(field: Int) {
        when (field) {
            YEAR -> time = time!!.modify(year = 0)
            MONTH -> time = time!!.modify(month = Month(1))
            DATE -> time = time!!.modify( dayOfMonth = 1)
            HOUR_OF_DAY -> time = time!!.modify(hour = 0)
            MINUTE -> time = time!!.modify(minute = 0)
            SECOND -> time = time!!.modify(second = 0)
            MILLISECOND -> time = time!!.modify(millisecond = 0)
        }
    }

    actual fun add(field: Int, multiple: Int) {
        when (field) {
            YEAR -> time = time!!.plus(multiple, DateTimeUnit.YEAR, TimeZone.UTC)
            MONTH -> time = time!!.plus(multiple, DateTimeUnit.MONTH, TimeZone.UTC)
            DATE -> time = time!!.plus(multiple, DateTimeUnit.DAY, TimeZone.UTC)
            HOUR_OF_DAY -> time = time!!.plus(multiple, DateTimeUnit.HOUR, TimeZone.UTC)
            MINUTE -> time = time!!.plus(multiple, DateTimeUnit.MINUTE, TimeZone.UTC)
            SECOND -> time = time!!.plus(multiple, DateTimeUnit.SECOND, TimeZone.UTC)
            MILLISECOND -> time = time!!.plus(multiple, DateTimeUnit.MILLISECOND, TimeZone.UTC)
        }
    }

    actual companion object {
        /**
         * Field number for `get` and `set` indicating the
         * year. This is a calendar-specific value; see subclass documentation.
         */
        actual const val YEAR: Int = 1

        /**
         * Field number for `get` and `set` indicating the
         * month. This is a calendar-specific value. The first month of
         * the year in the Gregorian and Julian calendars is
         * `JANUARY` which is 0; the last depends on the number
         * of months in a year.
         */
        actual const val MONTH: Int = 2

        /**
         * Field number for `get` and `set` indicating the
         * day of the month. This is a synonym for `DAY_OF_MONTH`.
         * The first day of the month has value 1.
         */
        actual const val DATE: Int = 5

        /**
         * Field number for `get` and `set` indicating the
         * hour of the day. `HOUR_OF_DAY` is used for the 24-hour clock.
         * E.g., at 10:04:15.250 PM the `HOUR_OF_DAY` is 22.
         */
        actual const val HOUR_OF_DAY: Int = 11

        /**
         * Field number for `get` and `set` indicating the
         * minute within the hour.
         * E.g., at 10:04:15.250 PM the `MINUTE` is 4.
         */
        actual const val MINUTE: Int = 12

        /**
         * Field number for `get` and `set` indicating the
         * second within the minute.
         * E.g., at 10:04:15.250 PM the `SECOND` is 15.
         */
        actual const val SECOND: Int = 13

        /**
         * Field number for `get` and `set` indicating the
         * millisecond within the second.
         * E.g., at 10:04:15.250 PM the `MILLISECOND` is 250.
         */
        actual const val MILLISECOND: Int = 14

        /**
         * Value of the [.MONTH] field indicating the
         * first month of the year in the Gregorian and Julian calendars.
         */
        actual const val JANUARY: Int = 0

        /**
         * Value of the [.MONTH] field indicating the
         * second month of the year in the Gregorian and Julian calendars.
         */
        actual const val FEBRUARY: Int = 1

        /**
         * Value of the [.MONTH] field indicating the
         * third month of the year in the Gregorian and Julian calendars.
         */
        actual const val MARCH: Int = 2

        /**
         * Value of the [.MONTH] field indicating the
         * fourth month of the year in the Gregorian and Julian calendars.
         */
        actual const val APRIL: Int = 3

        /**
         * Value of the [.MONTH] field indicating the
         * fifth month of the year in the Gregorian and Julian calendars.
         */
        actual const val MAY: Int = 4

        /**
         * Value of the [.MONTH] field indicating the
         * sixth month of the year in the Gregorian and Julian calendars.
         */
        actual const val JUNE: Int = 5

        /**
         * Value of the [.MONTH] field indicating the
         * seventh month of the year in the Gregorian and Julian calendars.
         */
        actual const val JULY: Int = 6

        /**
         * Value of the [.MONTH] field indicating the
         * eighth month of the year in the Gregorian and Julian calendars.
         */
        actual const val AUGUST: Int = 7

        /**
         * Value of the [.MONTH] field indicating the
         * ninth month of the year in the Gregorian and Julian calendars.
         */
        actual const val SEPTEMBER: Int = 8

        /**
         * Value of the [.MONTH] field indicating the
         * tenth month of the year in the Gregorian and Julian calendars.
         */
        actual const val OCTOBER: Int = 9

        /**
         * Value of the [.MONTH] field indicating the
         * eleventh month of the year in the Gregorian and Julian calendars.
         */
        actual const val NOVEMBER: Int = 10

        /**
         * Value of the [.MONTH] field indicating the
         * twelfth month of the year in the Gregorian and Julian calendars.
         */
        actual const val DECEMBER: Int = 11
    }

    fun Instant.modify(
        year: Int? = null,
        month: Month? = null,
        dayOfMonth: Int? = null,
        hour: Int? = null,
        minute: Int? = null,
        second: Int? = null,
        millisecond: Int? = null
    ): Instant {
        val localDateTime = toLocalDateTime(TimeZone.UTC)

        // Create a new LocalDateTime with modified values (default to existing values if null)
        val newLocalDateTime = LocalDateTime(
            year = year ?: localDateTime.year,
            month = month ?: localDateTime.month,
            dayOfMonth = dayOfMonth ?: localDateTime.dayOfMonth,
            hour = hour ?: localDateTime.hour,
            minute = minute ?: localDateTime.minute,
            second = second ?: localDateTime.second,
            nanosecond = millisecond?.times(1000) ?: localDateTime.nanosecond
        )

        // Convert back to Instant
        return newLocalDateTime.toInstant(TimeZone.UTC)
    }
}