@file:OptIn(ExperimentalTime::class)

package com.macrofocus.plot.datetime

import kotlin.time.ExperimentalTime
import kotlin.time.Instant

expect class CPCalendar() {
    fun get(field: Int): Int

    fun setAll(years: Int, months: Int, days: Int, hours: Int, minutes: Int, seconds: Int)

    var time: Instant?

    fun set(field: Int, i: Int)

    fun clear(field: Int)

    fun add(field: Int, multiple: Int)

    companion object {
        /**
         * Field number for `get` and `set` indicating the
         * year. This is a calendar-specific value; see subclass documentation.
         */
        val YEAR: Int

        /**
         * Field number for `get` and `set` indicating the
         * month. This is a calendar-specific value. The first month of
         * the year in the Gregorian and Julian calendars is
         * `JANUARY` which is 0; the last depends on the number
         * of months in a year.
         */
        val MONTH: Int

        /**
         * Field number for `get` and `set` indicating the
         * day of the month. This is a synonym for `DAY_OF_MONTH`.
         * The first day of the month has value 1.
         */
        val DATE: Int

        /**
         * Field number for `get` and `set` indicating the
         * hour of the day. `HOUR_OF_DAY` is used for the 24-hour clock.
         * E.g., at 10:04:15.250 PM the `HOUR_OF_DAY` is 22.
         */
        val HOUR_OF_DAY: Int

        /**
         * Field number for `get` and `set` indicating the
         * minute within the hour.
         * E.g., at 10:04:15.250 PM the `MINUTE` is 4.
         */
        val MINUTE: Int

        /**
         * Field number for `get` and `set` indicating the
         * second within the minute.
         * E.g., at 10:04:15.250 PM the `SECOND` is 15.
         */
        val SECOND: Int

        /**
         * Field number for `get` and `set` indicating the
         * millisecond within the second.
         * E.g., at 10:04:15.250 PM the `MILLISECOND` is 250.
         */
        val MILLISECOND: Int

        /**
         * Value of the [.MONTH] field indicating the
         * first month of the year in the Gregorian and Julian calendars.
         */
        val JANUARY: Int

        /**
         * Value of the [.MONTH] field indicating the
         * second month of the year in the Gregorian and Julian calendars.
         */
        val FEBRUARY: Int

        /**
         * Value of the [.MONTH] field indicating the
         * third month of the year in the Gregorian and Julian calendars.
         */
        val MARCH: Int

        /**
         * Value of the [.MONTH] field indicating the
         * fourth month of the year in the Gregorian and Julian calendars.
         */
        val APRIL: Int

        /**
         * Value of the [.MONTH] field indicating the
         * fifth month of the year in the Gregorian and Julian calendars.
         */
        val MAY: Int

        /**
         * Value of the [.MONTH] field indicating the
         * sixth month of the year in the Gregorian and Julian calendars.
         */
        val JUNE: Int

        /**
         * Value of the [.MONTH] field indicating the
         * seventh month of the year in the Gregorian and Julian calendars.
         */
        val JULY: Int

        /**
         * Value of the [.MONTH] field indicating the
         * eighth month of the year in the Gregorian and Julian calendars.
         */
        val AUGUST: Int

        /**
         * Value of the [.MONTH] field indicating the
         * ninth month of the year in the Gregorian and Julian calendars.
         */
        val SEPTEMBER: Int

        /**
         * Value of the [.MONTH] field indicating the
         * tenth month of the year in the Gregorian and Julian calendars.
         */
        val OCTOBER: Int

        /**
         * Value of the [.MONTH] field indicating the
         * eleventh month of the year in the Gregorian and Julian calendars.
         */
        val NOVEMBER: Int

        /**
         * Value of the [.MONTH] field indicating the
         * twelfth month of the year in the Gregorian and Julian calendars.
         */
        val DECEMBER: Int
    }
}