package com.macrofocus.plot.guide
/**
 * An interface that defines the contract for a Timeline.
 *
 *
 * A Timeline will present a series of values to be used for an axis. Each
 * Timeline must provide transformation methods between domain values and
 * timeline values.
 *
 *
 * A timeline can be used as parameter to a
 * [DateAxis] to define the values that this axis
 * supports. As an example, the
 * implements a timeline formed by segments of equal length (ex. days, hours,
 * minutes) where some segments can be included in the timeline and others
 * excluded. Therefore timelines like "working days" or "working hours" can be
 * created where non-working days or non-working hours respectively can be
 * removed from the timeline, and therefore from the axis. This creates a smooth
 * plot with equal separation between all included segments.
 *
 *
 * Because Timelines were created mainly for Date related axis, values are
 * represented as longs instead of doubles. In this case, the domain value is
 * just the number of milliseconds since January 1, 1970, 00:00:00 GMT as
 * defined by the getTime() method of [Date].
 *
 * @see DateAxis
 */
internal interface Timeline {
    /**
     * Translates a millisecond (as defined by java.util.Date) into an index
     * along this timeline.
     *
     * @param millisecond the millisecond.
     *
     * @return A timeline value.
     */
    fun toTimelineValue(millisecond: Long): Long

    /**
     * Returns `true` if a date is contained in the timeline values.
     *
     * @return `true` if value is contained in the timeline and
     * `false`  otherwise.
     */
    fun containsDomainValue(): Boolean
}