/*
 * Copyright (c) 2005 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.slider

import com.macrofocus.common.math.Histogram

interface RangeSliderModel {
    val currentMinimum: Double
    val currentExtent: Double
    val currentMaximum: Double
    val minimum: Double
    val maximum: Double
    val extent: Double
    val minimumExtent: Double
    val maximumExtent: Double
    val upperMinimumValue: Double
    val upperMaximumValue: Double
    val lowerMinimumValue: Double
    val lowerMaximumValue: Double
    fun setValues(source: Any, rangeMin: Double, rangeMax: Double)
    fun setMinMax(source: Any, min: Double, max: Double)
    fun reset(source: Any)
    fun addSliderListener(rangeSliderListener: RangeSliderListener)
    fun removeSliderListener(rangeSliderListener: RangeSliderListener)
    val isInvertedScale: Boolean
    val isFullRange: Boolean
    val histogram: Histogram?
}