package com.macrofocus.plot.guide
/** Used to indicate the edge of a rectangle.  */
enum class RectangleEdge {
    Top, Bottom, Left, Right;

    companion object {
        /**
         * Returns `true` if the edge is `Top` or
         * `Bottom`, and `false` otherwise.
         *
         * @param edge the edge.
         *
         * @return A boolean.
         */
        fun isTopOrBottom(edge: RectangleEdge): Boolean {
            return edge == Top || edge == Bottom
        }

        /**
         * Returns `true` if the edge is `Left` or
         * `Right`, and `false` otherwise.
         *
         * @param edge the edge.
         *
         * @return A boolean.
         */
        fun isLeftOrRight(edge: RectangleEdge): Boolean {
            return edge == Left || edge == Right
        }
    }
}