/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot.guide

import com.macrofocus.common.geom.Dimension
import com.macrofocus.plot.AxisPlotPanel
import org.mkui.graphics.IGraphics
import org.mkui.graphics.SwingIGraphics
import java.awt.Font
import java.awt.Graphics
import java.awt.Graphics2D
import java.awt.RenderingHints
import java.awt.event.ComponentListener
import javax.swing.JComponent

abstract class AbstractSwingGuide : AbstractGuide() {
    override val nativeComponent: JComponent = NativeComponent()
    fun setPanel(panel: AxisPlotPanel?) {}
    fun addComponentListener(componentListener: ComponentListener?) {
        nativeComponent.addComponentListener(componentListener)
    }

    override fun invalidate() {
        nativeComponent.invalidate()
    }

    override fun revalidate() {
        nativeComponent.revalidate()
    }

    fun validateParent() {
        if (nativeComponent.getParent() != null) {
            nativeComponent.getParent().validate()
        }
    }

    override fun repaint() {
        nativeComponent.repaint()
    }

    override val width: Int
        get() = nativeComponent.getWidth()
    override val height: Int
        get() = nativeComponent.getHeight()
    override val size: Dimension
        get() {
            val d = nativeComponent.getSize()
            return Dimension(d.width, d.height)
        }


    override fun setSize(width: Int, height: Int) {
        nativeComponent.setSize(width, height)
    }

    override val graphics: IGraphics
        get() = SwingIGraphics(nativeComponent.getGraphics() as Graphics2D)
    override val preferredSize: Dimension?
        get() = null

    fun setOpaque(opaque: Boolean) {
        nativeComponent.setOpaque(opaque)
    }

    /**
     * Callback
     *
     * @param font
     */
    open fun setFont(font: Font?) {}
    fun setStyleClass(vararg styleClasses: String?) {}

    private inner class NativeComponent : JComponent() {
        protected override fun paintComponent(g: Graphics) {
            super.paintComponent(g)
            val g2: Graphics2D = g as Graphics2D
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON)
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON)
            paintComponent(SwingIGraphics(g2))
        }

        override fun setFont(font: Font) {
            super.setFont(font)
            this@AbstractSwingGuide.setFont(font)
        }

        override fun getPreferredSize(): java.awt.Dimension {
            val d = preferredSize
            return d ?: super.getPreferredSize()
        }
    }
}