/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.plot.guide.Axis;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.RectangleInsets;
import com.macrofocus.plot.guide.ValueTick;
import java.awt.Font;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontFactory;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 **\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001*B!\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%J&\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020!2\u0006\u0010$\u001a\u00020%H&R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/macrofocus/plot/guide/AbstractAxis;", "Color", "Font", "Lcom/macrofocus/plot/guide/Axis;", "fontFactory", "Lorg/mkui/font/CPFontFactory;", "headless", "Lorg/mkui/graphics/IHeadless;", "label", "", "(Lorg/mkui/font/CPFontFactory;Lorg/mkui/graphics/IHeadless;Ljava/lang/String;)V", "getHeadless", "()Lorg/mkui/graphics/IHeadless;", "isTickLabelsVisible", "", "()Z", "isVisible", "labelAngle", "", "labelFont", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "labelInsets", "Lcom/macrofocus/plot/guide/RectangleInsets;", "tickLabelFont", "getTickLabelFont", "()Ljava/awt/Font;", "setTickLabelFont", "(Ljava/awt/Font;)V", "tickLabelInsets", "getTickLabelInsets", "()Lcom/macrofocus/plot/guide/RectangleInsets;", "getLabelEnclosure", "Lorg/mkui/geom/Rectangle2D;", "g2", "Lorg/mkui/graphics/IGraphics;", "edge", "Lcom/macrofocus/plot/guide/RectangleEdge;", "refreshTicks", "", "Lcom/macrofocus/plot/guide/ValueTick;", "dataArea", "Companion", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public abstract class AbstractAxis<Color, Font>
implements Axis<Color, Font> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String label;
    private final boolean isVisible;
    @Nullable
    private final Font labelFont;
    @NotNull
    private final RectangleInsets labelInsets;
    private final double labelAngle;
    private final boolean isTickLabelsVisible;
    @Nullable
    private Font tickLabelFont;
    @NotNull
    private final RectangleInsets tickLabelInsets;
    @NotNull
    private final IHeadless headless;
    public static final int $stable = 8;
    private static final boolean DEFAULT_AXIS_VISIBLE = true;
    @NotNull
    private static final RectangleInsets DEFAULT_AXIS_LABEL_INSETS = new RectangleInsets(3.0, 3.0, 3.0, 3.0);
    private static final boolean DEFAULT_TICK_LABELS_VISIBLE = true;
    @NotNull
    private static final RectangleInsets DEFAULT_TICK_LABEL_INSETS = new RectangleInsets(2.0, 4.0, 2.0, 4.0);

    protected AbstractAxis(@NotNull CPFontFactory fontFactory, @NotNull IHeadless headless, @Nullable String label) {
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        this.label = label;
        this.isVisible = true;
        this.labelFont = fontFactory.createFont("SansSerif", 0, 12);
        this.labelInsets = DEFAULT_AXIS_LABEL_INSETS;
        this.labelAngle = 0.0;
        this.isTickLabelsVisible = true;
        this.setTickLabelFont(fontFactory.createFont("SansSerif", 0, 10));
        this.tickLabelInsets = DEFAULT_TICK_LABEL_INSETS;
        this.headless = headless;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean isTickLabelsVisible() {
        return this.isTickLabelsVisible;
    }

    @Override
    @Nullable
    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    @Override
    public void setTickLabelFont(@Nullable Font font) {
        this.tickLabelFont = font;
    }

    @Override
    @NotNull
    public RectangleInsets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    @NotNull
    protected final IHeadless getHeadless() {
        return this.headless;
    }

    @NotNull
    public abstract List<ValueTick> refreshTicks(@NotNull IGraphics var1, @NotNull Rectangle2D var2, @NotNull RectangleEdge var3);

    @NotNull
    public final Rectangle2D getLabelEnclosure(@Nullable IGraphics g2, @NotNull RectangleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        String axisLabel = this.label;
        if (axisLabel != null && !(((CharSequence)axisLabel).length() == 0)) {
            Shape labelBounds;
            Rectangle2D b = this.headless.getStringBounds(g2, this.labelFont, axisLabel);
            Rectangle2D bounds = (Rectangle2D)new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
            RectangleInsets insets = this.labelInsets;
            bounds = insets.createOutsetRectangle(bounds);
            double angle = this.labelAngle;
            if (edge == RectangleEdge.Left || edge == RectangleEdge.Right) {
                angle -= 1.5707963267948966;
            }
            double x = bounds.getCenterX();
            double y = bounds.getCenterY();
            AffineTransform transformer = AffineTransform.Companion.getRotateInstance(angle, x, y);
            Shape shape = labelBounds = transformer.createTransformedShape((Shape)bounds);
            Intrinsics.checkNotNull((Object)shape);
            return shape.getBounds2D();
        }
        return (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/macrofocus/plot/guide/AbstractAxis$Companion;", "", "()V", "DEFAULT_AXIS_LABEL_INSETS", "Lcom/macrofocus/plot/guide/RectangleInsets;", "DEFAULT_AXIS_VISIBLE", "", "DEFAULT_TICK_LABELS_VISIBLE", "DEFAULT_TICK_LABEL_INSETS", "macrofocus-slider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

