/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactory;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.transform.OneDScreenTransform;
import com.macrofocus.common.transform.ScreenTransformEvent;
import com.macrofocus.common.transform.ScreenTransformListener;
import com.macrofocus.plot.guide.AbstractSwingGuide;
import com.macrofocus.plot.guide.AxisGuide;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.GridRenderer;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.NumberAxis;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.plot.guide.ValueTick;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.font.CPFontFactory;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;
import org.mkui.graphics.SwingIHeadless;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u0011\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001aH\u0016J\b\u0010$\u001a\u00020\u001eH\u0002J\u0018\u0010%\u001a\u00020\u001e2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0016J\u0012\u0010&\u001a\u00020\u001e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010'\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u001a\u0010*\u001a\u00020\u001e2\u0010\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000fH\u0016J\u0012\u0010+\u001a\u00020\u001e2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013J\u0012\u0010,\u001a\u00020\u001e2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013J\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010.\u001a\u00020/H\u0016R\u0018\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/macrofocus/plot/guide/AbstractSwingAxisGuide;", "Lcom/macrofocus/plot/guide/AbstractSwingGuide;", "Lcom/macrofocus/plot/guide/AxisGuide;", "type", "Lcom/macrofocus/plot/guide/Guide$Type;", "coordinateAxis", "Lcom/macrofocus/common/transform/OneDScreenTransform;", "(Lcom/macrofocus/plot/guide/Guide$Type;Lcom/macrofocus/common/transform/OneDScreenTransform;)V", "(Lcom/macrofocus/common/transform/OneDScreenTransform;)V", "(Lcom/macrofocus/plot/guide/Guide$Type;)V", "axis", "Lcom/macrofocus/plot/guide/ValueAxis;", "coordinateAxisListener", "Lcom/macrofocus/common/transform/ScreenTransformListener;", "format", "Lcom/macrofocus/common/format/CPFormat;", "", "gridLinesColor", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "labelColor", "paintTicks", "", "computeSpace", "", "g2", "Lorg/mkui/graphics/IGraphics;", "dataArea", "Lorg/mkui/geom/Rectangle;", "drawGrid", "", "d", "Lcom/macrofocus/common/geom/Dimension;", "getAxis", "paintComponent", "g", "refresh", "setAxis", "setCoordinateAxis", "setFont", "font", "Ljava/awt/Font;", "setFormat", "setGridLinesColor", "setLabelColor", "setPaintTicks", "toString", "", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public abstract class AbstractSwingAxisGuide
extends AbstractSwingGuide
implements AxisGuide {
    @NotNull
    private final Guide.Type type;
    @NotNull
    private Color labelColor;
    @NotNull
    private Color gridLinesColor;
    private boolean paintTicks;
    @NotNull
    private final ScreenTransformListener coordinateAxisListener;
    @Nullable
    private OneDScreenTransform coordinateAxis;
    @Nullable
    private ValueAxis<?, ?> axis;
    @Nullable
    private CPFormat<Object> format;
    public static final int $stable = 8;

    @JvmOverloads
    public AbstractSwingAxisGuide(@NotNull Guide.Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.labelColor = MkColorFactory.Companion.getInstance().getBlack();
        this.gridLinesColor = MkColorKt.colorOf((int)199, (int)199, (int)196);
        this.paintTicks = true;
        this.coordinateAxisListener = new ScreenTransformListener(this){
            final /* synthetic */ AbstractSwingAxisGuide this$0;
            {
                this.this$0 = $receiver;
            }

            public void transformChanged(@NotNull ScreenTransformEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AbstractSwingAxisGuide.access$refresh(this.this$0);
            }
        };
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.refresh();
            }

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void componentShown(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.refresh();
            }

            @Override
            public void componentHidden(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    public /* synthetic */ AbstractSwingAxisGuide(Guide.Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            type = Guide.Type.Bottom;
        }
        this(type);
    }

    private final void refresh() {
        this.revalidate();
        this.repaint();
    }

    public AbstractSwingAxisGuide(@NotNull Guide.Type type, @Nullable OneDScreenTransform coordinateAxis) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type);
        this.setCoordinateAxis(coordinateAxis);
    }

    public AbstractSwingAxisGuide(@Nullable OneDScreenTransform coordinateAxis) {
        this(Guide.Type.Bottom);
        this.setCoordinateAxis(coordinateAxis);
    }

    @Override
    public void setCoordinateAxis(@Nullable OneDScreenTransform coordinateAxis) {
        if (this.coordinateAxis != null) {
            OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform);
            oneDScreenTransform.removeScreenTransformListener(this.coordinateAxisListener);
        }
        this.coordinateAxis = coordinateAxis;
        if (this.coordinateAxis != null) {
            OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform);
            oneDScreenTransform.addScreenTransformListener(this.coordinateAxisListener);
        }
        this.refresh();
    }

    @Override
    public double computeSpace(@NotNull IGraphics g2, @NotNull Rectangle dataArea) {
        double d;
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)dataArea, (String)"dataArea");
        AxisSpace space = new AxisSpace();
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Top, space);
                d = space.getBottom();
                break;
            }
            case 2: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom, space);
                d = space.getBottom() + (double)4;
                break;
            }
            case 3: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Left, space);
                d = space.getLeft();
                break;
            }
            case 4: {
                this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Right, space);
                d = space.getLeft();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return d;
    }

    @Override
    public void setFormat(@Nullable CPFormat<Object> format) {
        this.format = format;
        if (this.axis != null) {
            ValueAxis<?, ?> valueAxis = this.axis;
            Intrinsics.checkNotNull(valueAxis);
            valueAxis.setFormatOverride(this.format);
        }
        this.refresh();
    }

    @Override
    public void drawGrid(@NotNull IGraphics g2, @NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        GridRenderer gridRenderer = this.getGridRenderer();
        OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
        Intrinsics.checkNotNull((Object)oneDScreenTransform);
        gridRenderer.drawGrid(g2, this.type, oneDScreenTransform, this.getAxis(), this.getGridLineRenderer(), d);
    }

    @Override
    public void paintComponent(@NotNull IGraphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Dimension d = this.getSize();
        if (this.coordinateAxis != null) {
            OneDScreenTransform oneDScreenTransform = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform);
            double d2 = oneDScreenTransform.getWorldMin();
            OneDScreenTransform oneDScreenTransform2 = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform2);
            double min = Math.min(d2, oneDScreenTransform2.getWorldMax());
            OneDScreenTransform oneDScreenTransform3 = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform3);
            double d3 = oneDScreenTransform3.getWorldMin();
            OneDScreenTransform oneDScreenTransform4 = this.coordinateAxis;
            Intrinsics.checkNotNull((Object)oneDScreenTransform4);
            double max = Math.max(d3, oneDScreenTransform4.getWorldMax());
            if (min <= max) {
                List<ValueTick> list;
                Rectangle2D dataArea = (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, d.getWidth(), d.getHeight());
                this.getAxis().setRange(min, max);
                List<ValueTick> ticks = null;
                switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 1: {
                        list = this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Top);
                        break;
                    }
                    case 2: {
                        list = this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Bottom);
                        break;
                    }
                    case 3: {
                        list = this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Left);
                        break;
                    }
                    case 4: {
                        list = this.getAxis().refreshTicks(g, dataArea, RectangleEdge.Right);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                ticks = list;
                for (ValueTick tick : ticks) {
                    OneDScreenTransform oneDScreenTransform5 = this.coordinateAxis;
                    Intrinsics.checkNotNull((Object)oneDScreenTransform5);
                    int position = oneDScreenTransform5.worldToScreen(tick.getValue());
                    if (this.paintTicks) {
                        g.setColor(this.gridLinesColor);
                        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                            case 1: {
                                g.drawLine(position, d.getIheight() - 5, position, d.getIheight());
                                break;
                            }
                            case 2: {
                                g.drawLine(position, 0, position, 5);
                                break;
                            }
                            case 3: {
                                g.drawLine(d.getIwidth() - 5, position, d.getIwidth(), position);
                                break;
                            }
                            case 4: {
                                g.drawLine(0, position, 5, position);
                            }
                        }
                    }
                    g.setColor(this.labelColor);
                    String text = tick.getText();
                    CPFontMetrics fontMetrics = g.getFontMetrics();
                    int width = (int)g.getStringWidth(text);
                    switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                        case 1: {
                            float f = position - (width >> 1);
                            CPFontMetrics cPFontMetrics = fontMetrics;
                            Intrinsics.checkNotNull((Object)cPFontMetrics);
                            g.drawString(text, f, cPFontMetrics.getHeight());
                            break;
                        }
                        case 2: {
                            g.drawString(text, (float)(position - (width >> 1)), (float)(d.getHeight() - (double)2));
                            break;
                        }
                        case 3: {
                            float f = (float)(d.getWidth() - (double)width - (double)7);
                            CPFontMetrics cPFontMetrics = fontMetrics;
                            Intrinsics.checkNotNull((Object)cPFontMetrics);
                            g.drawString(text, f, (float)(position + (cPFontMetrics.getAscent() >> 1)));
                            break;
                        }
                        case 4: {
                            CPFontMetrics cPFontMetrics = fontMetrics;
                            Intrinsics.checkNotNull((Object)cPFontMetrics);
                            g.drawString(text, 7.0f, (float)(position + (cPFontMetrics.getAscent() >> 1)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void setFont(@Nullable Font font) {
        super.setFont(font);
        this.getAxis().setTickLabelFont(font);
    }

    private final ValueAxis<?, ?> getAxis() {
        if (this.axis == null) {
            this.axis = new NumberAxis(CPFontFactory.Companion.getInstance(), (IHeadless)new SwingIHeadless(), FormatFactory.Companion.getInstance());
            ValueAxis<?, ?> valueAxis = this.axis;
            Intrinsics.checkNotNull(valueAxis);
            valueAxis.setTickLabelFont(new Font("Tahoma", 0, 10));
            if (this.format != null) {
                ValueAxis<?, ?> valueAxis2 = this.axis;
                Intrinsics.checkNotNull(valueAxis2);
                valueAxis2.setFormatOverride(this.format);
            }
        }
        ValueAxis<?, ?> valueAxis = this.axis;
        Intrinsics.checkNotNull(valueAxis);
        return valueAxis;
    }

    @Override
    public void setAxis(@NotNull ValueAxis<?, ?> axis) {
        Intrinsics.checkNotNullParameter(axis, (String)"axis");
        this.axis = axis;
        this.refresh();
    }

    public final void setGridLinesColor(@NotNull Color gridLinesColor) {
        Intrinsics.checkNotNullParameter((Object)gridLinesColor, (String)"gridLinesColor");
        this.gridLinesColor = gridLinesColor;
        this.repaint();
    }

    public final void setLabelColor(@NotNull Color labelColor) {
        Intrinsics.checkNotNullParameter((Object)labelColor, (String)"labelColor");
        this.labelColor = labelColor;
        this.repaint();
    }

    public final void setPaintTicks(boolean paintTicks) {
        this.paintTicks = paintTicks;
        this.repaint();
    }

    @NotNull
    public String toString() {
        return "AbstractAxisGuide{coordinateAxis=" + this.coordinateAxis + ", axis=" + this.axis + "}";
    }

    @JvmOverloads
    public AbstractSwingAxisGuide() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Guide.Type.values().length];
            nArray[Guide.Type.Top.ordinal()] = 1;
            nArray[Guide.Type.Bottom.ordinal()] = 2;
            nArray[Guide.Type.Left.ordinal()] = 3;
            nArray[Guide.Type.Right.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

