/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.transform.OneDScreenTransform;
import com.macrofocus.plot.guide.GridLineRenderer;
import com.macrofocus.plot.guide.GridRenderer;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.plot.guide.ValueTick;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.IGraphics;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/plot/guide/DefaultGridRenderer;", "Lcom/macrofocus/plot/guide/GridRenderer;", "()V", "drawGrid", "", "g2", "Lorg/mkui/graphics/IGraphics;", "type", "Lcom/macrofocus/plot/guide/Guide$Type;", "coordinateAxis", "Lcom/macrofocus/common/transform/OneDScreenTransform;", "axis", "Lcom/macrofocus/plot/guide/ValueAxis;", "gridLineRenderer", "Lcom/macrofocus/plot/guide/GridLineRenderer;", "d", "Lcom/macrofocus/common/geom/Dimension;", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class DefaultGridRenderer
implements GridRenderer {
    public static final int $stable;

    @Override
    public void drawGrid(@NotNull IGraphics g2, @NotNull Guide.Type type, @NotNull OneDScreenTransform coordinateAxis, @NotNull ValueAxis<?, ?> axis, @NotNull GridLineRenderer gridLineRenderer, @NotNull Dimension d) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)coordinateAxis, (String)"coordinateAxis");
        Intrinsics.checkNotNullParameter(axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)gridLineRenderer, (String)"gridLineRenderer");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        double min = coordinateAxis.getWorldMin();
        double max = coordinateAxis.getWorldMax();
        if (min <= max) {
            List<ValueTick> list;
            Rectangle2D dataArea = (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, d.getWidth(), d.getHeight());
            axis.setRange(min, max);
            List<ValueTick> ticks = null;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    list = axis.refreshTicks(g2, dataArea, RectangleEdge.Top);
                    break;
                }
                case 2: {
                    list = axis.refreshTicks(g2, dataArea, RectangleEdge.Bottom);
                    break;
                }
                case 3: {
                    list = axis.refreshTicks(g2, dataArea, RectangleEdge.Left);
                    break;
                }
                case 4: {
                    list = axis.refreshTicks(g2, dataArea, RectangleEdge.Right);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ticks = list;
            for (ValueTick tick : ticks) {
                ValueTick t = tick;
                if (t.getText() == null || t.getText().length() <= 0) continue;
                double value = t.getValue();
                gridLineRenderer.drawGridLine(g2, type, coordinateAxis, d, value);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Guide.Type.values().length];
            nArray[Guide.Type.Top.ordinal()] = 1;
            nArray[Guide.Type.Bottom.ordinal()] = 2;
            nArray[Guide.Type.Left.ordinal()] = 3;
            nArray[Guide.Type.Right.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

